/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalYearMonthNode
extends JavaScriptBaseNode {
    protected ToTemporalYearMonthNode() {
    }

    public abstract JSTemporalPlainYearMonthObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainYearMonthObject toTemporalYearMonth(Object item, JSDynamicObject options, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalCalendarWithISODefaultNode getTemporalCalendarWithISODefaultNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
        assert (options != null);
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth((Object)itemObj)) {
                return (JSTemporalPlainYearMonthObject)itemObj;
            }
            JSDynamicObject calendar = getTemporalCalendarWithISODefaultNode.execute((Object)itemObj);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getLanguage().getJSContext(), itemObj, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendar, fields, options);
        }
        TemporalUtil.toTemporalOverflow(options, getOptionNode);
        TruffleString string = toStringNode.executeString(item);
        JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalYearMonthString(string);
        JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
        JSTemporalPlainYearMonthObject result2 = JSTemporalPlainYearMonth.create(this.getLanguage().getJSContext(), this.getRealm(), result.getYear(), result.getMonth(), calendar, result.getDay(), this, errorBranch);
        return yearMonthFromFieldsNode.execute(calendar, result2, Undefined.instance);
    }
}

