/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReadQuery;

public class BatchFetchPolicy
implements Serializable,
Cloneable {
    protected BatchFetchType type;
    protected int size = 500;
    protected List<Expression> attributeExpressions;
    protected List<DatabaseMapping> batchedMappings;
    protected transient Map<DatabaseMapping, ReadQuery> mappingQueries;
    protected List<String> attributes;
    protected transient Map<Object, List<AbstractRecord>> dataResults;
    protected transient Map<Object, Object> batchObjects;

    public BatchFetchPolicy() {
        this(BatchFetchType.JOIN);
    }

    public BatchFetchPolicy(BatchFetchType type) {
        this.type = type;
        this.dataResults = new HashMap<Object, List<AbstractRecord>>();
        this.dataResults.put(this, new ArrayList());
    }

    public BatchFetchPolicy clone() {
        BatchFetchPolicy clone = null;
        try {
            clone = (BatchFetchPolicy)super.clone();
        }
        catch (CloneNotSupportedException error) {
            throw new InternalError(error.getMessage());
        }
        HashMap<Object, List<AbstractRecord>> dataResults = new HashMap<Object, List<AbstractRecord>>();
        if (this.dataResults != null && this.dataResults.containsKey(this)) {
            ArrayList list = new ArrayList(this.dataResults.get(this));
            dataResults.put(clone, list);
        }
        clone.setDataResults(dataResults);
        if (this.attributeExpressions != null) {
            clone.attributeExpressions = new ArrayList<Expression>(this.attributeExpressions);
        }
        return clone;
    }

    public boolean isIN() {
        return this.type == BatchFetchType.IN;
    }

    public boolean isJOIN() {
        return this.type == BatchFetchType.JOIN;
    }

    public boolean isEXISTS() {
        return this.type == BatchFetchType.EXISTS;
    }

    public BatchFetchType getType() {
        return this.type;
    }

    public void setType(BatchFetchType type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Map<DatabaseMapping, ReadQuery> getMappingQueries() {
        return this.mappingQueries;
    }

    public void setMappingQueries(Map<DatabaseMapping, ReadQuery> mappingQueries) {
        this.mappingQueries = mappingQueries;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public void setAttributeExpressions(List<Expression> attributeExpressions) {
        this.attributeExpressions = attributeExpressions;
    }

    public List<Expression> getAttributeExpressions() {
        if (this.attributeExpressions == null) {
            this.attributeExpressions = new ArrayList<Expression>();
        }
        return this.attributeExpressions;
    }

    public boolean hasAttributes() {
        return this.attributeExpressions != null && !this.attributeExpressions.isEmpty() || this.batchedMappings != null;
    }

    public List<DatabaseMapping> getBatchedMappings() {
        return this.batchedMappings;
    }

    public void setBatchedMappings(List<DatabaseMapping> batchedMappings) {
        this.batchedMappings = batchedMappings;
    }

    public boolean isAttributeBatchRead(String attributeName) {
        if (this.attributeExpressions == null) {
            return false;
        }
        List<Expression> batchReadAttributeExpressions = this.attributeExpressions;
        int size = batchReadAttributeExpressions.size();
        int index = 0;
        while (index < size) {
            QueryKeyExpression expression = (QueryKeyExpression)batchReadAttributeExpressions.get(index);
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (expression.getName().equals(attributeName)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean isAttributeBatchRead(ClassDescriptor mappingDescriptor, String attributeName) {
        if (this.attributeExpressions == null) {
            return false;
        }
        if (this.attributes != null) {
            return this.attributes.contains(attributeName);
        }
        return this.isAttributeBatchRead(attributeName);
    }

    public void addDataResults(AbstractRecord row) {
        for (List<AbstractRecord> results : this.dataResults.values()) {
            results.add(row);
        }
    }

    public List<AbstractRecord> getDataResults(DatabaseMapping mapping) {
        List<AbstractRecord> result = this.dataResults.get(mapping);
        if (result == null) {
            result = this.dataResults.get(this);
            this.dataResults.put(mapping, result);
        }
        return result;
    }

    public void setDataResults(DatabaseMapping mapping, List<AbstractRecord> rows) {
        this.dataResults.put(mapping, rows);
    }

    public void setDataResults(List<AbstractRecord> rows) {
        this.dataResults = new HashMap<Object, List<AbstractRecord>>();
        this.dataResults.put(this, rows);
    }

    public List<AbstractRecord> getAllDataResults() {
        return this.dataResults.get(this);
    }

    public Map<Object, List<AbstractRecord>> getDataResults() {
        return this.dataResults;
    }

    public void setDataResults(Map<Object, List<AbstractRecord>> dataResults) {
        this.dataResults = dataResults;
    }

    public Map<Object, Object> getBatchObjects() {
        return this.batchObjects;
    }

    public void setBatchObjects(Map<Object, Object> batchObjects) {
        this.batchObjects = batchObjects;
    }
}

