/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui;

import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpdoc.ui.Bundle;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;

public class PhpDocPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public PhpDocPreferencesValidator validatePhpModule(PhpModule phpModule) {
        this.validateTarget(PhpDocPreferences.getPhpDocTarget(phpModule, false));
        this.validateTitle(PhpDocPreferences.getPhpDocTitle(phpModule));
        this.validateConfiguration(PhpDocPreferences.isConfigurationEnabled(phpModule), PhpDocPreferences.getPhpDocConfigurationPath(phpModule));
        return this;
    }

    public PhpDocPreferencesValidator validateTarget(String targetPath) {
        this.validateDirectory(true, targetPath, Bundle.PhpDocPreferencesValidator_target_label(), "targetPath");
        if (!StringUtils.hasText((String)targetPath)) {
            this.result.addWarning(new ValidationResult.Message((Object)"targetPath", Bundle.PhpDocPreferencesValidator_message_ask_for_dir()));
        }
        return this;
    }

    public PhpDocPreferencesValidator validateTitle(String title) {
        if (!StringUtils.hasText((String)title)) {
            this.result.addError(new ValidationResult.Message((Object)"title", Bundle.PhpDocPreferencesValidator_message_invalid_title()));
        }
        return this;
    }

    public PhpDocPreferencesValidator validateConfiguration(boolean configurationEnabled, String configurationPath) {
        this.validatePath(configurationEnabled, configurationPath, Bundle.PhpDocPreferencesValidator_configuration_label(), "configurationPath");
        return this;
    }

    private void validateDirectory(boolean pathEnabled, String path, String label, String source) {
        String error;
        if (!pathEnabled) {
            return;
        }
        if (StringUtils.hasText((String)path) && (error = FileUtils.validateDirectory((String)label, (String)path, (boolean)true)) != null) {
            this.result.addError(new ValidationResult.Message((Object)source, error));
        }
    }

    private void validatePath(boolean pathEnabled, String path, String label, String source) {
        if (!pathEnabled) {
            return;
        }
        String warning = FileUtils.validateFile((String)label, (String)path, (boolean)false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)source, warning));
        }
    }
}

