/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.annotation;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.ScopeAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

abstract class CdiAnnotationAnalyzer
extends TargetAnalyzer {
    private WebBeansModel myModel;
    private CdiAnalysisResult myResult;

    CdiAnnotationAnalyzer(TypeElement element, CdiAnalysisResult result) {
        this.init((Element)element, result.getInfo());
        this.myResult = result;
    }

    CdiAnnotationAnalyzer(TypeElement element, WebBeansModel model, CdiAnalysisResult result) {
        this.init((Element)element, (CompilationInfo)model.getCompilationController());
        this.myModel = model;
        this.myResult = result;
    }

    @Override
    protected void handleNoTarget() {
        if (this.myResult == null) {
            return;
        }
        Element subject = this.getElement();
        if (this.myModel != null) {
            ElementHandle handle = ElementHandle.create((Element)this.getElement());
            subject = handle.resolve(this.getResult().getInfo());
        }
        if (subject == null) {
            return;
        }
        this.myResult.addError(subject, NbBundle.getMessage(ScopeAnalyzer.class, (String)"ERR_NoTarget", (Object)this.getCdiMetaAnnotation()));
    }

    @Override
    protected void handleNoRetention() {
        if (this.myResult == null) {
            return;
        }
        Element subject = this.getElement();
        if (this.myModel != null) {
            ElementHandle handle = ElementHandle.create((Element)this.getElement());
            subject = handle.resolve(this.getResult().getInfo());
        }
        if (subject == null) {
            return;
        }
        this.myResult.addError(subject, NbBundle.getMessage(ScopeAnalyzer.class, (String)"ERR_NoRetention", (Object)this.getCdiMetaAnnotation()));
    }

    protected abstract String getCdiMetaAnnotation();

    protected CdiAnalysisResult getResult() {
        return this.myResult;
    }
}

