/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.docker.editor.util.DocDownloader;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public enum Command {
    ADD("ADD", true),
    ARG("ARG", true),
    CMD("CMD", true),
    COPY("COPY", true),
    ENTRYPOINT("ENTRYPOINT", true),
    ENV("ENV", true),
    EXPOSE("EXPOSE", true),
    FROM("FROM", false),
    LABEL("LABEL", true),
    MAINTAINER("MAINTAINER", false),
    ONBUILD("ONBUILD", false),
    RUN("RUN", true),
    STOPSIGNAL("STOPSIGNAL", true),
    USER("USER", true),
    VOLUME("VOLUME", true),
    WORKDIR("WORKDIR", true);

    private static final Logger LOG;
    private static final String DOC_URL = "https://docs.docker.com/engine/reference/builder/";
    private static final Map<String, Command> commands;
    private static Map<Command, Documentation> docCache;
    private static Future<String> download;
    private final String name;
    private final boolean onBuildSupported;

    private Command(String name, boolean onBuildSupported) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.name = name;
        this.onBuildSupported = onBuildSupported;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isOnBuildSupported() {
        return this.onBuildSupported;
    }

    @NonNull
    public ElementHandle toElementHandle() {
        return new Handle(this.name);
    }

    @CheckForNull
    public Documentation getDocumentation(@NullAllowed Callable<Boolean> cancel) {
        Map<Command, Documentation> cache = Command.getCache(cancel == null ? () -> false : cancel);
        return cache.get((Object)this);
    }

    @CheckForNull
    public static Command forName(@NonNull String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        return commands.get(name.toUpperCase());
    }

    @CheckForNull
    public static Command forHandle(@NonNull ElementHandle handle) {
        Parameters.notNull((CharSequence)"handle", (Object)handle);
        if (ElementKind.KEYWORD != handle.getKind()) {
            throw new IllegalArgumentException("Invalid kind: " + handle.getKind());
        }
        if (!"text/x-dockerfile".equals(handle.getMimeType())) {
            throw new IllegalArgumentException("Invalid mimetype: " + handle.getMimeType());
        }
        return commands.get(handle.getName());
    }

    @NonNull
    public static Collection<String> getCommandNames(@NullAllowed String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        prefix = prefix.toUpperCase();
        ArrayList<String> res = new ArrayList<String>(commands.size());
        for (String cmd : commands.keySet()) {
            if (!cmd.startsWith(prefix)) continue;
            res.add(cmd);
        }
        return Collections.unmodifiableList(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static Map<Command, Documentation> getCache(@NonNull Callable<Boolean> cancel) {
        Class<Command> clazz = Command.class;
        synchronized (Command.class) {
            Map<Command, Object> res = docCache;
            Future<String> becomesHtml = download;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (res != null) {
                return res;
            }
            try {
                if (becomesHtml == null) {
                    becomesHtml = DocDownloader.download(new URL(DOC_URL), () -> false);
                }
                String html = null;
                while (cancel.call() != Boolean.TRUE) {
                    try {
                        html = becomesHtml.get(250L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                    }
                }
                if (html != null) {
                    res = DocDownloader.parseCommands(html, DOC_URL);
                }
            }
            catch (ExecutionException ee) {
                LOG.log(Level.WARNING, "Cannot load Docker documentation: {0}", ee.getCause().getMessage());
                res = Collections.emptyMap();
            }
            catch (IOException | InterruptedException ioe) {
                LOG.log(Level.WARNING, "Cannot load Docker documentation: {0}", ioe.getMessage());
                res = Collections.emptyMap();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                res = Collections.emptyMap();
            }
            clazz = Command.class;
            synchronized (Command.class) {
                if (docCache != null) {
                    res = docCache;
                } else if (res != null) {
                    docCache = res;
                    download = null;
                } else {
                    if (download == null) {
                        download = becomesHtml;
                    }
                    res = Collections.emptyMap();
                }
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return res;
            }
        }
    }

    static {
        LOG = Logger.getLogger(Command.class.getName());
        HashMap<String, Command> cmds = new HashMap<String, Command>();
        for (Command cmd : Command.values()) {
            cmds.put(cmd.getName(), cmd);
        }
        commands = Collections.unmodifiableMap(cmds);
    }

    private static final class Handle
    implements ElementHandle {
        private final String commandName;

        Handle(@NonNull String commandName) {
            Parameters.notNull((CharSequence)"commandName", (Object)commandName);
            this.commandName = commandName;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "text/x-dockerfile";
        }

        public String getName() {
            return this.commandName;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(@NonNull ElementHandle handle) {
            return this.getKind() == handle.getKind() && this.getName().equals(handle.getName());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }
}

