/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.model.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.JsObjectReference;
import org.netbeans.modules.javascript2.model.ParameterObject;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.openide.filesystems.FileObject;

public class JsFunctionImpl
extends DeclarationScopeImpl
implements JsFunction {
    private final HashMap<String, JsObject> parametersByName;
    private final List<JsObject> parameters;
    private final Set<TypeUsage> returnTypes;
    private boolean isStrict;
    private boolean areReturnTypesResolved = false;

    public JsFunctionImpl(DeclarationScope scope, JsObject parentObject, Identifier name, List<Identifier> parameters, OffsetRange offsetRange, String mimeType, String sourceLabel) {
        super(scope, parentObject, name, offsetRange, mimeType, sourceLabel);
        this.parametersByName = new HashMap(parameters.size());
        this.parameters = new ArrayList<JsObject>(parameters.size());
        for (Identifier identifier : parameters) {
            ParameterObject parameter = new ParameterObject(this, identifier, mimeType, sourceLabel);
            this.addParameter(parameter);
        }
        this.setAnonymous(false);
        this.returnTypes = new HashSet<TypeUsage>();
        this.setDeclared(true);
        if (parentObject != null) {
            JsObjectImpl arguments = new JsObjectImpl((JsObject)this, new Identifier("arguments", new OffsetRange(name.getOffsetRange().getStart(), name.getOffsetRange().getStart())), name.getOffsetRange(), false, EnumSet.of(Modifier.PRIVATE), mimeType, sourceLabel);
            arguments.addAssignment(new TypeUsage("Arguments", this.getOffset(), true), this.getOffset());
            this.addProperty(arguments.getName(), arguments);
        }
    }

    protected JsFunctionImpl(FileObject file, JsObject parentObject, Identifier name, List<Identifier> parameters, String mimeType, String sourceLabel) {
        this(null, parentObject, name, parameters, name.getOffsetRange(), mimeType, sourceLabel);
        this.setFileObject(file);
        this.setDeclared(false);
    }

    private JsFunctionImpl(FileObject file, Identifier name, String mimeType, String sourceLabel) {
        this(null, null, name, Collections.emptyList(), name.getOffsetRange(), mimeType, sourceLabel);
        this.setFileObject(file);
    }

    public static JsFunctionImpl createGlobal(FileObject fileObject, int length, String mimeType) {
        String name = fileObject != null ? fileObject.getName() : "VirtualSource";
        Identifier ident = new Identifier(name, new OffsetRange(0, length));
        return new JsFunctionImpl(fileObject, ident, mimeType, null);
    }

    @Override
    public final Collection<? extends JsObject> getParameters() {
        return this.parameters;
    }

    public final void addParameter(JsObject object) {
        assert (object.getParent() == this);
        this.parametersByName.put(object.getName(), object);
        this.parameters.add(object);
    }

    @Override
    public JsElement.Kind getJSKind() {
        if (this.kind != null) {
            return this.kind;
        }
        if (this.getParent() == null) {
            return JsElement.Kind.FILE;
        }
        String name = this.getName();
        if (name != null && name.startsWith("get ")) {
            return JsElement.Kind.PROPERTY_GETTER;
        }
        if (name != null && name.startsWith("set ")) {
            return JsElement.Kind.PROPERTY_SETTER;
        }
        if (this.getParent() != null) {
            JsObject prototype = null;
            for (JsObject jsObject : this.getProperties().values()) {
                if (jsObject.isDeclared() && (jsObject.getModifiers().contains(Modifier.PROTECTED) || jsObject.getModifiers().contains(Modifier.PUBLIC) && !jsObject.getModifiers().contains(Modifier.STATIC)) && !this.isAnonymous() && !jsObject.isAnonymous() && jsObject.getDeclarationName() != null && jsObject.getDeclarationName().getOffsetRange().getStart() < jsObject.getDeclarationName().getOffsetRange().getEnd() && !"prototype".equals(this.getParent().getName())) {
                    return JsElement.Kind.CONSTRUCTOR;
                }
                if (!"prototype".equals(jsObject.getName())) continue;
                prototype = jsObject;
            }
            if (prototype != null) {
                return JsElement.Kind.CONSTRUCTOR;
            }
        }
        JsElement.Kind result = JsElement.Kind.FUNCTION;
        if (!(this.getParent() instanceof JsObjectReference) && this.getParent().getJSKind() != JsElement.Kind.FILE) {
            result = JsElement.Kind.METHOD;
        }
        return result;
    }

    @Override
    public JsObject getParameter(String name) {
        JsObject result = this.parametersByName.get(name);
        return result;
    }

    @Override
    public Collection<? extends TypeUsage> getReturnTypes() {
        if (this.areReturnTypesResolved) {
            return Collections.emptyList();
        }
        HashSet<TypeUsage> returns = new HashSet<TypeUsage>();
        HashSet<String> nameReturnTypes = new HashSet<String>();
        this.areReturnTypesResolved = true;
        for (TypeUsage type : this.returnTypes) {
            if (type.isResolved()) {
                if (nameReturnTypes.contains(type.getType())) continue;
                returns.add(type);
                nameReturnTypes.add(type.getType());
                continue;
            }
            if (type.getType().startsWith("@")) {
                String typeName = type.getType();
                if (typeName.endsWith(this.getName()) && typeName.startsWith("@call")) continue;
                Collection<TypeUsage> resolved = ModelUtils.resolveTypeFromSemiType(this, type);
                for (TypeUsage typeResolved : resolved) {
                    if (nameReturnTypes.contains(type.getType())) continue;
                    returns.add(typeResolved);
                    nameReturnTypes.add(typeResolved.getType());
                }
                continue;
            }
            JsObject jsObject = ModelUtils.getJsObjectByName(this, type.getType());
            if (jsObject == null) {
                JsObject global = ModelUtils.getGlobalObject(this);
                jsObject = ModelUtils.findJsObjectByName(global, type.getType());
            }
            if (jsObject != null) {
                Collection<TypeUsage> resolveAssignments = this.resolveAssignments(jsObject, type.getOffset());
                for (TypeUsage typeResolved : resolveAssignments) {
                    if (nameReturnTypes.contains(typeResolved.getType())) continue;
                    returns.add(typeResolved);
                    nameReturnTypes.add(typeResolved.getType());
                }
                continue;
            }
            returns.add(type);
            nameReturnTypes.add(type.getType());
        }
        this.areReturnTypesResolved = false;
        return returns;
    }

    @Override
    public void addReturnType(TypeUsage type) {
        boolean isThere = false;
        for (TypeUsage typeUsage : this.returnTypes) {
            if (!type.getType().equals(typeUsage.getType())) continue;
            isThere = true;
        }
        if (!isThere) {
            this.returnTypes.add(type);
        }
    }

    public void addReturnType(Collection<TypeUsage> types) {
        for (TypeUsage typeUsage : types) {
            this.addReturnType(typeUsage);
        }
    }

    public boolean areReturnTypesEmpty() {
        return this.returnTypes.isEmpty();
    }

    @Override
    public boolean moveProperty(String name, JsObject newParent) {
        JsObject property = this.getProperty(name);
        if (property != null && newParent instanceof DeclarationScope) {
            ModelUtils.changeDeclarationScope(property, (DeclarationScope)newParent);
        }
        return super.moveProperty(name, newParent);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void resolveTypes(JsDocumentationHolder docHolder) {
        TypeUsage type;
        super.resolveTypes(docHolder);
        if (this.returnTypes.size() != 1 || !"undefined".equals(this.returnTypes.iterator().next().getType())) {
            HashSet<String> nameReturnTypes = new HashSet<String>();
            ArrayList<TypeUsage> resolved = new ArrayList<TypeUsage>();
            for (TypeUsage type2 : this.returnTypes) {
                if (type2.getType().equals("unresolved") && this.returnTypes.size() > 1) continue;
                if (!type2.isResolved()) {
                    for (TypeUsage rType : ModelUtils.resolveTypeFromSemiType(this, type2)) {
                        if (nameReturnTypes.contains(rType.getType())) continue;
                        if ("@this;".equals(type2.getType())) {
                            rType = new TypeUsage(rType.getType(), -1, rType.isResolved());
                        }
                        resolved.add(rType);
                        nameReturnTypes.add(rType.getType());
                    }
                    continue;
                }
                if (nameReturnTypes.contains(type2.getType())) continue;
                resolved.add(type2);
                nameReturnTypes.add(type2.getType());
            }
            for (TypeUsage type2 : resolved) {
                if (type2.getOffset() <= 0) continue;
                String typeName = type2.getType();
                JsObject jsObject = null;
                if (typeName.indexOf(46) == -1) {
                    JsObject parameter = null;
                    for (JsFunctionImpl scope = this; scope != null && parameter == null && jsObject == null; scope = scope.getParentScope()) {
                        if (scope instanceof JsFunction) {
                            parameter = ((JsFunction)scope).getParameter(typeName);
                        }
                        jsObject = ((JsObject)scope).getProperty(typeName);
                    }
                    if (jsObject == null && parameter != null) {
                        jsObject = parameter;
                    }
                    if (jsObject != null) {
                        jsObject.addOccurrence(new OffsetRange(type2.getOffset(), type2.getOffset() + typeName.length()));
                    }
                }
                if (jsObject != null) continue;
                jsObject = ModelUtils.findJsObjectByName(this, typeName);
                if (jsObject == null) {
                    JsObject global = ModelUtils.getGlobalObject(this);
                    jsObject = ModelUtils.findJsObjectByName(global, typeName);
                }
                if (jsObject == null || !this.containsOffset(type2.getOffset()) || this.getJSKind().equals((Object)JsElement.Kind.FILE)) continue;
                int index = typeName.lastIndexOf(46);
                int typeLength = index > -1 ? typeName.length() - index - 1 : typeName.length();
                ((JsObjectImpl)jsObject).addOccurrence(new OffsetRange(type2.getOffset(), jsObject.isAnonymous() ? type2.getOffset() : type2.getOffset() + typeLength));
            }
            this.returnTypes.clear();
            this.returnTypes.addAll(resolved);
        } else if (this.getJSKind() == JsElement.Kind.CONSTRUCTOR) {
            Collection<TypeUsage> resolved = ModelUtils.resolveTypeFromSemiType(this, this.returnTypes.iterator().next());
            this.returnTypes.clear();
            this.returnTypes.addAll(resolved);
        } else if (this.returnTypes.size() == 1 && "undefined".equals((type = this.returnTypes.iterator().next()).getType()) && !type.isResolved()) {
            this.returnTypes.clear();
            this.returnTypes.add(new TypeUsage(type.getType(), type.getOffset(), true));
        }
        JsObject global = ModelUtils.getGlobalObject(this);
        for (JsObject param : this.parameters) {
            Collection<? extends TypeUsage> types = param.getAssignmentForOffset(param.getDeclarationName().getOffsetRange().getStart());
            for (TypeUsage type3 : types) {
                JsObject jsObject = ModelUtils.findJsObjectByName(global, type3.getType());
                if (jsObject == null) continue;
                ModelUtils.addDocTypesOccurence(jsObject, docHolder);
                JsFunctionImpl.moveOccurrenceOfProperties((JsObjectImpl)jsObject, param);
                if (type3.getType().indexOf(46) <= -1) continue;
                String[] typeParts = type3.getType().split("\\.");
                JsObject parent = jsObject.getParent();
                for (int i = typeParts.length - 2; i > -1 && parent != null; parent = parent.getParent(), --i) {
                    if (!parent.getName().equals(typeParts[i])) continue;
                    ModelUtils.addDocTypesOccurence(parent, docHolder);
                }
            }
            ArrayList<? extends JsObject> paramProperties = new ArrayList<JsObject>(param.getProperties().values());
            for (JsObject paramProperty : paramProperties) {
                ((JsObjectImpl)paramProperty).resolveTypes(docHolder);
            }
        }
    }

    @Override
    protected void correctTypes(String fromType, String toType) {
        super.correctTypes(fromType, toType);
        HashSet<TypeUsage> copy = new HashSet<TypeUsage>(this.returnTypes);
        for (TypeUsage type : copy) {
            String typeFQN = type.getType();
            String typeR = this.replaceTypeInFQN(typeFQN, fromType, toType);
            if (typeR == null) continue;
            this.returnTypes.remove(type);
            this.returnTypes.add(new TypeUsage(typeR, type.getOffset(), type.isResolved()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDeclarationName().getName()).append("()");
        return sb.toString();
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }
}

