/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.spi.nodes.AbstractGradleNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class DistributionNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project project) {
        return new NList(project);
    }

    private static class NList
    extends AbstractGradleNodeList<SourceGroup> {
        private final Project project;

        private NList(Project prj) {
            this.project = prj;
        }

        public List<SourceGroup> keys() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            ArrayList<SourceGroup> ret = new ArrayList<SourceGroup>(2);
            ret.addAll(Arrays.asList(srcs.getSourceGroups("distribution")));
            ret.sort(Comparator.comparing(SourceGroup::getName));
            return ret;
        }

        public Node node(SourceGroup key) {
            return DistributionFolderNode.createResourcesFolderNode(key);
        }
    }

    private static class DistributionFolderNode
    extends FilterNode {
        final SourceGroup group;

        private DistributionFolderNode(SourceGroup group, Node original) {
            super(original);
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        static Node createResourcesFolderNode(SourceGroup group) {
            try {
                DataObject root = DataObject.find((FileObject)group.getRootFolder());
                return new DistributionFolderNode(group, root.getNodeDelegate());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }
}

