/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProject;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.ModulesActivator;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FeatureProjectFactory
implements ProjectFactory,
PropertyChangeListener,
Runnable {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.ide.ergonomics.projects");

    public FeatureProjectFactory() {
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
    }

    static Icon loadIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/ide/ergonomics/fod/project.png", (boolean)false);
    }

    public boolean isProject(FileObject projectDirectory) {
        Data d = new Data(projectDirectory, false);
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent() || featureInfo.isEnabled() || featureInfo.isProject(d) != 1) continue;
            return true;
        }
        return false;
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        Data d = new Data(projectDirectory, true);
        FeatureInfo lead = null;
        ArrayList<FeatureInfo> additional = new ArrayList<FeatureInfo>();
        int notEnabled = 0;
        block5: for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent()) continue;
            switch (featureInfo.isProject(d)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    lead = featureInfo;
                    if (featureInfo.isEnabled()) continue block5;
                    ++notEnabled;
                    continue block5;
                }
                case 2: {
                    additional.add(featureInfo);
                    if (featureInfo.isEnabled()) continue block5;
                    ++notEnabled;
                    continue block5;
                }
            }
            assert (false);
        }
        if (lead == null || notEnabled == 0) {
            return null;
        }
        return new FeatureNonProject(projectDirectory, lead, state, additional);
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
    }

    @Override
    public void run() {
        Project[] toCheck = OpenProjects.getDefault().getOpenProjects();
        this.checkProjects(toCheck);
    }

    private void checkProjects(Project[] toCheck) {
        ArrayList<FeatureInfo> additional = new ArrayList<FeatureInfo>();
        FeatureInfo f = null;
        for (Project p : toCheck) {
            Data d = new Data(p.getProjectDirectory(), true);
            block6: for (FeatureInfo featureInfo : FeatureManager.features()) {
                switch (featureInfo.isProject(d)) {
                    case 0: {
                        continue block6;
                    }
                    case 1: {
                        f = featureInfo;
                        continue block6;
                    }
                    case 2: {
                        f = featureInfo;
                        additional.add(featureInfo);
                        continue block6;
                    }
                }
                assert (false);
            }
        }
        if (f != null && !additional.isEmpty()) {
            FeatureInfo finalF = f;
            FeatureInfo[] addF = additional.toArray(new FeatureInfo[0]);
            FeatureManager.logUI("ERGO_PROJECT_OPEN", finalF.clusterName);
            FindComponentModules findModules = new FindComponentModules(finalF, addF);
            Collection<UpdateElement> toEnable = findModules.getModulesForEnable();
            if (toEnable != null && !toEnable.isEmpty()) {
                ModulesActivator enabler = new ModulesActivator(toEnable, findModules);
                enabler.getEnableTask().waitFinished();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object arr;
        if ("willOpenProjects".equals(evt.getPropertyName()) && (arr = evt.getNewValue()) instanceof Project[]) {
            RequestProcessor.Task t = FeatureManager.getInstance().create(new Runnable(){

                @Override
                public void run() {
                    FeatureProjectFactory.this.checkProjects((Project[])arr);
                }
            });
            t.schedule(0);
            t.waitFinished();
        }
        if ("openProjects".equals(evt.getPropertyName())) {
            RequestProcessor.Task t = FeatureManager.getInstance().create(this);
            t.schedule(0);
        }
    }

    static final class Data {
        private final boolean deepCheck;
        private final FileObject dir;
        private Map<String, String> data;
        private Map<String, Document> doms;

        public Data(FileObject dir, boolean deepCheck) {
            this.deepCheck = deepCheck;
            this.dir = dir;
        }

        Document dom(String relative) {
            Document doc;
            Document document = doc = this.doms == null ? null : this.doms.get(relative);
            if (doc != null) {
                return doc;
            }
            FileObject fo = this.dir.getFileObject(relative);
            if (fo == null) {
                return null;
            }
            File f = FileUtil.toFile((FileObject)fo);
            try {
                DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (f != null) {
                    doc = b.parse(f);
                } else {
                    InputStream is = fo.getInputStream();
                    doc = b.parse(is);
                }
                if (this.doms == null) {
                    this.doms = new HashMap<String, Document>();
                }
                this.doms.put(relative, doc);
                return doc;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                LOG.log(Level.WARNING, "Cannot configure XML parser", parserConfigurationException);
            }
            catch (SAXException sAXException) {
                LOG.log(Level.INFO, "XML broken in " + f, sAXException);
            }
            catch (Exception any) {
                LOG.log(Level.INFO, "Cannot read " + f, any);
            }
            return null;
        }

        final boolean hasFile(String relative) {
            FileObject d = this.dir;
            int pos = 0;
            while (relative.startsWith("../", pos) && d != null) {
                d = d.getParent();
                pos += 3;
            }
            if (d == null) {
                return false;
            }
            if ((relative = relative.substring(pos)).contains("*")) {
                for (String segment : relative.split("/")) {
                    block7: {
                        if (segment.contains("*")) {
                            assert (segment.endsWith("*"));
                            String prefix = segment.substring(0, segment.length() - 1);
                            for (FileObject ch : d.getChildren()) {
                                if (!ch.getNameExt().startsWith(prefix)) continue;
                                d = ch;
                                break block7;
                            }
                            return false;
                        }
                        d = d.getFileObject(segment);
                    }
                    if (d != null) continue;
                    return false;
                }
                return true;
            }
            return d.getFileObject(relative) != null;
        }

        final boolean isDeepCheck() {
            return this.deepCheck;
        }

        public String toString() {
            return this.dir.getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final synchronized String is(String relative) {
            int len;
            String content;
            FileObject prj = this.dir.getFileObject(relative);
            if (prj == null) {
                return null;
            }
            String string = content = this.data == null ? null : this.data.get(relative);
            if (content != null) {
                return content;
            }
            byte[] arr = new byte[4000];
            InputStream is = null;
            try {
                is = prj.getInputStream();
                len = is.read(arr);
                if (len >= 0) {
                    content = new String(arr, 0, len, StandardCharsets.UTF_8);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINEST, "exception while reading " + prj, ex);
                len = -1;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            LOG.log(Level.FINEST, "    read {0} bytes", len);
            if (len == -1) {
                return null;
            }
            if (this.data == null) {
                this.data = new HashMap<String, String>();
            }
            this.data.put(relative, content);
            return content;
        }
    }

    private static final class FeatureNonProject
    implements Project,
    ChangeListener {
        private final FeatureDelegate delegate;
        private final FeatureInfo info;
        private final FeatureInfo[] additional;
        private final Lookup lookup;
        private ProjectState state;
        private volatile String error;
        private final ChangeListener weakL;

        public FeatureNonProject(FileObject dir, FeatureInfo info, ProjectState state, List<FeatureInfo> additional) {
            this.delegate = new FeatureDelegate(dir, this);
            this.info = info;
            this.additional = additional.toArray(new FeatureInfo[0]);
            this.lookup = Lookups.proxy((Lookup.Provider)this.delegate);
            this.state = state;
            this.weakL = WeakListeners.change((ChangeListener)this, (Object)FeatureManager.getInstance());
            FeatureManager.getInstance().addChangeListener(this.weakL);
        }

        public FileObject getProjectDirectory() {
            return this.delegate.dir;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Project) {
                return ((Project)obj).getProjectDirectory().equals(this.getProjectDirectory());
            }
            return false;
        }

        public int hashCode() {
            return this.getProjectDirectory().hashCode();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.info.isEnabled()) {
                this.switchToReal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void switchToReal() {
            ProjectState s = null;
            FeatureNonProject featureNonProject = this;
            synchronized (featureNonProject) {
                s = this.state;
                this.state = null;
            }
            if (s != null) {
                try {
                    s.notifyDeleted();
                    Project p = ProjectManager.getDefault().findProject(this.getProjectDirectory());
                    if (p == this) {
                        throw new IllegalStateException("New project shall be found! " + p);
                    }
                    this.delegate.associate(p);
                }
                catch (IOException ex) {
                    this.error = ex.getLocalizedMessage();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private final class FeatureOpenHook
        extends ProjectOpenedHook
        implements Runnable,
        ProgressMonitor {
            private FindComponentModules finder;

            private FeatureOpenHook() {
            }

            protected void projectOpened() {
                if (FeatureNonProject.this.state == null) {
                    return;
                }
                RequestProcessor.Task t = FeatureManager.getInstance().create(this);
                t.schedule(0);
                t.waitFinished();
                if (FeatureNonProject.this.error == null) {
                    FeatureNonProject.this.switchToReal();
                    SubprojectProvider sp = (SubprojectProvider)FeatureNonProject.this.getLookup().lookup(SubprojectProvider.class);
                    if (sp != null) {
                        for (Project subP : sp.getSubprojects()) {
                            FeatureNonProject toOpen = (FeatureNonProject)subP.getLookup().lookup(FeatureNonProject.class);
                            if (toOpen == null) continue;
                            toOpen.delegate.hook.projectOpened();
                        }
                    }
                } else {
                    FeatureNonProject.this.delegate.associate(new BrokenProject(FeatureNonProject.this.getProjectDirectory(), FeatureNonProject.this.error));
                }
            }

            protected void projectClosed() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FeatureManager.logUI("ERGO_PROJECT_OPEN", ((FeatureNonProject)FeatureNonProject.this).info.clusterName);
                FeatureNonProject.this.error = null;
                FindComponentModules findModules = new FindComponentModules(FeatureNonProject.this.info, FeatureNonProject.this.additional);
                FeatureOpenHook featureOpenHook = this;
                synchronized (featureOpenHook) {
                    this.finder = findModules;
                }
                try {
                    Collection<UpdateElement> toInstall = findModules.getModulesForInstall();
                    Collection<UpdateElement> toEnable = findModules.getModulesForEnable();
                    if (!findModules.getIncompleteFeatures().isEmpty() && findModules.isDownloadRequired()) {
                        LinkedHashSet<FeatureInfo.ExtraModuleInfo> missingModules = new LinkedHashSet<FeatureInfo.ExtraModuleInfo>(findModules.getMissingModules(FeatureNonProject.this.info));
                        for (FeatureInfo i2 : FeatureNonProject.this.additional) {
                            missingModules.addAll(findModules.getMissingModules(i2));
                        }
                        StringBuilder sb = new StringBuilder();
                        if (!missingModules.isEmpty()) {
                            for (FeatureInfo.ExtraModuleInfo s : missingModules) {
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append(s.displayName());
                            }
                        }
                        FeatureNonProject.this.error = NbBundle.getMessage(FeatureProjectFactory.class, (String)"MSG_BrokenAction_FeatureIncomplete", (Object)findModules.getIncompleteFeatures().iterator().next(), (Object)sb.toString());
                        return;
                    }
                    if (toInstall != null && !toInstall.isEmpty()) {
                        ModulesInstaller installer = new ModulesInstaller(toInstall, findModules, this);
                        installer.getInstallTask().waitFinished();
                    }
                    if (toEnable != null && !toEnable.isEmpty() && FeatureNonProject.this.error == null) {
                        ModulesActivator enabler = new ModulesActivator(toEnable, findModules, this);
                        enabler.getEnableTask().waitFinished();
                    }
                }
                finally {
                    FeatureOpenHook featureOpenHook2 = this;
                    synchronized (featureOpenHook2) {
                        this.finder = null;
                    }
                }
            }

            @Override
            public void onDownload(ProgressHandle progressHandle) {
            }

            @Override
            public void onValidate(ProgressHandle progressHandle) {
            }

            @Override
            public void onInstall(ProgressHandle progressHandle) {
            }

            @Override
            public void onEnable(ProgressHandle progressHandle) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String message) {
                FeatureOpenHook featureOpenHook = this;
                synchronized (featureOpenHook) {
                    if (this.finder.isDownloadRequired()) {
                        FeatureNonProject.this.error = message;
                    }
                }
            }
        }
    }

    private static final class RootNode
    extends FilterNode {
        public RootNode(FileObject fo) {
            super(DataFolder.findFolder((FileObject)fo).getNodeDelegate());
        }

        public void change(Lookup l) {
            LogicalViewProvider lvp = (LogicalViewProvider)l.lookup(LogicalViewProvider.class);
            if (lvp != null) {
                this.changeOriginal(lvp.createLogicalView(), true);
            }
        }
    }

    private static final class FeatureDelegate
    implements Lookup.Provider,
    ProjectInformation,
    LogicalViewProvider {
        private final FileObject dir;
        private final PropertyChangeSupport support;
        Lookup delegate;
        private final InstanceContent ic = new InstanceContent();
        private final Lookup hooks = new AbstractLookup((AbstractLookup.Content)this.ic);
        private final FeatureNonProject.FeatureOpenHook hook;
        private List<RootNode> lvs;

        public FeatureDelegate(FileObject dir, FeatureNonProject feature) {
            this.dir = dir;
            FeatureNonProject featureNonProject = feature;
            Objects.requireNonNull(featureNonProject);
            this.hook = featureNonProject.new FeatureNonProject.FeatureOpenHook();
            this.ic.add((Object)UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)this.hook));
            this.delegate = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{feature, this}), LookupProviderSupport.createCompositeLookup((Lookup)this.hooks, (String)"../nonsence")});
            this.support = new PropertyChangeSupport(this);
        }

        public Lookup getLookup() {
            return this.delegate;
        }

        public String getName() {
            ProjectInformation info = (ProjectInformation)this.delegate.lookup(ProjectInformation.class);
            if (info != null && info != this) {
                return info.getName();
            }
            return this.dir.getNameExt();
        }

        public String getDisplayName() {
            ProjectInformation info = (ProjectInformation)this.delegate.lookup(ProjectInformation.class);
            if (info != null && info != this) {
                return info.getDisplayName();
            }
            return this.getName();
        }

        public Icon getIcon() {
            ProjectInformation info = (ProjectInformation)this.delegate.lookup(ProjectInformation.class);
            if (info != null && info != this) {
                return info.getIcon();
            }
            return FeatureProjectFactory.loadIcon();
        }

        public Project getProject() {
            return (Project)this.delegate.lookup(Project.class);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        final void associate(Project p) {
            if (p == null) {
                this.delegate = Lookup.EMPTY;
                return;
            }
            assert (this.dir.equals(p.getProjectDirectory()));
            ProjectInformation info = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            if (info != null) {
                for (PropertyChangeListener l : this.support.getPropertyChangeListeners()) {
                    info.addPropertyChangeListener(l);
                }
            }
            this.delegate = p.getLookup();
            for (ProjectOpenedHook h : p.getLookup().lookupAll(ProjectOpenedHook.class)) {
                this.ic.add((Object)h);
            }
            List<RootNode> list = this.lvs;
            this.lvs = Collections.emptyList();
            if (list != null) {
                for (RootNode fn : list) {
                    fn.change(this.delegate);
                }
            }
            this.support.firePropertyChange(null, null, null);
        }

        public Node createLogicalView() {
            LogicalViewProvider lvp = (LogicalViewProvider)this.delegate.lookup(LogicalViewProvider.class);
            if (lvp != null && lvp != this) {
                return lvp.createLogicalView();
            }
            if (this.lvs == null) {
                this.lvs = new ArrayList<RootNode>();
            }
            RootNode fn = new RootNode(this.dir);
            this.lvs.add(fn);
            return fn;
        }

        public Node findPath(Node root, Object target) {
            LogicalViewProvider lvp = (LogicalViewProvider)this.delegate.lookup(LogicalViewProvider.class);
            if (lvp != null && lvp != this) {
                return lvp.findPath(root, target);
            }
            return null;
        }
    }
}

