/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanycheckbox;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectmanycheckbox.SelectManyCheckbox;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.WidgetBuilder;

public class SelectManyCheckboxRenderer
extends SelectManyRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectMany", "javax.faces.Checkbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyCheckbox checkbox = (SelectManyCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanycheckbox ui-widget" : "ui-selectmanycheckbox ui-widget " + styleClass;
        writer.startElement("table", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, checkbox);
        writer.endElement("table");
    }

    protected void encodeScript(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        String clientId = checkbox.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyCheckbox", checkbox.resolveWidgetVar(), clientId).finish();
    }

    protected void encodeOptionInput(FacesContext context, SelectManyCheckbox checkbox, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)value, null);
        this.renderOnchange(context, (UIComponent)checkbox);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)checkbox);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionLabel(FacesContext context, SelectManyCheckbox checkbox, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected void encodeOptionOutput(FacesContext context, SelectManyCheckbox checkbox, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        boxClass = checked ? boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = !checkbox.isValid() ? boxClass + " ui-state-error" : boxClass;
        String iconClass = "ui-chkbox-icon ui-c";
        iconClass = checked ? iconClass + " " + "ui-chkbox-icon ui-icon ui-icon-check ui-c" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        String layout = checkbox.getLayout();
        if (layout == null) {
            layout = "lineDirection";
        }
        if (layout.equals("lineDirection")) {
            this.encodeLineLayout(context, checkbox);
        } else if (layout.equals("pageDirection")) {
            this.encodePageLayout(context, checkbox);
        } else if (layout.equals("grid")) {
            this.encodeGridLayout(context, checkbox);
        } else {
            throw new FacesException("Invalid '" + layout + "' type for component '" + checkbox.getClientId(context) + "'.");
        }
    }

    protected void encodeLineLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        writer.startElement("tr", null);
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
            ++idx;
        }
        writer.endElement("tr");
    }

    protected void encodePageLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            writer.startElement("tr", null);
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
            writer.endElement("tr");
            ++idx;
        }
    }

    protected void encodeGridLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int columns = checkbox.getColumns();
        if (columns != 0) {
            int idx = 0;
            for (SelectItem selectItem : selectItems) {
                int colMod = idx % columns;
                if (colMod == 0) {
                    writer.startElement("tr", null);
                }
                this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
                if ((colMod = ++idx % columns) != 0) continue;
                writer.endElement("tr");
            }
        } else {
            throw new FacesException("The value of columns attribute must be greater than zero.");
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyCheckbox checkbox = (SelectManyCheckbox)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = checkbox.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || checkbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        this.encodeOptionInput(context, checkbox, id, name, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, checkbox, selected, disabled);
        writer.endElement("div");
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeOptionLabel(context, checkbox, id, option, disabled);
        writer.endElement("td");
    }

    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    public String getHighlighter() {
        return "manychkbox";
    }

    protected boolean isGrouped() {
        return true;
    }
}

