/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.UpdateAllProjects;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

class RequiredProjectsPanel
extends JPanel {
    private Map<String, String> values;
    private List<String> rows;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public RequiredProjectsPanel(Map<String, String> values) {
        this.values = values;
        this.rows = new ArrayList<String>(values.keySet());
        this.initComponents();
        this.jTable1.setModel(new ProjectTableModel());
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(RequiredProjectsPanel.class, (String)"LABEL_Eclipse_Project"));
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(RequiredProjectsPanel.class, (String)"LABEL_NetBeans_Project_Destination"));
    }

    public static boolean showConfirmation(Collection<UpdateAllProjects.ProjectsAndDestination> projsAndDests) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (UpdateAllProjects.ProjectsAndDestination pad : projsAndDests) {
            for (EclipseProject ep : pad.getEclipseProjects()) {
                values.put(ep.getName(), pad.getDestination().getPath());
            }
        }
        RequiredProjectsPanel p = new RequiredProjectsPanel(values);
        DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(RequiredProjectsPanel.class, (String)"TITLE_Synchronize_with_Eclipse"), true, 2, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1.setText(NbBundle.getMessage(RequiredProjectsPanel.class, (String)"RequiredProjectsPanel.jLabel1.text"));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 555, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 555, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 177, Short.MAX_VALUE).addContainerGap()));
    }

    private class ProjectTableModel
    extends AbstractTableModel {
        private ProjectTableModel() {
        }

        @Override
        public int getRowCount() {
            return RequiredProjectsPanel.this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            String key = RequiredProjectsPanel.this.rows.get(row);
            if (column == 0) {
                return key;
            }
            return RequiredProjectsPanel.this.values.get(key);
        }
    }
}

