/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClassesSelectorPanel
extends JPanel {
    static final String PROP_CLASSES = "wizard-classes";
    static final String PROP_SELECTED_CLASSES = "wizard-selected-classes";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Set<String> available = new HashSet<String>();
    private final Set<String> selected = new HashSet<String>();
    private final String bundleKey;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList<String> availableList;
    private JScrollPane availableScrollPane;
    private JPanel buttonPanel;
    private JPanel classesPanel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectedLabel;
    private JList<String> selectedList;
    private JScrollPane selectedScrollPane;

    public ClassesSelectorPanel(String key) {
        this.bundleKey = key;
        this.initComponents();
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassesSelectorPanel.this.updateButtons();
            }
        };
        this.availableList.getSelectionModel().addListSelectionListener(selectionListener);
        this.selectedList.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void initialize(Set<String> entities) {
        this.available.addAll(entities.stream().map(fqn -> {
            int idx = fqn.lastIndexOf(46);
            return idx < 0 ? fqn : fqn.substring(idx + 1) + " (" + fqn.substring(0, idx) + ')';
        }).collect(Collectors.toSet()));
        Object[] availableArray = this.available.toArray(new String[0]);
        Arrays.sort(availableArray);
        this.availableList.setListData((String[])availableArray);
        this.selectedList.setListData((String[])this.selected.toArray(new String[0]));
        this.updateButtons();
    }

    public Set<String> getSelectedClasses() {
        return this.selected.stream().map(item -> {
            int idx = item.indexOf(" (");
            return idx < 0 ? item : item.substring(idx + 2, item.length() - 1) + '.' + item.substring(0, idx);
        }).collect(Collectors.toSet());
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.availableList.getSelectedIndices().length > 0);
        this.addAllButton.setEnabled(!this.available.isEmpty());
        this.removeButton.setEnabled(this.selectedList.getSelectedIndices().length > 0);
        this.removeAllButton.setEnabled(!this.selected.isEmpty());
    }

    private void initComponents() {
        this.classesPanel = new ClassesPanel();
        this.availableLabel = new JLabel();
        this.availableScrollPane = new JScrollPane();
        this.availableList = new JList();
        this.selectedLabel = new JLabel();
        this.selectedScrollPane = new JScrollPane();
        this.selectedList = new JList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.setMinimumSize(new Dimension(200, 300));
        this.setName(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("LBL_" + this.bundleKey)));
        this.setPreferredSize(new Dimension(496, 350));
        this.setLayout(new GridBagLayout());
        this.classesPanel.setLayout(new GridBagLayout());
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)("LBL_Available" + this.bundleKey)));
        this.availableLabel.setToolTipText(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("LBL_Available" + this.bundleKey)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.classesPanel.add((Component)this.availableLabel, gridBagConstraints);
        this.availableScrollPane.setPreferredSize(new Dimension(160, 130));
        this.availableList.setNextFocusableComponent(this.addButton);
        this.availableScrollPane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("ACSN_Available" + this.bundleKey)));
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("ACSD_Available" + this.bundleKey)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.availableScrollPane, gridBagConstraints);
        this.selectedLabel.setLabelFor(this.selectedList);
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)("LBL_Selected" + this.bundleKey)));
        this.selectedLabel.setToolTipText(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("LBL_Selected" + this.bundleKey)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.classesPanel.add((Component)this.selectedLabel, gridBagConstraints);
        this.selectedScrollPane.setPreferredSize(new Dimension(160, 130));
        this.selectedScrollPane.setViewportView(this.selectedList);
        this.selectedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("ACSN_Selected" + this.bundleKey)));
        this.selectedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("ACSD_Selected" + this.bundleKey)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.selectedScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassesSelectorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassesSelectorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)"LBL_AddAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassesSelectorPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(ClassesSelectorPanel.class, (String)"LBL_RemoveAll"));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassesSelectorPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.classesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.classesPanel, gridBagConstraints);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.available.addAll(this.selected);
        this.selected.clear();
        this.availableList.setListData((String[])this.available.toArray(new String[0]));
        this.selectedList.setListData((String[])this.selected.toArray(new String[0]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        this.selected.addAll(this.available);
        this.available.clear();
        this.availableList.setListData((String[])this.available.toArray(new String[0]));
        this.selectedList.setListData((String[])this.selected.toArray(new String[0]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.available.addAll(this.selectedList.getSelectedValuesList());
        this.selected.removeAll(this.selectedList.getSelectedValuesList());
        this.availableList.setListData((String[])this.available.toArray(new String[0]));
        this.selectedList.setListData((String[])this.selected.toArray(new String[0]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.selected.addAll(this.availableList.getSelectedValuesList());
        this.available.removeAll(this.availableList.getSelectedValuesList());
        this.availableList.setListData((String[])this.available.toArray(new String[0]));
        this.selectedList.setListData((String[])this.selected.toArray(new String[0]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private final class ClassesPanel
    extends JPanel {
        private ClassesPanel() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Rectangle availableBounds = ClassesSelectorPanel.this.availableScrollPane.getBounds();
            Rectangle selectedBounds = ClassesSelectorPanel.this.selectedScrollPane.getBounds();
            if (Math.abs(availableBounds.width - selectedBounds.width) > 1) {
                GridBagConstraints buttonPanelConstraints = ((GridBagLayout)this.getLayout()).getConstraints(ClassesSelectorPanel.this.buttonPanel);
                int totalWidth = this.getWidth() - ClassesSelectorPanel.this.buttonPanel.getWidth() - buttonPanelConstraints.insets.left - buttonPanelConstraints.insets.right;
                int equalWidth = totalWidth / 2;
                int xOffset = equalWidth - availableBounds.width;
                availableBounds.width = equalWidth;
                ClassesSelectorPanel.this.availableScrollPane.setBounds(availableBounds);
                Rectangle buttonBounds = ClassesSelectorPanel.this.buttonPanel.getBounds();
                buttonBounds.x += xOffset;
                ClassesSelectorPanel.this.buttonPanel.setBounds(buttonBounds);
                Rectangle labelBounds = ClassesSelectorPanel.this.selectedLabel.getBounds();
                labelBounds.x += xOffset;
                ClassesSelectorPanel.this.selectedLabel.setBounds(labelBounds);
                selectedBounds.x += xOffset;
                selectedBounds.width = totalWidth - equalWidth;
                ClassesSelectorPanel.this.selectedScrollPane.setBounds(selectedBounds);
            }
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final String title;
        private final String key;
        private final Function<Set<String>, String> validator;
        private ClassesSelectorPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Map<String, Object> classes;

        public WizardPanel(String title, String key, Function<Set<String>, String> validator) {
            this.title = title;
            this.key = key;
            this.validator = validator;
        }

        public ClassesSelectorPanel getComponent() {
            if (this.component == null) {
                this.component = new ClassesSelectorPanel(this.key);
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ClassesSelectorPanel.class);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void readSettings(WizardDescriptor settings) {
            this.wizardDescriptor = settings;
            if (this.title != null) {
                this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
            }
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.classes = (Map)settings.getProperty(ClassesSelectorPanel.PROP_CLASSES);
                this.getComponent().initialize(this.classes.keySet());
            }
        }

        public boolean isValid() {
            if (this.classes.isEmpty()) {
                this.setErrorMessage(NbBundle.getMessage(ClassesSelectorPanel.class, (String)("ERR_No" + this.key), (Object)ProjectUtils.getInformation((Project)Templates.getProject((WizardDescriptor)this.wizardDescriptor)).getDisplayName()));
                return false;
            }
            String err = this.validator.apply(this.getComponent().getSelectedClasses());
            if (err != null) {
                this.setErrorMessage(err);
                return false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public boolean isFinishPanel() {
            return !this.getComponent().getSelectedClasses().isEmpty();
        }

        public void storeSettings(WizardDescriptor settings) {
            Set<String> selected = this.getComponent().getSelectedClasses();
            Map<String, Object> selEntities = this.classes.entrySet().stream().filter(entry -> selected.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
            this.wizardDescriptor.putProperty(ClassesSelectorPanel.PROP_SELECTED_CLASSES, selEntities);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }
    }
}

