/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;

public class StepIntoJSHandler
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static final String SCRIPT_ACCESS_CLASS_JDK = "jdk.nashorn.internal.runtime.ScriptFunctionData";
    private static final String SCRIPT_ACCESS_CLASS_EXT = "org.openjdk.nashorn.internal.runtime.ScriptFunctionData";
    private static final String[] SCRIPT_ACCESS_METHODS = new String[]{"invoke", "construct"};
    private static final String SCRIPT_NOTIFY_INVOKE_METHOD = "notifyInvoke";
    private static final String SCRIPT_NOTIFY_INVOKE_METHOD_SIG = "(Ljava/lang/invoke/MethodHandle;)V";
    private static final String SCRIPT_NOTIFY_INVOKE_METHOD_ARG = "mh";
    private static final Logger logger = Logger.getLogger(StepIntoJSHandler.class.getCanonicalName());
    private final JPDADebugger debugger;
    private final MethodBreakpoint[] scriptAccessBPs;
    private final MethodBreakpoint notifyInvokeBP;
    private volatile boolean isNotifyInvoke;

    public StepIntoJSHandler(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)new CurrentSFTracker());
        ScriptBPListener sbl = new ScriptBPListener();
        int mbn = SCRIPT_ACCESS_METHODS.length;
        this.scriptAccessBPs = new MethodBreakpoint[mbn * 2];
        for (int jdk = 0; jdk < 2; ++jdk) {
            boolean legacyJdk = jdk == 0;
            for (int i = 0; i < mbn; ++i) {
                String method = SCRIPT_ACCESS_METHODS[i];
                MethodBreakpoint mb = MethodBreakpoint.create((String)(legacyJdk ? SCRIPT_ACCESS_CLASS_JDK : SCRIPT_ACCESS_CLASS_EXT), (String)method);
                mb.setHidden(true);
                mb.setSuspend(this.debugger.getSuspend());
                mb.setSession(this.debugger);
                mb.disable();
                mb.addJPDABreakpointListener((JPDABreakpointListener)sbl);
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
                this.scriptAccessBPs[i + jdk * mbn] = mb;
            }
        }
        ScriptInvokeBPListener sibl = new ScriptInvokeBPListener();
        String debugSupportClass = !this.debugger.getClassesByName("jdk.nashorn.internal.runtime.DebuggerSupport").isEmpty() ? "jdk.nashorn.internal.runtime.DebuggerSupport" : "org.openjdk.nashorn.internal.runtime.DebuggerSupport";
        this.notifyInvokeBP = MethodBreakpoint.create((String)debugSupportClass, (String)SCRIPT_NOTIFY_INVOKE_METHOD);
        this.notifyInvokeBP.setMethodSignature(SCRIPT_NOTIFY_INVOKE_METHOD_SIG);
        this.notifyInvokeBP.setHidden(true);
        this.notifyInvokeBP.setSuspend(this.debugger.getSuspend());
        this.notifyInvokeBP.setSession(this.debugger);
        this.notifyInvokeBP.disable();
        this.notifyInvokeBP.addJPDABreakpointListener((JPDABreakpointListener)sibl);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.notifyInvokeBP);
        this.notifyInvokeBP.addPropertyChangeListener("validity", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Breakpoint.VALIDITY.VALID.equals((Object)StepIntoJSHandler.this.notifyInvokeBP.getValidity())) {
                    logger.log(Level.FINE, "{0} is valid => we can disable breakpoints on jdk.nashorn.internal.runtime.ScriptFunctionData/org.openjdk.nashorn.internal.runtime.ScriptFunctionData", StepIntoJSHandler.this.notifyInvokeBP);
                    for (MethodBreakpoint mb : StepIntoJSHandler.this.scriptAccessBPs) {
                        logger.log(Level.FINE, "{0} disable", mb);
                        mb.disable();
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb);
                    }
                    StepIntoJSHandler.this.isNotifyInvoke = true;
                }
            }
        });
    }

    protected void destroy() {
        logger.fine("\nStepIntoJSHandler.destroy()");
        if (!this.isNotifyInvoke) {
            for (MethodBreakpoint mb : this.scriptAccessBPs) {
                logger.log(Level.FINE, "{0} disable", mb);
                mb.disable();
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb);
            }
        }
        logger.log(Level.FINE, "{0} disable", this.notifyInvokeBP);
        this.notifyInvokeBP.disable();
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.notifyInvokeBP);
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed", "actionToBeRun"};
    }

    public void actionPerformed(Object action) {
        if (ActionsManager.ACTION_STEP_INTO.equals(action)) {
            // empty if block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object action;
        if ("actionToBeRun".equals(evt.getPropertyName()) && ActionsManager.ACTION_STEP_INTO.equals(action = evt.getNewValue())) {
            if (!this.isNotifyInvoke) {
                for (MethodBreakpoint mb : this.scriptAccessBPs) {
                    logger.log(Level.FINE, "{0} enable", mb);
                    mb.enable();
                }
            }
            logger.log(Level.FINE, "{0} enable", this.notifyInvokeBP);
            this.notifyInvokeBP.enable();
        }
    }

    private void scriptToBeInvoked(ObjectVariable mh) {
        JPDAClassType classType;
        ObjectVariable member = (ObjectVariable)mh.getField("member");
        if (!(member instanceof ObjectVariable)) {
            logger.info("Variable " + mh + " does not have member field: " + member);
            return;
        }
        ObjectVariable clazz = (ObjectVariable)member.getField("clazz");
        if (!(clazz instanceof ClassVariable)) {
            logger.info("Variable " + mh + " does not have clazz field: " + clazz);
            return;
        }
        try {
            classType = (JPDAClassType)clazz.getClass().getMethod("getReflectedType", new Class[0]).invoke((Object)clazz, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        String className = classType.getName();
        MethodBreakpoint mb = MethodBreakpoint.create((String)className, (String)"");
        mb.setHidden(true);
        mb.setSuspend(this.debugger.getSuspend());
        mb.setSession(this.debugger);
        mb.addJPDABreakpointListener((JPDABreakpointListener)new InScriptBPListener(mb));
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        logger.log(Level.FINE, "Created {0} for any method in {1}", new Object[]{mb, className});
    }

    private class CurrentSFTracker
    implements PropertyChangeListener {
        private CurrentSFTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == null) {
                return;
            }
            logger.fine("Current frame changed>");
            if (!StepIntoJSHandler.this.isNotifyInvoke) {
                for (MethodBreakpoint mb : StepIntoJSHandler.this.scriptAccessBPs) {
                    logger.log(Level.FINE, " {0} disable", mb);
                    mb.disable();
                }
            }
            logger.log(Level.FINE, " {0} disable", StepIntoJSHandler.this.notifyInvokeBP);
            StepIntoJSHandler.this.notifyInvokeBP.disable();
        }
    }

    private class ScriptBPListener
    implements JPDABreakpointListener {
        private ScriptBPListener() {
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            logger.fine("ScriptBPListener.breakpointReached()");
            try {
                this.setAltCSF(event.getThread());
                Variable mh = event.getSource() == StepIntoJSHandler.this.scriptAccessBPs[0] ? StepIntoJSHandler.this.debugger.evaluate("getGenericInvoker()") : StepIntoJSHandler.this.debugger.evaluate("getGenericConstructor()");
                if (!(mh instanceof ObjectVariable)) {
                    logger.info("getGenericInvoker/Constructor returned " + mh + ", which is not an object.");
                    return;
                }
                StepIntoJSHandler.this.scriptToBeInvoked((ObjectVariable)mh);
            }
            catch (InvalidExpressionException invalidExpressionException) {
            }
            finally {
                this.setAltCSF(null);
                event.resume();
            }
        }

        private void setAltCSF(JPDAThread thread) {
            try {
                StackFrame sf;
                if (thread != null) {
                    ThreadReference tr = (ThreadReference)thread.getClass().getMethod("getThreadReference", new Class[0]).invoke((Object)thread, new Object[0]);
                    sf = tr.frame(0);
                } else {
                    sf = null;
                }
                StepIntoJSHandler.this.debugger.getClass().getMethod("setAltCSF", StackFrame.class).invoke((Object)StepIntoJSHandler.this.debugger, sf);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InternalException internalException) {
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    private class ScriptInvokeBPListener
    implements JPDABreakpointListener {
        private ScriptInvokeBPListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void breakpointReached(JPDABreakpointEvent event) {
            ObjectVariable mh;
            CallStackFrame frame;
            logger.fine("ScriptInvokeBPListener.breakpointReached()");
            try {
                CallStackFrame[] callStack = event.getThread().getCallStack(0, 1);
                if (callStack.length <= 0) return;
                frame = callStack[0];
                mh = null;
                try {
                    LocalVariable[] localVariables;
                    for (LocalVariable lv : localVariables = frame.getLocalVariables()) {
                        if (!StepIntoJSHandler.SCRIPT_NOTIFY_INVOKE_METHOD_ARG.equals(lv.getName())) continue;
                        mh = (ObjectVariable)lv;
                    }
                }
                catch (AbsentInformationException localVariables) {
                    // empty catch block
                }
            }
            catch (AbsentInformationException ex) {
                logger.log(Level.WARNING, "No debug info", ex);
                return;
            }
            if (mh == null) {
                try {
                    LocalVariable[] methodArguments = (LocalVariable[])frame.getClass().getMethod("getMethodArguments", new Class[0]).invoke((Object)frame, new Object[0]);
                    if (methodArguments.length > 0) {
                        mh = (ObjectVariable)methodArguments[0];
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    logger.log(Level.CONFIG, "Obtaining method argumnets", ex);
                }
            }
            if (mh != null) {
                StepIntoJSHandler.this.scriptToBeInvoked(mh);
                return;
            }
            logger.info("Unable to retrieve the method handle");
            return;
            finally {
                event.resume();
            }
        }
    }

    private class InScriptBPListener
    implements JPDABreakpointListener {
        private MethodBreakpoint mb;

        InScriptBPListener(MethodBreakpoint mb) {
            this.mb = mb;
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            logger.log(Level.FINE, "InScriptBPListener.breakpointReached(), removing {0}", this.mb);
            this.mb.disable();
            this.mb.removeJPDABreakpointListener((JPDABreakpointListener)this);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.mb);
            this.disableStepRequests(event.getThread());
        }

        private void disableStepRequests(JPDAThread thread) {
            ThreadReference tr;
            try {
                tr = (ThreadReference)thread.getClass().getMethod("getThreadReference", new Class[0]).invoke((Object)thread, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            try {
                VirtualMachine vm = tr.virtualMachine();
                if (vm == null) {
                    return;
                }
                EventRequestManager erm = vm.eventRequestManager();
                List<StepRequest> l = erm.stepRequests();
                for (StepRequest stepRequest : l) {
                    if (!stepRequest.thread().equals(tr)) continue;
                    try {
                        stepRequest.disable();
                    }
                    catch (InvalidRequestStateException invalidRequestStateException) {}
                }
            }
            catch (InternalException | VMDisconnectedException | InvalidRequestStateException | IllegalThreadStateException runtimeException) {
                // empty catch block
            }
        }
    }
}

