/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VolumeBackupPolicyAssignment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="assetId")
    private final String assetId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="policyId")
    private final String policyId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"assetId", "id", "policyId", "timeCreated"})
    public VolumeBackupPolicyAssignment(String assetId, String id, String policyId, Date timeCreated) {
        this.assetId = assetId;
        this.id = id;
        this.policyId = policyId;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getId() {
        return this.id;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VolumeBackupPolicyAssignment(");
        sb.append("super=").append(super.toString());
        sb.append("assetId=").append(String.valueOf(this.assetId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", policyId=").append(String.valueOf(this.policyId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VolumeBackupPolicyAssignment)) {
            return false;
        }
        VolumeBackupPolicyAssignment other = (VolumeBackupPolicyAssignment)((Object)o);
        return Objects.equals(this.assetId, other.assetId) && Objects.equals(this.id, other.id) && Objects.equals(this.policyId, other.policyId) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.assetId == null ? 43 : this.assetId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="assetId")
        private String assetId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="policyId")
        private String policyId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder assetId(String assetId) {
            this.assetId = assetId;
            this.__explicitlySet__.add("assetId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.__explicitlySet__.add("policyId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public VolumeBackupPolicyAssignment build() {
            VolumeBackupPolicyAssignment model = new VolumeBackupPolicyAssignment(this.assetId, this.id, this.policyId, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VolumeBackupPolicyAssignment model) {
            if (model.wasPropertyExplicitlySet("assetId")) {
                this.assetId(model.getAssetId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("policyId")) {
                this.policyId(model.getPolicyId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

