/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.karma.options.KarmaOptions;
import org.netbeans.modules.javascript.karma.options.KarmaOptionsValidator;
import org.netbeans.modules.javascript.karma.ui.options.KarmaOptionsPanel;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class KarmaOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String OPTIONS_CATEGORY = "Html5";
    public static final String OPTIONS_SUBCATEGORY = "Karma";
    public static final String OPTIONS_PATH = "Html5/Karma";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private KarmaOptionsPanel karmaOptionsPanel;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setKarma(this.getKarmaOptions().getKarma());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KarmaOptionsPanelController.this.getKarmaOptions().setKarma(KarmaOptionsPanelController.this.getPanel().getKarma());
                KarmaOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setKarma(this.getKarmaOptions().getKarma());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        KarmaOptionsPanel panel = this.getPanel();
        ValidationResult result = new KarmaOptionsValidator().validateKarma(panel.getKarma()).getResult();
        if (result.hasErrors()) {
            panel.setError(result.getFirstErrorMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(result.getFirstWarningMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getKarmaOptions().getKarma();
        String current = this.getPanel().getKarma().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.karma.ui.options.KarmaOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private KarmaOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.karmaOptionsPanel == null) {
            this.karmaOptionsPanel = new KarmaOptionsPanel();
            this.karmaOptionsPanel.addChangeListener(this);
        }
        return this.karmaOptionsPanel;
    }

    private KarmaOptions getKarmaOptions() {
        return KarmaOptions.getInstance();
    }
}

