/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.html.CssIdCompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssCompletionProvider
implements CompletionProvider {
    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        ArrayList<CompletionProposal> resultList = new ArrayList<CompletionProposal>();
        int caretOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(ccContext.getCaretOffset());
        String pref = ccContext.getPrefix();
        int offset = pref == null ? caretOffset : caretOffset - pref.length();
        switch (jsCompletionContext) {
            case STRING_ELEMENTS_BY_ID: {
                this.completeTagIds(ccContext.getParserResult(), pref, offset, resultList);
                break;
            }
            case STRING_ELEMENTS_BY_CLASS_NAME: {
                this.completeCSSClassNames(ccContext.getParserResult(), pref, offset, resultList);
            }
        }
        return resultList;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        return null;
    }

    private void completeTagIds(ParserResult parserInfo, String prefix, int astOffset, List<CompletionProposal> resultList) {
        FileObject fo = parserInfo.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findIdsByPrefix(prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    if (id.isEmpty()) continue;
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!unique.isEmpty()) {
            Iterator iterator = unique.iterator();
            while (iterator.hasNext()) {
                resultList.add(new CssIdCompletionItem((String)iterator.next(), parserInfo, astOffset));
            }
        }
    }

    private void completeCSSClassNames(ParserResult result, String prefix, int astOffset, List<CompletionProposal> resultList) {
        FileObject fo = result.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findClassesByPrefix(prefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    if (id.isEmpty()) continue;
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!unique.isEmpty()) {
            Iterator iterator = unique.iterator();
            while (iterator.hasNext()) {
                resultList.add(new CssIdCompletionItem((String)iterator.next(), result, astOffset));
            }
        }
    }
}

