/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.internal.wikitext.markdown.core.util.LookAheadReader;
import org.eclipse.mylyn.internal.wikitext.markdown.core.util.ReadAheadBlock;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;

public class ReadAheadDispatcher
extends NestableBlock {
    private final LookAheadReader lookAheadReader;
    private List<NestableBlock> blocks;
    private NestableBlock dispatchedBlock;

    public ReadAheadDispatcher(NestableBlock ... blocks) {
        this.blocks = this.cloneBlocks(Arrays.asList(blocks));
        this.lookAheadReader = new LookAheadReader();
    }

    public boolean canStart(String line, int lineOffset) {
        this.dispatchedBlock = null;
        return true;
    }

    protected int processLineContent(String line, int offset) {
        if (this.dispatchedBlock == null) {
            this.lookAheadReader.setContentState(this.getState());
            for (NestableBlock block : this.blocks) {
                if (block instanceof ReadAheadBlock) {
                    ReadAheadBlock raBlock = (ReadAheadBlock)ReadAheadBlock.class.cast((Object)block);
                    if (!raBlock.canStart(line, offset, this.lookAheadReader)) continue;
                    this.dispatchedBlock = block;
                    break;
                }
                if (!block.canStart(line, offset)) continue;
                this.dispatchedBlock = block;
                break;
            }
        }
        int result = this.dispatchedBlock.processLine(line, offset);
        if (this.dispatchedBlock.isClosed()) {
            this.setClosed(true);
        }
        return result;
    }

    public void setClosed(boolean closed) {
        this.dispatchedBlock.setClosed(closed);
        super.setClosed(closed);
    }

    public void setState(ContentState state) {
        for (NestableBlock block : this.blocks) {
            block.setState(state);
        }
        super.setState(state);
    }

    public void setParser(MarkupParser parser) {
        for (NestableBlock block : this.blocks) {
            block.setParser(parser);
        }
        super.setParser(parser);
    }

    @Override
    public NestableBlock clone() {
        ReadAheadDispatcher clone = (ReadAheadDispatcher)super.clone();
        clone.blocks = this.cloneBlocks(this.blocks);
        return clone;
    }

    private List<NestableBlock> cloneBlocks(List<NestableBlock> blocks) {
        ArrayList<NestableBlock> clonedBlocks = new ArrayList<NestableBlock>();
        for (NestableBlock block : blocks) {
            clonedBlocks.add(block.clone());
        }
        return clonedBlocks;
    }
}

