/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php.util;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;

public class PhpUtil {
    public static boolean isPhp(Document doc) {
        if (doc == null) {
            return false;
        }
        Object mimeType = doc.getProperty("mimeType");
        return mimeType != null && "text/x-php5".equals(mimeType);
    }

    public static String wrapWithTag(String content, Document doc, int insertStart) {
        boolean addTag;
        Object str = "";
        boolean bl = addTag = !PhpUtil.isWithinTag(doc, 0, insertStart);
        if (addTag) {
            str = (String)str + "\n<?php\n";
        }
        str = (String)str + content;
        if (addTag) {
            str = (String)str + "\n?>\n";
        }
        return str;
    }

    public static boolean isWithinTag(Document doc, int start, int end) {
        try {
            String str = doc.getText(start, end - start);
            return str.lastIndexOf("<?php") > str.lastIndexOf("?>");
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    public static int findText(Document document, String searchText, boolean firstToLast) throws BadLocationException {
        int len = document.getLength();
        String content = document.getText(0, len);
        if (firstToLast) {
            return content.indexOf(searchText);
        }
        return content.lastIndexOf(searchText);
    }

    public static String findParamValue(ParameterInfo param) {
        String paramVal = null;
        paramVal = param.isApiKey() ? "apiKey" : Util.findParamValue((ParameterInfo)param);
        return paramVal;
    }
}

