/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseConnectionCredentials;
import com.oracle.bmc.database.model.DatabaseConnectionString;
import com.oracle.bmc.database.model.UpdateExternalDatabaseConnectorDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateExternalMacsConnectorDetails
extends UpdateExternalDatabaseConnectorDetails {
    @JsonProperty(value="connectionString")
    private final DatabaseConnectionString connectionString;
    @JsonProperty(value="connectionCredentials")
    private final DatabaseConnectionCredentials connectionCredentials;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateExternalMacsConnectorDetails(Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String displayName, DatabaseConnectionString connectionString, DatabaseConnectionCredentials connectionCredentials) {
        super(freeformTags, definedTags, displayName);
        this.connectionString = connectionString;
        this.connectionCredentials = connectionCredentials;
    }

    public DatabaseConnectionString getConnectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateExternalMacsConnectorDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionString=").append(String.valueOf((Object)this.connectionString));
        sb.append(", connectionCredentials=").append(String.valueOf((Object)this.connectionCredentials));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExternalMacsConnectorDetails)) {
            return false;
        }
        UpdateExternalMacsConnectorDetails other = (UpdateExternalMacsConnectorDetails)((Object)o);
        return Objects.equals((Object)this.connectionString, (Object)other.connectionString) && Objects.equals((Object)this.connectionCredentials, (Object)other.connectionCredentials) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.connectionCredentials == null ? 43 : this.connectionCredentials.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="connectionString")
        private DatabaseConnectionString connectionString;
        @JsonProperty(value="connectionCredentials")
        private DatabaseConnectionCredentials connectionCredentials;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder connectionString(DatabaseConnectionString connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder connectionCredentials(DatabaseConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            this.__explicitlySet__.add("connectionCredentials");
            return this;
        }

        public UpdateExternalMacsConnectorDetails build() {
            UpdateExternalMacsConnectorDetails model = new UpdateExternalMacsConnectorDetails(this.freeformTags, this.definedTags, this.displayName, this.connectionString, this.connectionCredentials);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateExternalMacsConnectorDetails model) {
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentials")) {
                this.connectionCredentials(model.getConnectionCredentials());
            }
            return this;
        }
    }
}

