/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EncryptedData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ciphertext")
    private final String ciphertext;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;

    @Deprecated
    @ConstructorProperties(value={"ciphertext", "keyId", "keyVersionId", "encryptionAlgorithm"})
    public EncryptedData(String ciphertext, String keyId, String keyVersionId, EncryptionAlgorithm encryptionAlgorithm) {
        this.ciphertext = ciphertext;
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptedData(");
        sb.append("super=").append(super.toString());
        sb.append("ciphertext=").append(String.valueOf(this.ciphertext));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyVersionId=").append(String.valueOf(this.keyVersionId));
        sb.append(", encryptionAlgorithm=").append(String.valueOf((Object)this.encryptionAlgorithm));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedData)) {
            return false;
        }
        EncryptedData other = (EncryptedData)((Object)o);
        return Objects.equals(this.ciphertext, other.ciphertext) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.keyVersionId, other.keyVersionId) && Objects.equals((Object)this.encryptionAlgorithm, (Object)other.encryptionAlgorithm) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ciphertext == null ? 43 : this.ciphertext.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyVersionId == null ? 43 : this.keyVersionId.hashCode());
        result = result * 59 + (this.encryptionAlgorithm == null ? 43 : this.encryptionAlgorithm.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EncryptionAlgorithm implements BmcEnum
    {
        Aes256Gcm("AES_256_GCM"),
        RsaOaepSha1("RSA_OAEP_SHA_1"),
        RsaOaepSha256("RSA_OAEP_SHA_256"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EncryptionAlgorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EncryptionAlgorithm.class);
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ciphertext")
        private String ciphertext;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            this.__explicitlySet__.add("ciphertext");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public EncryptedData build() {
            EncryptedData model = new EncryptedData(this.ciphertext, this.keyId, this.keyVersionId, this.encryptionAlgorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EncryptedData model) {
            if (model.wasPropertyExplicitlySet("ciphertext")) {
                this.ciphertext(model.getCiphertext());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyVersionId")) {
                this.keyVersionId(model.getKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("encryptionAlgorithm")) {
                this.encryptionAlgorithm(model.getEncryptionAlgorithm());
            }
            return this;
        }
    }
}

