/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.util.Objects;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor2;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;

public class SchemaReference
extends AXIComponent {
    public static final String PROP_TARGET_NAMESPACE = "targetNamespace";
    public static final String PROP_SCHEMA_LOCATION = "schemaLocation";
    private final boolean include;
    private String targetNamespace;
    private String schemaLocation;

    public SchemaReference(AXIModel model, SchemaModelReference schemaComponent) {
        super(model, (SchemaComponent)schemaComponent);
        this.include = schemaComponent instanceof Include;
    }

    public SchemaReference(AXIModel model, boolean include) {
        super(model);
        this.include = include;
    }

    public SchemaReference(AXIModel model, AXIComponent sharedComponent) {
        super(model, sharedComponent);
        assert (sharedComponent instanceof SchemaReference);
        this.include = ((SchemaReference)sharedComponent).isInclude();
    }

    public boolean isInclude() {
        return this.include;
    }

    public boolean isImport() {
        return !this.include;
    }

    @Override
    public void accept(AXIVisitor visitor) {
        if (visitor instanceof AXIVisitor2) {
            ((AXIVisitor2)visitor).visit(this);
        }
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (this.isInclude() && targetNamespace != null) {
            throw new IllegalArgumentException("xs:include does not support targetNamespace");
        }
        String old = this.getTargetNamespace();
        if (Objects.equals(old, targetNamespace)) {
            return;
        }
        this.targetNamespace = targetNamespace;
        this.firePropertyChange(PROP_TARGET_NAMESPACE, old, targetNamespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        String old = this.getSchemaLocation();
        if (Objects.equals(old, schemaLocation)) {
            return;
        }
        this.schemaLocation = schemaLocation;
        this.firePropertyChange(PROP_SCHEMA_LOCATION, old, this.targetNamespace);
    }
}

