/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.jetty.jaas;

import com.dtolabs.rundeck.jetty.jaas.JettyCachingLdapLoginModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.rundeck.jaas.SharedLoginCreds;

public class JettyCombinedLdapLoginModule
extends JettyCachingLdapLoginModule {
    protected SharedLoginCreds shared;
    protected boolean _ignoreRoles = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.shared = new SharedLoginCreds(sharedState, options);
        this._ignoreRoles = Boolean.parseBoolean(String.valueOf(this.getOption(options, "ignoreRoles", Boolean.toString(this._ignoreRoles))));
    }

    protected List getUserRolesByDn(DirContext dirContext, String userDn, String username) throws LoginException, NamingException, IOException {
        if (this._ignoreRoles) {
            ArrayList strings = new ArrayList();
            this.addSupplementalRoles(strings);
            return strings;
        }
        return super.getUserRolesByDn(dirContext, userDn, username);
    }

    public boolean login() throws LoginException {
        if ((this.getShared().isUseFirstPass() || this.getShared().isTryFirstPass()) && this.getShared().isHasSharedAuth()) {
            this.debug(String.format("JettyCombinedLdapLoginModule: login with shared auth, try? %s, use? %s", this.getShared().isTryFirstPass(), this.getShared().isUseFirstPass()));
            this.setAuthenticated(this.authenticate(this.getShared().getSharedUserName(), this.getShared().getSharedUserPass()));
        }
        if (this.getShared().isUseFirstPass() && this.getShared().isHasSharedAuth()) {
            this.debug(String.format("AbstractSharedLoginModule: using login result: %s", this.isAuthenticated()));
            if (this.isAuthenticated()) {
                this.wasAuthenticated(this.getShared().getSharedUserName(), this.getShared().getSharedUserPass());
            }
            return this.isAuthenticated();
        }
        if (this.getShared().isHasSharedAuth()) {
            if (this.isAuthenticated()) {
                return this.isAuthenticated();
            }
            this.debug(String.format("AbstractSharedLoginModule: shared auth failed, now trying callback auth.", new Object[0]));
        }
        Object[] userPass = new Object[]{};
        try {
            userPass = this.getCallBackAuth();
        }
        catch (IOException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            throw new LoginException(e.toString());
        }
        if (null == userPass || userPass.length < 2) {
            this.setAuthenticated(false);
        } else {
            String name = (String)userPass[0];
            Object pass = userPass[1];
            this.setAuthenticated(this.authenticate(name, pass));
            if (this.isAuthenticated()) {
                this.wasAuthenticated(name, pass);
            }
        }
        return this.isAuthenticated();
    }

    protected void wasAuthenticated(String user, Object pass) {
        if (this.isAuthenticated() && this.getShared().isStorePass() && !this.getShared().isHasSharedAuth()) {
            this.getShared().storeLoginCreds(user, pass);
        }
    }

    public boolean commit() throws LoginException {
        if (this.getShared().isClearPass() && this.getShared().isHasSharedAuth()) {
            this.getShared().clear();
        }
        return super.commit();
    }

    public SharedLoginCreds getShared() {
        return this.shared;
    }
}

