/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListSearchIndexesIterable;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

final class ListSearchIndexesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListSearchIndexesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    @Nullable
    private Boolean allowDiskUse;
    @Nullable
    private long maxTimeMS;
    @Nullable
    private Collation collation;
    @Nullable
    private BsonValue comment;
    @Nullable
    private String indexName;
    private final CodecRegistry codecRegistry;

    ListSearchIndexesIterableImpl(MongoNamespace namespace, OperationExecutor executor, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, boolean retryReads) {
        super(null, executor, ReadConcern.DEFAULT, readPreference, retryReads);
        this.resultClass = resultClass;
        this.operations = new SyncOperations(namespace, BsonDocument.class, readPreference, codecRegistry, retryReads);
        this.codecRegistry = codecRegistry;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.asAggregateOperation();
    }

    @Override
    public ListSearchIndexesIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> name(String indexName) {
        this.indexName = (String)Assertions.notNull((String)"indexName", (Object)indexName);
        return this;
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity verbosity) {
        Assertions.notNull((String)"verbosity", (Object)verbosity);
        return this.executeExplain(Document.class, verbosity);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass) {
        Assertions.notNull((String)"explainResultClass", explainResultClass);
        return this.executeExplain(explainResultClass, null);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        Assertions.notNull((String)"explainResultClass", explainResultClass);
        Assertions.notNull((String)"verbosity", (Object)verbosity);
        return this.executeExplain(explainResultClass, verbosity);
    }

    private <E> E executeExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        return (E)this.getExecutor().execute(this.asAggregateOperation().asExplainableOperation(verbosity, (Decoder)this.codecRegistry.get(explainResultClass)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private ExplainableReadOperation<BatchCursor<TResult>> asAggregateOperation() {
        return this.operations.listSearchIndexes(this.resultClass, this.maxTimeMS, this.indexName, this.getBatchSize(), this.collation, this.comment, this.allowDiskUse);
    }
}

