/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.expression;

import java.util.List;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.spel.ExpressionDependencies;

record CompositeValueExpression(String raw, List<ValueExpression> expressions) implements ValueExpression
{
    @Override
    public String getExpressionString() {
        return this.raw;
    }

    @Override
    public ExpressionDependencies getExpressionDependencies() {
        ExpressionDependencies dependencies = ExpressionDependencies.none();
        for (ValueExpression expression : this.expressions) {
            ExpressionDependencies dependency = expression.getExpressionDependencies();
            if (dependency.equals(ExpressionDependencies.none())) continue;
            dependencies = dependencies.mergeWith(dependency);
        }
        return dependencies;
    }

    @Override
    public boolean isLiteral() {
        for (ValueExpression expression : this.expressions) {
            if (expression.isLiteral()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String evaluate(ValueEvaluationContext context) {
        StringBuilder builder = new StringBuilder();
        for (ValueExpression expression : this.expressions) {
            builder.append((String)expression.evaluate(context));
        }
        return builder.toString();
    }
}

