/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.F.C;
import com.ubnt.data.HostMeta;
import com.ubnt.data.Model;
import com.ubnt.data.ModelMeta;
import com.ubnt.model.api.model.ImmutableModelMetaDto;
import com.ubnt.service.system.O0oo;
import com.ubnt.service.uidb.OoOO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableModelMetaDto.class)
@Value.Immutable
@C
public interface ModelMetaDto {
    @JsonProperty(value="id")
    @Schema(name="Model UIDB id")
    public String id();

    @JsonProperty(value="model_name")
    @Schema(name="Model name")
    public Optional<String> name();

    @JsonProperty(value="model_abbreviation")
    @Schema(name="Model abbreviation")
    public Optional<String> abbreviation();

    @JsonProperty(value="model_fullName")
    @Schema(name="Model fullName")
    public Optional<String> fullName();

    @JsonProperty(value="model_sysid")
    @Schema(name="Model sysid")
    public Optional<String> sysid();

    @JsonProperty(value="sku")
    @Schema(name="Model sku")
    public Optional<String> sku();

    @JsonProperty(value="default_image_id")
    @Schema(name="Default image id")
    public String defaultImageId();

    @JsonProperty(value="nopadding_image_id")
    @Schema(name="No padding image id")
    public String noPaddingImageId();

    @JsonProperty(value="left_nopadding_image_id")
    @Schema(name="Left no-padding image id")
    public String leftNoPaddingImageId();

    @JsonProperty(value="right_nopadding_image_id")
    @Schema(name="Right no-padding image id")
    public String rightNoPaddingImageId();

    @JsonProperty(value="topology_image_id")
    @Schema(name="Topology image id")
    public String topologyImageId();

    public static ImmutableModelMetaDto.Builder builder() {
        return ImmutableModelMetaDto.builder();
    }

    public static ModelMetaDto of(ModelMeta modelMeta) {
        return ModelMetaDto.builder().id(modelMeta.id()).name(Optional.of(OoOO.\u00d200000(modelMeta.model()))).sku(Optional.ofNullable(modelMeta.sku())).abbreviation(Optional.ofNullable(modelMeta.abbrev())).fullName(Optional.ofNullable(modelMeta.fullName())).sysid(Optional.ofNullable(modelMeta.model().getSysIdInHexStringFormat())).defaultImageId(modelMeta.imageInfo().defaultImageId()).noPaddingImageId(modelMeta.imageInfo().noPaddingImageId()).leftNoPaddingImageId(modelMeta.imageInfo().leftNoPaddingImageId()).rightNoPaddingImageId(modelMeta.imageInfo().rightNoPaddingImageId()).topologyImageId(modelMeta.imageInfo().topologyImageId()).build();
    }

    public static ModelMetaDto of(Model model) {
        return ModelMetaDto.builder().id("").name(OoOO.\u00d200000(model)).sysid(Optional.of(model.getSysIdInHexStringFormat())).defaultImageId("").noPaddingImageId("").leftNoPaddingImageId("").rightNoPaddingImageId("").topologyImageId("").build();
    }

    public static ModelMetaDto of(HostMeta hostMeta) {
        ImmutableModelMetaDto.Builder builder = ModelMetaDto.builder().id(hostMeta.id()).sku(Optional.ofNullable(hostMeta.sku())).abbreviation(Optional.ofNullable(hostMeta.abbrev())).fullName(Optional.ofNullable(hostMeta.fullName())).defaultImageId(hostMeta.imageInfo().defaultImageId()).noPaddingImageId(hostMeta.imageInfo().noPaddingImageId()).leftNoPaddingImageId(hostMeta.imageInfo().leftNoPaddingImageId()).rightNoPaddingImageId(hostMeta.imageInfo().rightNoPaddingImageId()).topologyImageId(hostMeta.imageInfo().topologyImageId());
        O0oo o0oo2 = hostMeta.ubntDeviceType();
        if (o0oo2 != null) {
            builder.name(o0oo2.name()).sysid(o0oo2.\u00f400000());
        }
        return builder.build();
    }
}

