/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.model.api.Timezone;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.service.system.oO0Oo;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Tag(name="Timezone")
public class TimezoneController {
    private final oO0Oo o00000;

    public TimezoneController(oO0Oo oO0Oo2) {
        this.o00000 = oO0Oo2;
    }

    @AllowPrivilege(value={"admin", "readonly"})
    @GetMapping(value={"/api/timezones"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<Timezone> getTimezones() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return this.o00000.new().keySet().stream().filter(this::o00000).map(string -> {
            ZoneId zoneId = ZoneId.of(string);
            ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
            ZoneOffset zoneOffset = zonedDateTime.getOffset();
            String string2 = zoneOffset.getId().replaceAll("Z", "+00:00");
            return new AbstractMap.SimpleEntry<ZoneOffset, Timezone>(zoneOffset, new Timezone((String)string, string2));
        }).sorted(Comparator.comparing(AbstractMap.SimpleEntry::getKey).reversed()).map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList());
    }

    private boolean o00000(String string) {
        try {
            ZoneId.of(string);
            return true;
        }
        catch (ZoneRulesException zoneRulesException) {
            return false;
        }
    }
}

