// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/owner/v1/organization_service.proto

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListOrganizationsRequest_Order int32

const (
	ListOrganizationsRequest_ORDER_UNSPECIFIED ListOrganizationsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListOrganizationsRequest_ORDER_CREATE_TIME_DESC ListOrganizationsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListOrganizationsRequest_ORDER_CREATE_TIME_ASC ListOrganizationsRequest_Order = 2
)

// Enum value maps for ListOrganizationsRequest_Order.
var (
	ListOrganizationsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListOrganizationsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListOrganizationsRequest_Order) Enum() *ListOrganizationsRequest_Order {
	p := new(ListOrganizationsRequest_Order)
	*p = x
	return p
}

func (x ListOrganizationsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListOrganizationsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_organization_service_proto_enumTypes[0].Descriptor()
}

func (ListOrganizationsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_organization_service_proto_enumTypes[0]
}

func (x ListOrganizationsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListOrganizationsRequest_Order.Descriptor instead.
func (ListOrganizationsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{2, 0}
}

type GetOrganizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Organizations to request.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,1,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
}

func (x *GetOrganizationsRequest) Reset() {
	*x = GetOrganizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationsRequest) ProtoMessage() {}

func (x *GetOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationsRequest.ProtoReflect.Descriptor instead.
func (*GetOrganizationsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetOrganizationsRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

type GetOrganizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved Organizations in the same order as requested.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
}

func (x *GetOrganizationsResponse) Reset() {
	*x = GetOrganizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationsResponse) ProtoMessage() {}

func (x *GetOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationsResponse.ProtoReflect.Descriptor instead.
func (*GetOrganizationsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

type ListOrganizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The ids of the specific Users to list Organizations for.
	//
	// If this is empty, all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	UserRefs []*UserRef `protobuf:"bytes,3,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
	// The order to return the Organizations.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListOrganizationsRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.owner.v1.ListOrganizationsRequest_Order" json:"order,omitempty"`
}

func (x *ListOrganizationsRequest) Reset() {
	*x = ListOrganizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsRequest) ProtoMessage() {}

func (x *ListOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationsRequest.ProtoReflect.Descriptor instead.
func (*ListOrganizationsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListOrganizationsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrganizationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrganizationsRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

func (x *ListOrganizationsRequest) GetOrder() ListOrganizationsRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListOrganizationsRequest_ORDER_UNSPECIFIED
}

type ListOrganizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Organizations.
	Organizations []*Organization `protobuf:"bytes,2,rep,name=organizations,proto3" json:"organizations,omitempty"`
}

func (x *ListOrganizationsResponse) Reset() {
	*x = ListOrganizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsResponse) ProtoMessage() {}

func (x *ListOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationsResponse.ProtoReflect.Descriptor instead.
func (*ListOrganizationsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListOrganizationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

type CreateOrganizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Organizations to create.
	Values []*CreateOrganizationsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *CreateOrganizationsRequest) Reset() {
	*x = CreateOrganizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsRequest) ProtoMessage() {}

func (x *CreateOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrganizationsRequest.ProtoReflect.Descriptor instead.
func (*CreateOrganizationsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateOrganizationsRequest) GetValues() []*CreateOrganizationsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type CreateOrganizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created Organizations in the same order as given on the request.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
}

func (x *CreateOrganizationsResponse) Reset() {
	*x = CreateOrganizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsResponse) ProtoMessage() {}

func (x *CreateOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrganizationsResponse.ProtoReflect.Descriptor instead.
func (*CreateOrganizationsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

type UpdateOrganizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Organizations to update.
	Values []*UpdateOrganizationsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *UpdateOrganizationsRequest) Reset() {
	*x = UpdateOrganizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsRequest) ProtoMessage() {}

func (x *UpdateOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationsRequest.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateOrganizationsRequest) GetValues() []*UpdateOrganizationsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type UpdateOrganizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated Organizations in the same order as given on the request.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
}

func (x *UpdateOrganizationsResponse) Reset() {
	*x = UpdateOrganizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsResponse) ProtoMessage() {}

func (x *UpdateOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationsResponse.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

type DeleteOrganizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Organizations to delete.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,1,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
}

func (x *DeleteOrganizationsRequest) Reset() {
	*x = DeleteOrganizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationsRequest) ProtoMessage() {}

func (x *DeleteOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOrganizationsRequest.ProtoReflect.Descriptor instead.
func (*DeleteOrganizationsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteOrganizationsRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

type DeleteOrganizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteOrganizationsResponse) Reset() {
	*x = DeleteOrganizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationsResponse) ProtoMessage() {}

func (x *DeleteOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOrganizationsResponse.ProtoReflect.Descriptor instead.
func (*DeleteOrganizationsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{9}
}

// An individual request to create an Organization.
type CreateOrganizationsRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The configurable description of the Organization.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL that represents the homepage for an Organization.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// The verification status of the Organization.
	//
	// If not set, the Organization will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus OrganizationVerificationStatus `protobuf:"varint,4,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.OrganizationVerificationStatus" json:"verification_status,omitempty"`
}

func (x *CreateOrganizationsRequest_Value) Reset() {
	*x = CreateOrganizationsRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrganizationsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsRequest_Value) ProtoMessage() {}

func (x *CreateOrganizationsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrganizationsRequest_Value.ProtoReflect.Descriptor instead.
func (*CreateOrganizationsRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *CreateOrganizationsRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetVerificationStatus() OrganizationVerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED
}

// An individual request to update an Organization.
type UpdateOrganizationsRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The organization to update.
	OrganizationRef *OrganizationRef `protobuf:"bytes,1,opt,name=organization_ref,json=organizationRef,proto3" json:"organization_ref,omitempty"`
	// The configurable description of the Organization.
	Description *string `protobuf:"bytes,2,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL that represents the homepage for an Organization.
	Url *string `protobuf:"bytes,3,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The verification status of the Organization.
	VerificationStatus *OrganizationVerificationStatus `protobuf:"varint,4,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.OrganizationVerificationStatus,oneof" json:"verification_status,omitempty"`
}

func (x *UpdateOrganizationsRequest_Value) Reset() {
	*x = UpdateOrganizationsRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOrganizationsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsRequest_Value) ProtoMessage() {}

func (x *UpdateOrganizationsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationsRequest_Value.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationsRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *UpdateOrganizationsRequest_Value) GetOrganizationRef() *OrganizationRef {
	if x != nil {
		return x.OrganizationRef
	}
	return nil
}

func (x *UpdateOrganizationsRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateOrganizationsRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateOrganizationsRequest_Value) GetVerificationStatus() OrganizationVerificationStatus {
	if x != nil && x.VerificationStatus != nil {
		return *x.VerificationStatus
	}
	return OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED
}

var File_buf_registry_owner_v1_organization_service_proto protoreflect.FileDescriptor

var file_buf_registry_owner_v1_organization_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x15, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a,
	0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66,
	0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x10, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x73, 0x22,
	0x6f, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xd5, 0x02, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18,
	0x80, 0x20, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3b, 0x0a,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x66,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x52, 0x65, 0x66, 0x73, 0x12, 0x55, 0x0a, 0x05, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x22, 0x55, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x01, 0x12, 0x19, 0x0a,
	0x15, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x10, 0x02, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x49, 0x0a, 0x0d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x81, 0x03, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08,
	0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x1a, 0x84, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xba, 0x48, 0x24, 0xc8, 0x01, 0x01,
	0x72, 0x1f, 0x10, 0x02, 0x18, 0x20, 0x32, 0x19, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x5d, 0x5b, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x2d, 0x5d, 0x2a, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d,
	0x24, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48,
	0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0e, 0xba, 0x48, 0x0b, 0xd8, 0x01, 0x01, 0x72, 0x06, 0x18, 0xff, 0x01, 0x88, 0x01, 0x01,
	0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x70, 0x0a, 0x13, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x72, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe1, 0x03, 0x0a, 0x1a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xe4, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x59, 0x0a, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x0f, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x12, 0x2f, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x48, 0x00, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x25,
	0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0e, 0xba, 0x48, 0x0b,
	0xd8, 0x01, 0x02, 0x72, 0x06, 0x18, 0xff, 0x01, 0x88, 0x01, 0x01, 0x48, 0x01, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x78, 0x0a, 0x13, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x82, 0x01,
	0x05, 0x10, 0x01, 0x22, 0x01, 0x00, 0x48, 0x02, 0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x06, 0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x72, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53,
	0x0a, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92,
	0x01, 0x02, 0x08, 0x01, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x7e, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x60, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa,
	0x01, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x66, 0x73, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x32, 0x98, 0x05, 0x0a, 0x13, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x78, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0x7b, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x01, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x42, 0x55, 0x5a,
	0x53, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67,
	0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_owner_v1_organization_service_proto_rawDescOnce sync.Once
	file_buf_registry_owner_v1_organization_service_proto_rawDescData = file_buf_registry_owner_v1_organization_service_proto_rawDesc
)

func file_buf_registry_owner_v1_organization_service_proto_rawDescGZIP() []byte {
	file_buf_registry_owner_v1_organization_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_owner_v1_organization_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_owner_v1_organization_service_proto_rawDescData)
	})
	return file_buf_registry_owner_v1_organization_service_proto_rawDescData
}

var file_buf_registry_owner_v1_organization_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_owner_v1_organization_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_owner_v1_organization_service_proto_goTypes = []any{
	(ListOrganizationsRequest_Order)(0),      // 0: buf.registry.owner.v1.ListOrganizationsRequest.Order
	(*GetOrganizationsRequest)(nil),          // 1: buf.registry.owner.v1.GetOrganizationsRequest
	(*GetOrganizationsResponse)(nil),         // 2: buf.registry.owner.v1.GetOrganizationsResponse
	(*ListOrganizationsRequest)(nil),         // 3: buf.registry.owner.v1.ListOrganizationsRequest
	(*ListOrganizationsResponse)(nil),        // 4: buf.registry.owner.v1.ListOrganizationsResponse
	(*CreateOrganizationsRequest)(nil),       // 5: buf.registry.owner.v1.CreateOrganizationsRequest
	(*CreateOrganizationsResponse)(nil),      // 6: buf.registry.owner.v1.CreateOrganizationsResponse
	(*UpdateOrganizationsRequest)(nil),       // 7: buf.registry.owner.v1.UpdateOrganizationsRequest
	(*UpdateOrganizationsResponse)(nil),      // 8: buf.registry.owner.v1.UpdateOrganizationsResponse
	(*DeleteOrganizationsRequest)(nil),       // 9: buf.registry.owner.v1.DeleteOrganizationsRequest
	(*DeleteOrganizationsResponse)(nil),      // 10: buf.registry.owner.v1.DeleteOrganizationsResponse
	(*CreateOrganizationsRequest_Value)(nil), // 11: buf.registry.owner.v1.CreateOrganizationsRequest.Value
	(*UpdateOrganizationsRequest_Value)(nil), // 12: buf.registry.owner.v1.UpdateOrganizationsRequest.Value
	(*OrganizationRef)(nil),                  // 13: buf.registry.owner.v1.OrganizationRef
	(*Organization)(nil),                     // 14: buf.registry.owner.v1.Organization
	(*UserRef)(nil),                          // 15: buf.registry.owner.v1.UserRef
	(OrganizationVerificationStatus)(0),      // 16: buf.registry.owner.v1.OrganizationVerificationStatus
}
var file_buf_registry_owner_v1_organization_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.owner.v1.GetOrganizationsRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	14, // 1: buf.registry.owner.v1.GetOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	15, // 2: buf.registry.owner.v1.ListOrganizationsRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	0,  // 3: buf.registry.owner.v1.ListOrganizationsRequest.order:type_name -> buf.registry.owner.v1.ListOrganizationsRequest.Order
	14, // 4: buf.registry.owner.v1.ListOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	11, // 5: buf.registry.owner.v1.CreateOrganizationsRequest.values:type_name -> buf.registry.owner.v1.CreateOrganizationsRequest.Value
	14, // 6: buf.registry.owner.v1.CreateOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	12, // 7: buf.registry.owner.v1.UpdateOrganizationsRequest.values:type_name -> buf.registry.owner.v1.UpdateOrganizationsRequest.Value
	14, // 8: buf.registry.owner.v1.UpdateOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	13, // 9: buf.registry.owner.v1.DeleteOrganizationsRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	16, // 10: buf.registry.owner.v1.CreateOrganizationsRequest.Value.verification_status:type_name -> buf.registry.owner.v1.OrganizationVerificationStatus
	13, // 11: buf.registry.owner.v1.UpdateOrganizationsRequest.Value.organization_ref:type_name -> buf.registry.owner.v1.OrganizationRef
	16, // 12: buf.registry.owner.v1.UpdateOrganizationsRequest.Value.verification_status:type_name -> buf.registry.owner.v1.OrganizationVerificationStatus
	1,  // 13: buf.registry.owner.v1.OrganizationService.GetOrganizations:input_type -> buf.registry.owner.v1.GetOrganizationsRequest
	3,  // 14: buf.registry.owner.v1.OrganizationService.ListOrganizations:input_type -> buf.registry.owner.v1.ListOrganizationsRequest
	5,  // 15: buf.registry.owner.v1.OrganizationService.CreateOrganizations:input_type -> buf.registry.owner.v1.CreateOrganizationsRequest
	7,  // 16: buf.registry.owner.v1.OrganizationService.UpdateOrganizations:input_type -> buf.registry.owner.v1.UpdateOrganizationsRequest
	9,  // 17: buf.registry.owner.v1.OrganizationService.DeleteOrganizations:input_type -> buf.registry.owner.v1.DeleteOrganizationsRequest
	2,  // 18: buf.registry.owner.v1.OrganizationService.GetOrganizations:output_type -> buf.registry.owner.v1.GetOrganizationsResponse
	4,  // 19: buf.registry.owner.v1.OrganizationService.ListOrganizations:output_type -> buf.registry.owner.v1.ListOrganizationsResponse
	6,  // 20: buf.registry.owner.v1.OrganizationService.CreateOrganizations:output_type -> buf.registry.owner.v1.CreateOrganizationsResponse
	8,  // 21: buf.registry.owner.v1.OrganizationService.UpdateOrganizations:output_type -> buf.registry.owner.v1.UpdateOrganizationsResponse
	10, // 22: buf.registry.owner.v1.OrganizationService.DeleteOrganizations:output_type -> buf.registry.owner.v1.DeleteOrganizationsResponse
	18, // [18:23] is the sub-list for method output_type
	13, // [13:18] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_organization_service_proto_init() }
func file_buf_registry_owner_v1_organization_service_proto_init() {
	if File_buf_registry_owner_v1_organization_service_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_init()
	file_buf_registry_owner_v1_user_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetOrganizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetOrganizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListOrganizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListOrganizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrganizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrganizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateOrganizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateOrganizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteOrganizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteOrganizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrganizationsRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_organization_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateOrganizationsRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_registry_owner_v1_organization_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_owner_v1_organization_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_owner_v1_organization_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_organization_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_organization_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_organization_service_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_organization_service_proto = out.File
	file_buf_registry_owner_v1_organization_service_proto_rawDesc = nil
	file_buf_registry_owner_v1_organization_service_proto_goTypes = nil
	file_buf_registry_owner_v1_organization_service_proto_depIdxs = nil
}
