// Copyright 2013 Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This is copied and lightly edited from
// github.com/prometheus/client_model/io/prometheus/client/metrics.proto
// and finally converted to proto3 syntax to make it usable for the
// gogo-protobuf approach taken within prometheus/prometheus.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: io/prometheus/client/metrics.proto

//go:build protoopaque

package client

import (
	_ "buf.build/gen/go/gogo/protobuf/protocolbuffers/go/gogoproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricType int32

const (
	// COUNTER must use the Metric field "counter".
	MetricType_COUNTER MetricType = 0
	// GAUGE must use the Metric field "gauge".
	MetricType_GAUGE MetricType = 1
	// SUMMARY must use the Metric field "summary".
	MetricType_SUMMARY MetricType = 2
	// UNTYPED must use the Metric field "untyped".
	MetricType_UNTYPED MetricType = 3
	// HISTOGRAM must use the Metric field "histogram".
	MetricType_HISTOGRAM MetricType = 4
	// GAUGE_HISTOGRAM must use the Metric field "histogram".
	MetricType_GAUGE_HISTOGRAM MetricType = 5
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "COUNTER",
		1: "GAUGE",
		2: "SUMMARY",
		3: "UNTYPED",
		4: "HISTOGRAM",
		5: "GAUGE_HISTOGRAM",
	}
	MetricType_value = map[string]int32{
		"COUNTER":         0,
		"GAUGE":           1,
		"SUMMARY":         2,
		"UNTYPED":         3,
		"HISTOGRAM":       4,
		"GAUGE_HISTOGRAM": 5,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_io_prometheus_client_metrics_proto_enumTypes[0].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_io_prometheus_client_metrics_proto_enumTypes[0]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type LabelPair struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name  string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Value string                 `protobuf:"bytes,2,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LabelPair) Reset() {
	*x = LabelPair{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelPair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelPair) ProtoMessage() {}

func (x *LabelPair) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelPair) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *LabelPair) GetValue() string {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return ""
}

func (x *LabelPair) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *LabelPair) SetValue(v string) {
	x.xxx_hidden_Value = v
}

type LabelPair_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name  string
	Value string
}

func (b0 LabelPair_builder) Build() *LabelPair {
	m0 := &LabelPair{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Value = b.Value
	return m0
}

type Gauge struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Gauge) Reset() {
	*x = Gauge{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Gauge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gauge) ProtoMessage() {}

func (x *Gauge) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Gauge) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Gauge) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Gauge_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
}

func (b0 Gauge_builder) Build() *Gauge {
	m0 := &Gauge{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	return m0
}

type Counter struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value            float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	xxx_hidden_Exemplar         *Exemplar              `protobuf:"bytes,2,opt,name=exemplar,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Counter) Reset() {
	*x = Counter{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Counter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counter) ProtoMessage() {}

func (x *Counter) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Counter) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Counter) GetExemplar() *Exemplar {
	if x != nil {
		return x.xxx_hidden_Exemplar
	}
	return nil
}

func (x *Counter) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Counter) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Counter) SetExemplar(v *Exemplar) {
	x.xxx_hidden_Exemplar = v
}

func (x *Counter) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Counter) HasExemplar() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Exemplar != nil
}

func (x *Counter) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Counter) ClearExemplar() {
	x.xxx_hidden_Exemplar = nil
}

func (x *Counter) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Counter_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value            float64
	Exemplar         *Exemplar
	CreatedTimestamp *timestamppb.Timestamp
}

func (b0 Counter_builder) Build() *Counter {
	m0 := &Counter{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Exemplar = b.Exemplar
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	return m0
}

type Quantile struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Quantile float64                `protobuf:"fixed64,1,opt,name=quantile,proto3"`
	xxx_hidden_Value    float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Quantile) Reset() {
	*x = Quantile{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Quantile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Quantile) ProtoMessage() {}

func (x *Quantile) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Quantile) GetQuantile() float64 {
	if x != nil {
		return x.xxx_hidden_Quantile
	}
	return 0
}

func (x *Quantile) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Quantile) SetQuantile(v float64) {
	x.xxx_hidden_Quantile = v
}

func (x *Quantile) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Quantile_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Quantile float64
	Value    float64
}

func (b0 Quantile_builder) Build() *Quantile {
	m0 := &Quantile{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Quantile = b.Quantile
	x.xxx_hidden_Value = b.Value
	return m0
}

type Summary struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SampleCount      uint64                 `protobuf:"varint,1,opt,name=sample_count,json=sampleCount,proto3"`
	xxx_hidden_SampleSum        float64                `protobuf:"fixed64,2,opt,name=sample_sum,json=sampleSum,proto3"`
	xxx_hidden_Quantile         *[]*Quantile           `protobuf:"bytes,3,rep,name=quantile,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Summary) Reset() {
	*x = Summary{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Summary) ProtoMessage() {}

func (x *Summary) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Summary) GetSampleCount() uint64 {
	if x != nil {
		return x.xxx_hidden_SampleCount
	}
	return 0
}

func (x *Summary) GetSampleSum() float64 {
	if x != nil {
		return x.xxx_hidden_SampleSum
	}
	return 0
}

func (x *Summary) GetQuantile() []*Quantile {
	if x != nil {
		if x.xxx_hidden_Quantile != nil {
			return *x.xxx_hidden_Quantile
		}
	}
	return nil
}

func (x *Summary) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Summary) SetSampleCount(v uint64) {
	x.xxx_hidden_SampleCount = v
}

func (x *Summary) SetSampleSum(v float64) {
	x.xxx_hidden_SampleSum = v
}

func (x *Summary) SetQuantile(v []*Quantile) {
	x.xxx_hidden_Quantile = &v
}

func (x *Summary) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Summary) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Summary) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Summary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SampleCount      uint64
	SampleSum        float64
	Quantile         []*Quantile
	CreatedTimestamp *timestamppb.Timestamp
}

func (b0 Summary_builder) Build() *Summary {
	m0 := &Summary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SampleCount = b.SampleCount
	x.xxx_hidden_SampleSum = b.SampleSum
	x.xxx_hidden_Quantile = &b.Quantile
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	return m0
}

type Untyped struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Untyped) Reset() {
	*x = Untyped{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Untyped) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Untyped) ProtoMessage() {}

func (x *Untyped) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Untyped) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Untyped) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Untyped_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
}

func (b0 Untyped_builder) Build() *Untyped {
	m0 := &Untyped{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	return m0
}

type Histogram struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SampleCount      uint64                 `protobuf:"varint,1,opt,name=sample_count,json=sampleCount,proto3"`
	xxx_hidden_SampleCountFloat float64                `protobuf:"fixed64,4,opt,name=sample_count_float,json=sampleCountFloat,proto3"`
	xxx_hidden_SampleSum        float64                `protobuf:"fixed64,2,opt,name=sample_sum,json=sampleSum,proto3"`
	xxx_hidden_Bucket           *[]*Bucket             `protobuf:"bytes,3,rep,name=bucket,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	xxx_hidden_Schema           int32                  `protobuf:"zigzag32,5,opt,name=schema,proto3"`
	xxx_hidden_ZeroThreshold    float64                `protobuf:"fixed64,6,opt,name=zero_threshold,json=zeroThreshold,proto3"`
	xxx_hidden_ZeroCount        uint64                 `protobuf:"varint,7,opt,name=zero_count,json=zeroCount,proto3"`
	xxx_hidden_ZeroCountFloat   float64                `protobuf:"fixed64,8,opt,name=zero_count_float,json=zeroCountFloat,proto3"`
	xxx_hidden_NegativeSpan     *[]*BucketSpan         `protobuf:"bytes,9,rep,name=negative_span,json=negativeSpan,proto3"`
	xxx_hidden_NegativeDelta    []int64                `protobuf:"zigzag64,10,rep,packed,name=negative_delta,json=negativeDelta,proto3"`
	xxx_hidden_NegativeCount    []float64              `protobuf:"fixed64,11,rep,packed,name=negative_count,json=negativeCount,proto3"`
	xxx_hidden_PositiveSpan     *[]*BucketSpan         `protobuf:"bytes,12,rep,name=positive_span,json=positiveSpan,proto3"`
	xxx_hidden_PositiveDelta    []int64                `protobuf:"zigzag64,13,rep,packed,name=positive_delta,json=positiveDelta,proto3"`
	xxx_hidden_PositiveCount    []float64              `protobuf:"fixed64,14,rep,packed,name=positive_count,json=positiveCount,proto3"`
	xxx_hidden_Exemplars        *[]*Exemplar           `protobuf:"bytes,16,rep,name=exemplars,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Histogram) Reset() {
	*x = Histogram{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Histogram) ProtoMessage() {}

func (x *Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Histogram) GetSampleCount() uint64 {
	if x != nil {
		return x.xxx_hidden_SampleCount
	}
	return 0
}

func (x *Histogram) GetSampleCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_SampleCountFloat
	}
	return 0
}

func (x *Histogram) GetSampleSum() float64 {
	if x != nil {
		return x.xxx_hidden_SampleSum
	}
	return 0
}

func (x *Histogram) GetBucket() []*Bucket {
	if x != nil {
		if x.xxx_hidden_Bucket != nil {
			return *x.xxx_hidden_Bucket
		}
	}
	return nil
}

func (x *Histogram) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Histogram) GetSchema() int32 {
	if x != nil {
		return x.xxx_hidden_Schema
	}
	return 0
}

func (x *Histogram) GetZeroThreshold() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroThreshold
	}
	return 0
}

func (x *Histogram) GetZeroCount() uint64 {
	if x != nil {
		return x.xxx_hidden_ZeroCount
	}
	return 0
}

func (x *Histogram) GetZeroCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroCountFloat
	}
	return 0
}

func (x *Histogram) GetNegativeSpan() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_NegativeSpan != nil {
			return *x.xxx_hidden_NegativeSpan
		}
	}
	return nil
}

func (x *Histogram) GetNegativeDelta() []int64 {
	if x != nil {
		return x.xxx_hidden_NegativeDelta
	}
	return nil
}

func (x *Histogram) GetNegativeCount() []float64 {
	if x != nil {
		return x.xxx_hidden_NegativeCount
	}
	return nil
}

func (x *Histogram) GetPositiveSpan() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_PositiveSpan != nil {
			return *x.xxx_hidden_PositiveSpan
		}
	}
	return nil
}

func (x *Histogram) GetPositiveDelta() []int64 {
	if x != nil {
		return x.xxx_hidden_PositiveDelta
	}
	return nil
}

func (x *Histogram) GetPositiveCount() []float64 {
	if x != nil {
		return x.xxx_hidden_PositiveCount
	}
	return nil
}

func (x *Histogram) GetExemplars() []*Exemplar {
	if x != nil {
		if x.xxx_hidden_Exemplars != nil {
			return *x.xxx_hidden_Exemplars
		}
	}
	return nil
}

func (x *Histogram) SetSampleCount(v uint64) {
	x.xxx_hidden_SampleCount = v
}

func (x *Histogram) SetSampleCountFloat(v float64) {
	x.xxx_hidden_SampleCountFloat = v
}

func (x *Histogram) SetSampleSum(v float64) {
	x.xxx_hidden_SampleSum = v
}

func (x *Histogram) SetBucket(v []*Bucket) {
	x.xxx_hidden_Bucket = &v
}

func (x *Histogram) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Histogram) SetSchema(v int32) {
	x.xxx_hidden_Schema = v
}

func (x *Histogram) SetZeroThreshold(v float64) {
	x.xxx_hidden_ZeroThreshold = v
}

func (x *Histogram) SetZeroCount(v uint64) {
	x.xxx_hidden_ZeroCount = v
}

func (x *Histogram) SetZeroCountFloat(v float64) {
	x.xxx_hidden_ZeroCountFloat = v
}

func (x *Histogram) SetNegativeSpan(v []*BucketSpan) {
	x.xxx_hidden_NegativeSpan = &v
}

func (x *Histogram) SetNegativeDelta(v []int64) {
	x.xxx_hidden_NegativeDelta = v
}

func (x *Histogram) SetNegativeCount(v []float64) {
	x.xxx_hidden_NegativeCount = v
}

func (x *Histogram) SetPositiveSpan(v []*BucketSpan) {
	x.xxx_hidden_PositiveSpan = &v
}

func (x *Histogram) SetPositiveDelta(v []int64) {
	x.xxx_hidden_PositiveDelta = v
}

func (x *Histogram) SetPositiveCount(v []float64) {
	x.xxx_hidden_PositiveCount = v
}

func (x *Histogram) SetExemplars(v []*Exemplar) {
	x.xxx_hidden_Exemplars = &v
}

func (x *Histogram) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Histogram) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Histogram_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SampleCount      uint64
	SampleCountFloat float64
	SampleSum        float64
	// Buckets for the classic histogram.
	Bucket           []*Bucket
	CreatedTimestamp *timestamppb.Timestamp
	// schema defines the bucket schema. Currently, valid numbers are -4 <= n <= 8.
	// They are all for base-2 bucket schemas, where 1 is a bucket boundary in each case, and
	// then each power of two is divided into 2^n logarithmic buckets.
	// Or in other words, each bucket boundary is the previous boundary times 2^(2^-n).
	// In the future, more bucket schemas may be added using numbers < -4 or > 8.
	Schema         int32
	ZeroThreshold  float64
	ZeroCount      uint64
	ZeroCountFloat float64
	// Negative buckets for the native histogram.
	NegativeSpan []*BucketSpan
	// Use either "negative_delta" or "negative_count", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	NegativeDelta []int64
	NegativeCount []float64
	// Positive buckets for the native histogram.
	// Use a no-op span (offset 0, length 0) for a native histogram without any
	// observations yet and with a zero_threshold of 0. Otherwise, it would be
	// indistinguishable from a classic histogram.
	PositiveSpan []*BucketSpan
	// Use either "positive_delta" or "positive_count", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	PositiveDelta []int64
	PositiveCount []float64
	// Only used for native histograms. These exemplars MUST have a timestamp.
	Exemplars []*Exemplar
}

func (b0 Histogram_builder) Build() *Histogram {
	m0 := &Histogram{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SampleCount = b.SampleCount
	x.xxx_hidden_SampleCountFloat = b.SampleCountFloat
	x.xxx_hidden_SampleSum = b.SampleSum
	x.xxx_hidden_Bucket = &b.Bucket
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	x.xxx_hidden_Schema = b.Schema
	x.xxx_hidden_ZeroThreshold = b.ZeroThreshold
	x.xxx_hidden_ZeroCount = b.ZeroCount
	x.xxx_hidden_ZeroCountFloat = b.ZeroCountFloat
	x.xxx_hidden_NegativeSpan = &b.NegativeSpan
	x.xxx_hidden_NegativeDelta = b.NegativeDelta
	x.xxx_hidden_NegativeCount = b.NegativeCount
	x.xxx_hidden_PositiveSpan = &b.PositiveSpan
	x.xxx_hidden_PositiveDelta = b.PositiveDelta
	x.xxx_hidden_PositiveCount = b.PositiveCount
	x.xxx_hidden_Exemplars = &b.Exemplars
	return m0
}

type Bucket struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CumulativeCount      uint64                 `protobuf:"varint,1,opt,name=cumulative_count,json=cumulativeCount,proto3"`
	xxx_hidden_CumulativeCountFloat float64                `protobuf:"fixed64,4,opt,name=cumulative_count_float,json=cumulativeCountFloat,proto3"`
	xxx_hidden_UpperBound           float64                `protobuf:"fixed64,2,opt,name=upper_bound,json=upperBound,proto3"`
	xxx_hidden_Exemplar             *Exemplar              `protobuf:"bytes,3,opt,name=exemplar,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Bucket) GetCumulativeCount() uint64 {
	if x != nil {
		return x.xxx_hidden_CumulativeCount
	}
	return 0
}

func (x *Bucket) GetCumulativeCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_CumulativeCountFloat
	}
	return 0
}

func (x *Bucket) GetUpperBound() float64 {
	if x != nil {
		return x.xxx_hidden_UpperBound
	}
	return 0
}

func (x *Bucket) GetExemplar() *Exemplar {
	if x != nil {
		return x.xxx_hidden_Exemplar
	}
	return nil
}

func (x *Bucket) SetCumulativeCount(v uint64) {
	x.xxx_hidden_CumulativeCount = v
}

func (x *Bucket) SetCumulativeCountFloat(v float64) {
	x.xxx_hidden_CumulativeCountFloat = v
}

func (x *Bucket) SetUpperBound(v float64) {
	x.xxx_hidden_UpperBound = v
}

func (x *Bucket) SetExemplar(v *Exemplar) {
	x.xxx_hidden_Exemplar = v
}

func (x *Bucket) HasExemplar() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Exemplar != nil
}

func (x *Bucket) ClearExemplar() {
	x.xxx_hidden_Exemplar = nil
}

type Bucket_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	CumulativeCount      uint64
	CumulativeCountFloat float64
	UpperBound           float64
	Exemplar             *Exemplar
}

func (b0 Bucket_builder) Build() *Bucket {
	m0 := &Bucket{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CumulativeCount = b.CumulativeCount
	x.xxx_hidden_CumulativeCountFloat = b.CumulativeCountFloat
	x.xxx_hidden_UpperBound = b.UpperBound
	x.xxx_hidden_Exemplar = b.Exemplar
	return m0
}

// A BucketSpan defines a number of consecutive buckets in a native
// histogram with their offset. Logically, it would be more
// straightforward to include the bucket counts in the Span. However,
// the protobuf representation is more compact in the way the data is
// structured here (with all the buckets in a single array separate
// from the Spans).
type BucketSpan struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Offset int32                  `protobuf:"zigzag32,1,opt,name=offset,proto3"`
	xxx_hidden_Length uint32                 `protobuf:"varint,2,opt,name=length,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *BucketSpan) Reset() {
	*x = BucketSpan{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketSpan) ProtoMessage() {}

func (x *BucketSpan) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BucketSpan) GetOffset() int32 {
	if x != nil {
		return x.xxx_hidden_Offset
	}
	return 0
}

func (x *BucketSpan) GetLength() uint32 {
	if x != nil {
		return x.xxx_hidden_Length
	}
	return 0
}

func (x *BucketSpan) SetOffset(v int32) {
	x.xxx_hidden_Offset = v
}

func (x *BucketSpan) SetLength(v uint32) {
	x.xxx_hidden_Length = v
}

type BucketSpan_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset int32
	Length uint32
}

func (b0 BucketSpan_builder) Build() *BucketSpan {
	m0 := &BucketSpan{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Offset = b.Offset
	x.xxx_hidden_Length = b.Length
	return m0
}

type Exemplar struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Label     *[]*LabelPair          `protobuf:"bytes,1,rep,name=label,proto3"`
	xxx_hidden_Value     float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	xxx_hidden_Timestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Exemplar) GetLabel() []*LabelPair {
	if x != nil {
		if x.xxx_hidden_Label != nil {
			return *x.xxx_hidden_Label
		}
	}
	return nil
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return nil
}

func (x *Exemplar) SetLabel(v []*LabelPair) {
	x.xxx_hidden_Label = &v
}

func (x *Exemplar) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Exemplar) SetTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_Timestamp = v
}

func (x *Exemplar) HasTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Timestamp != nil
}

func (x *Exemplar) ClearTimestamp() {
	x.xxx_hidden_Timestamp = nil
}

type Exemplar_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Label     []*LabelPair
	Value     float64
	Timestamp *timestamppb.Timestamp
}

func (b0 Exemplar_builder) Build() *Exemplar {
	m0 := &Exemplar{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Label = &b.Label
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

type Metric struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Label       *[]*LabelPair          `protobuf:"bytes,1,rep,name=label,proto3"`
	xxx_hidden_Gauge       *Gauge                 `protobuf:"bytes,2,opt,name=gauge,proto3"`
	xxx_hidden_Counter     *Counter               `protobuf:"bytes,3,opt,name=counter,proto3"`
	xxx_hidden_Summary     *Summary               `protobuf:"bytes,4,opt,name=summary,proto3"`
	xxx_hidden_Untyped     *Untyped               `protobuf:"bytes,5,opt,name=untyped,proto3"`
	xxx_hidden_Histogram   *Histogram             `protobuf:"bytes,7,opt,name=histogram,proto3"`
	xxx_hidden_TimestampMs int64                  `protobuf:"varint,6,opt,name=timestamp_ms,json=timestampMs,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *Metric) Reset() {
	*x = Metric{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Metric) GetLabel() []*LabelPair {
	if x != nil {
		if x.xxx_hidden_Label != nil {
			return *x.xxx_hidden_Label
		}
	}
	return nil
}

func (x *Metric) GetGauge() *Gauge {
	if x != nil {
		return x.xxx_hidden_Gauge
	}
	return nil
}

func (x *Metric) GetCounter() *Counter {
	if x != nil {
		return x.xxx_hidden_Counter
	}
	return nil
}

func (x *Metric) GetSummary() *Summary {
	if x != nil {
		return x.xxx_hidden_Summary
	}
	return nil
}

func (x *Metric) GetUntyped() *Untyped {
	if x != nil {
		return x.xxx_hidden_Untyped
	}
	return nil
}

func (x *Metric) GetHistogram() *Histogram {
	if x != nil {
		return x.xxx_hidden_Histogram
	}
	return nil
}

func (x *Metric) GetTimestampMs() int64 {
	if x != nil {
		return x.xxx_hidden_TimestampMs
	}
	return 0
}

func (x *Metric) SetLabel(v []*LabelPair) {
	x.xxx_hidden_Label = &v
}

func (x *Metric) SetGauge(v *Gauge) {
	x.xxx_hidden_Gauge = v
}

func (x *Metric) SetCounter(v *Counter) {
	x.xxx_hidden_Counter = v
}

func (x *Metric) SetSummary(v *Summary) {
	x.xxx_hidden_Summary = v
}

func (x *Metric) SetUntyped(v *Untyped) {
	x.xxx_hidden_Untyped = v
}

func (x *Metric) SetHistogram(v *Histogram) {
	x.xxx_hidden_Histogram = v
}

func (x *Metric) SetTimestampMs(v int64) {
	x.xxx_hidden_TimestampMs = v
}

func (x *Metric) HasGauge() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Gauge != nil
}

func (x *Metric) HasCounter() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counter != nil
}

func (x *Metric) HasSummary() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Summary != nil
}

func (x *Metric) HasUntyped() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Untyped != nil
}

func (x *Metric) HasHistogram() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Histogram != nil
}

func (x *Metric) ClearGauge() {
	x.xxx_hidden_Gauge = nil
}

func (x *Metric) ClearCounter() {
	x.xxx_hidden_Counter = nil
}

func (x *Metric) ClearSummary() {
	x.xxx_hidden_Summary = nil
}

func (x *Metric) ClearUntyped() {
	x.xxx_hidden_Untyped = nil
}

func (x *Metric) ClearHistogram() {
	x.xxx_hidden_Histogram = nil
}

type Metric_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Label       []*LabelPair
	Gauge       *Gauge
	Counter     *Counter
	Summary     *Summary
	Untyped     *Untyped
	Histogram   *Histogram
	TimestampMs int64
}

func (b0 Metric_builder) Build() *Metric {
	m0 := &Metric{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Label = &b.Label
	x.xxx_hidden_Gauge = b.Gauge
	x.xxx_hidden_Counter = b.Counter
	x.xxx_hidden_Summary = b.Summary
	x.xxx_hidden_Untyped = b.Untyped
	x.xxx_hidden_Histogram = b.Histogram
	x.xxx_hidden_TimestampMs = b.TimestampMs
	return m0
}

type MetricFamily struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name   string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Help   string                 `protobuf:"bytes,2,opt,name=help,proto3"`
	xxx_hidden_Type   MetricType             `protobuf:"varint,3,opt,name=type,proto3,enum=io.prometheus.client.MetricType"`
	xxx_hidden_Metric *[]*Metric             `protobuf:"bytes,4,rep,name=metric,proto3"`
	xxx_hidden_Unit   string                 `protobuf:"bytes,5,opt,name=unit,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *MetricFamily) Reset() {
	*x = MetricFamily{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricFamily) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricFamily) ProtoMessage() {}

func (x *MetricFamily) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MetricFamily) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *MetricFamily) GetHelp() string {
	if x != nil {
		return x.xxx_hidden_Help
	}
	return ""
}

func (x *MetricFamily) GetType() MetricType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return MetricType_COUNTER
}

func (x *MetricFamily) GetMetric() []*Metric {
	if x != nil {
		if x.xxx_hidden_Metric != nil {
			return *x.xxx_hidden_Metric
		}
	}
	return nil
}

func (x *MetricFamily) GetUnit() string {
	if x != nil {
		return x.xxx_hidden_Unit
	}
	return ""
}

func (x *MetricFamily) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *MetricFamily) SetHelp(v string) {
	x.xxx_hidden_Help = v
}

func (x *MetricFamily) SetType(v MetricType) {
	x.xxx_hidden_Type = v
}

func (x *MetricFamily) SetMetric(v []*Metric) {
	x.xxx_hidden_Metric = &v
}

func (x *MetricFamily) SetUnit(v string) {
	x.xxx_hidden_Unit = v
}

type MetricFamily_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name   string
	Help   string
	Type   MetricType
	Metric []*Metric
	Unit   string
}

func (b0 MetricFamily_builder) Build() *MetricFamily {
	m0 := &MetricFamily{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Help = b.Help
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Metric = &b.Metric
	x.xxx_hidden_Unit = b.Unit
	return m0
}

var File_io_prometheus_client_metrics_proto protoreflect.FileDescriptor

const file_io_prometheus_client_metrics_proto_rawDesc = "" +
	"\n" +
	"\"io/prometheus/client/metrics.proto\x12\x14io.prometheus.client\x1a\x14gogoproto/gogo.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"5\n" +
	"\tLabelPair\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"\x1d\n" +
	"\x05Gauge\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05value\"\xa4\x01\n" +
	"\aCounter\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05value\x12:\n" +
	"\bexemplar\x18\x02 \x01(\v2\x1e.io.prometheus.client.ExemplarR\bexemplar\x12G\n" +
	"\x11created_timestamp\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x10createdTimestamp\"<\n" +
	"\bQuantile\x12\x1a\n" +
	"\bquantile\x18\x01 \x01(\x01R\bquantile\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x01R\x05value\"\xd6\x01\n" +
	"\aSummary\x12!\n" +
	"\fsample_count\x18\x01 \x01(\x04R\vsampleCount\x12\x1d\n" +
	"\n" +
	"sample_sum\x18\x02 \x01(\x01R\tsampleSum\x12@\n" +
	"\bquantile\x18\x03 \x03(\v2\x1e.io.prometheus.client.QuantileB\x04\xc8\xde\x1f\x00R\bquantile\x12G\n" +
	"\x11created_timestamp\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x10createdTimestamp\"\x1f\n" +
	"\aUntyped\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05value\"\xfc\x05\n" +
	"\tHistogram\x12!\n" +
	"\fsample_count\x18\x01 \x01(\x04R\vsampleCount\x12,\n" +
	"\x12sample_count_float\x18\x04 \x01(\x01R\x10sampleCountFloat\x12\x1d\n" +
	"\n" +
	"sample_sum\x18\x02 \x01(\x01R\tsampleSum\x12:\n" +
	"\x06bucket\x18\x03 \x03(\v2\x1c.io.prometheus.client.BucketB\x04\xc8\xde\x1f\x00R\x06bucket\x12G\n" +
	"\x11created_timestamp\x18\x0f \x01(\v2\x1a.google.protobuf.TimestampR\x10createdTimestamp\x12\x16\n" +
	"\x06schema\x18\x05 \x01(\x11R\x06schema\x12%\n" +
	"\x0ezero_threshold\x18\x06 \x01(\x01R\rzeroThreshold\x12\x1d\n" +
	"\n" +
	"zero_count\x18\a \x01(\x04R\tzeroCount\x12(\n" +
	"\x10zero_count_float\x18\b \x01(\x01R\x0ezeroCountFloat\x12K\n" +
	"\rnegative_span\x18\t \x03(\v2 .io.prometheus.client.BucketSpanB\x04\xc8\xde\x1f\x00R\fnegativeSpan\x12%\n" +
	"\x0enegative_delta\x18\n" +
	" \x03(\x12R\rnegativeDelta\x12%\n" +
	"\x0enegative_count\x18\v \x03(\x01R\rnegativeCount\x12K\n" +
	"\rpositive_span\x18\f \x03(\v2 .io.prometheus.client.BucketSpanB\x04\xc8\xde\x1f\x00R\fpositiveSpan\x12%\n" +
	"\x0epositive_delta\x18\r \x03(\x12R\rpositiveDelta\x12%\n" +
	"\x0epositive_count\x18\x0e \x03(\x01R\rpositiveCount\x12<\n" +
	"\texemplars\x18\x10 \x03(\v2\x1e.io.prometheus.client.ExemplarR\texemplars\"\xc6\x01\n" +
	"\x06Bucket\x12)\n" +
	"\x10cumulative_count\x18\x01 \x01(\x04R\x0fcumulativeCount\x124\n" +
	"\x16cumulative_count_float\x18\x04 \x01(\x01R\x14cumulativeCountFloat\x12\x1f\n" +
	"\vupper_bound\x18\x02 \x01(\x01R\n" +
	"upperBound\x12:\n" +
	"\bexemplar\x18\x03 \x01(\v2\x1e.io.prometheus.client.ExemplarR\bexemplar\"<\n" +
	"\n" +
	"BucketSpan\x12\x16\n" +
	"\x06offset\x18\x01 \x01(\x11R\x06offset\x12\x16\n" +
	"\x06length\x18\x02 \x01(\rR\x06length\"\x97\x01\n" +
	"\bExemplar\x12;\n" +
	"\x05label\x18\x01 \x03(\v2\x1f.io.prometheus.client.LabelPairB\x04\xc8\xde\x1f\x00R\x05label\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x01R\x05value\x128\n" +
	"\ttimestamp\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\ttimestamp\"\x85\x03\n" +
	"\x06Metric\x12;\n" +
	"\x05label\x18\x01 \x03(\v2\x1f.io.prometheus.client.LabelPairB\x04\xc8\xde\x1f\x00R\x05label\x121\n" +
	"\x05gauge\x18\x02 \x01(\v2\x1b.io.prometheus.client.GaugeR\x05gauge\x127\n" +
	"\acounter\x18\x03 \x01(\v2\x1d.io.prometheus.client.CounterR\acounter\x127\n" +
	"\asummary\x18\x04 \x01(\v2\x1d.io.prometheus.client.SummaryR\asummary\x127\n" +
	"\auntyped\x18\x05 \x01(\v2\x1d.io.prometheus.client.UntypedR\auntyped\x12=\n" +
	"\thistogram\x18\a \x01(\v2\x1f.io.prometheus.client.HistogramR\thistogram\x12!\n" +
	"\ftimestamp_ms\x18\x06 \x01(\x03R\vtimestampMs\"\xbc\x01\n" +
	"\fMetricFamily\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04help\x18\x02 \x01(\tR\x04help\x124\n" +
	"\x04type\x18\x03 \x01(\x0e2 .io.prometheus.client.MetricTypeR\x04type\x12:\n" +
	"\x06metric\x18\x04 \x03(\v2\x1c.io.prometheus.client.MetricB\x04\xc8\xde\x1f\x00R\x06metric\x12\x12\n" +
	"\x04unit\x18\x05 \x01(\tR\x04unit*b\n" +
	"\n" +
	"MetricType\x12\v\n" +
	"\aCOUNTER\x10\x00\x12\t\n" +
	"\x05GAUGE\x10\x01\x12\v\n" +
	"\aSUMMARY\x10\x02\x12\v\n" +
	"\aUNTYPED\x10\x03\x12\r\n" +
	"\tHISTOGRAM\x10\x04\x12\x13\n" +
	"\x0fGAUGE_HISTOGRAM\x10\x05BPZNbuf.build/gen/go/prometheus/prometheus/protocolbuffers/go/io/prometheus/clientb\x06proto3"

var file_io_prometheus_client_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_io_prometheus_client_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_io_prometheus_client_metrics_proto_goTypes = []any{
	(MetricType)(0),               // 0: io.prometheus.client.MetricType
	(*LabelPair)(nil),             // 1: io.prometheus.client.LabelPair
	(*Gauge)(nil),                 // 2: io.prometheus.client.Gauge
	(*Counter)(nil),               // 3: io.prometheus.client.Counter
	(*Quantile)(nil),              // 4: io.prometheus.client.Quantile
	(*Summary)(nil),               // 5: io.prometheus.client.Summary
	(*Untyped)(nil),               // 6: io.prometheus.client.Untyped
	(*Histogram)(nil),             // 7: io.prometheus.client.Histogram
	(*Bucket)(nil),                // 8: io.prometheus.client.Bucket
	(*BucketSpan)(nil),            // 9: io.prometheus.client.BucketSpan
	(*Exemplar)(nil),              // 10: io.prometheus.client.Exemplar
	(*Metric)(nil),                // 11: io.prometheus.client.Metric
	(*MetricFamily)(nil),          // 12: io.prometheus.client.MetricFamily
	(*timestamppb.Timestamp)(nil), // 13: google.protobuf.Timestamp
}
var file_io_prometheus_client_metrics_proto_depIdxs = []int32{
	10, // 0: io.prometheus.client.Counter.exemplar:type_name -> io.prometheus.client.Exemplar
	13, // 1: io.prometheus.client.Counter.created_timestamp:type_name -> google.protobuf.Timestamp
	4,  // 2: io.prometheus.client.Summary.quantile:type_name -> io.prometheus.client.Quantile
	13, // 3: io.prometheus.client.Summary.created_timestamp:type_name -> google.protobuf.Timestamp
	8,  // 4: io.prometheus.client.Histogram.bucket:type_name -> io.prometheus.client.Bucket
	13, // 5: io.prometheus.client.Histogram.created_timestamp:type_name -> google.protobuf.Timestamp
	9,  // 6: io.prometheus.client.Histogram.negative_span:type_name -> io.prometheus.client.BucketSpan
	9,  // 7: io.prometheus.client.Histogram.positive_span:type_name -> io.prometheus.client.BucketSpan
	10, // 8: io.prometheus.client.Histogram.exemplars:type_name -> io.prometheus.client.Exemplar
	10, // 9: io.prometheus.client.Bucket.exemplar:type_name -> io.prometheus.client.Exemplar
	1,  // 10: io.prometheus.client.Exemplar.label:type_name -> io.prometheus.client.LabelPair
	13, // 11: io.prometheus.client.Exemplar.timestamp:type_name -> google.protobuf.Timestamp
	1,  // 12: io.prometheus.client.Metric.label:type_name -> io.prometheus.client.LabelPair
	2,  // 13: io.prometheus.client.Metric.gauge:type_name -> io.prometheus.client.Gauge
	3,  // 14: io.prometheus.client.Metric.counter:type_name -> io.prometheus.client.Counter
	5,  // 15: io.prometheus.client.Metric.summary:type_name -> io.prometheus.client.Summary
	6,  // 16: io.prometheus.client.Metric.untyped:type_name -> io.prometheus.client.Untyped
	7,  // 17: io.prometheus.client.Metric.histogram:type_name -> io.prometheus.client.Histogram
	0,  // 18: io.prometheus.client.MetricFamily.type:type_name -> io.prometheus.client.MetricType
	11, // 19: io.prometheus.client.MetricFamily.metric:type_name -> io.prometheus.client.Metric
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_io_prometheus_client_metrics_proto_init() }
func file_io_prometheus_client_metrics_proto_init() {
	if File_io_prometheus_client_metrics_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_io_prometheus_client_metrics_proto_rawDesc), len(file_io_prometheus_client_metrics_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_io_prometheus_client_metrics_proto_goTypes,
		DependencyIndexes: file_io_prometheus_client_metrics_proto_depIdxs,
		EnumInfos:         file_io_prometheus_client_metrics_proto_enumTypes,
		MessageInfos:      file_io_prometheus_client_metrics_proto_msgTypes,
	}.Build()
	File_io_prometheus_client_metrics_proto = out.File
	file_io_prometheus_client_metrics_proto_goTypes = nil
	file_io_prometheus_client_metrics_proto_depIdxs = nil
}
