// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists connection functions.
func (c *Client) ListConnectionFunctions(ctx context.Context, params *ListConnectionFunctionsInput, optFns ...func(*Options)) (*ListConnectionFunctionsOutput, error) {
	if params == nil {
		params = &ListConnectionFunctionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConnectionFunctions", params, optFns, c.addOperationListConnectionFunctionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConnectionFunctionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConnectionFunctionsInput struct {

	// Use this field when paginating results to indicate where to begin in your list.
	// The response includes items in the list that occur after the marker. To get the
	// next page of the list, set this field's value to the value of NextMarker from
	// the current page's response.
	Marker *string

	// The maximum number of connection functions that you want returned in the
	// response.
	MaxItems *int32

	// The connection function's stage.
	Stage types.FunctionStage

	noSmithyDocumentSerde
}

type ListConnectionFunctionsOutput struct {

	// A list of connection functions.
	ConnectionFunctions []types.ConnectionFunctionSummary

	// Indicates the next page of connection functions. To get the next page of the
	// list, use this value in the Marker field of your request.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConnectionFunctionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListConnectionFunctions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListConnectionFunctions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConnectionFunctions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConnectionFunctions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConnectionFunctionsPaginatorOptions is the paginator options for
// ListConnectionFunctions
type ListConnectionFunctionsPaginatorOptions struct {
	// The maximum number of connection functions that you want returned in the
	// response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConnectionFunctionsPaginator is a paginator for ListConnectionFunctions
type ListConnectionFunctionsPaginator struct {
	options   ListConnectionFunctionsPaginatorOptions
	client    ListConnectionFunctionsAPIClient
	params    *ListConnectionFunctionsInput
	nextToken *string
	firstPage bool
}

// NewListConnectionFunctionsPaginator returns a new
// ListConnectionFunctionsPaginator
func NewListConnectionFunctionsPaginator(client ListConnectionFunctionsAPIClient, params *ListConnectionFunctionsInput, optFns ...func(*ListConnectionFunctionsPaginatorOptions)) *ListConnectionFunctionsPaginator {
	if params == nil {
		params = &ListConnectionFunctionsInput{}
	}

	options := ListConnectionFunctionsPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConnectionFunctionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConnectionFunctionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConnectionFunctions page.
func (p *ListConnectionFunctionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConnectionFunctionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConnectionFunctions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConnectionFunctionsAPIClient is a client that implements the
// ListConnectionFunctions operation.
type ListConnectionFunctionsAPIClient interface {
	ListConnectionFunctions(context.Context, *ListConnectionFunctionsInput, ...func(*Options)) (*ListConnectionFunctionsOutput, error)
}

var _ ListConnectionFunctionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConnectionFunctions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConnectionFunctions",
	}
}
