# KubernetesNode


## Fields

| Field                                                                                           | Type                                                                                            | Required                                                                                        | Description                                                                                     |
| ----------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- |
| `Addresses`                                                                                     | [][components.KubernetesNodeNodeAddress](../../models/components/kubernetesnodenodeaddress.md)  | :heavy_minus_sign:                                                                              | N/A                                                                                             |
| `Architecture`                                                                                  | **string*                                                                                       | :heavy_minus_sign:                                                                              | The Architecture reported by the node.                                                          |
| `ContainerRuntimeVersion`                                                                       | **string*                                                                                       | :heavy_minus_sign:                                                                              | ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0). |
| `Images`                                                                                        | []*string*                                                                                      | :heavy_minus_sign:                                                                              | List of container images on this node                                                           |
| `KernelVersion`                                                                                 | **string*                                                                                       | :heavy_minus_sign:                                                                              | Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).                |
| `KubeProxyVersion`                                                                              | **string*                                                                                       | :heavy_minus_sign:                                                                              | KubeProxy Version reported by the node.                                                         |
| `KubeletVersion`                                                                                | **string*                                                                                       | :heavy_minus_sign:                                                                              | Kubelet Version reported by the node.                                                           |
| `Name`                                                                                          | **string*                                                                                       | :heavy_minus_sign:                                                                              | N/A                                                                                             |
| `OperatingSystem`                                                                               | **string*                                                                                       | :heavy_minus_sign:                                                                              | The Operating System reported by the node.                                                      |
| `OsImage`                                                                                       | **string*                                                                                       | :heavy_minus_sign:                                                                              | OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).          |