// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type ParseStatus string

const (
	ParseStatusUnknown   ParseStatus = ""
	ParseStatusSuccess   ParseStatus = "success"
	ParseStatusFail      ParseStatus = "fail"
	ParseStatusCorrupted ParseStatus = "corrupted"
)

func (e ParseStatus) ToPointer() *ParseStatus {
	return &e
}
func (e *ParseStatus) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "success":
		fallthrough
	case "fail":
		fallthrough
	case "corrupted":
		*e = ParseStatus(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ParseStatus: %v", v)
	}
}

// ValidationLevel - The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV).
type ValidationLevel string

const (
	ValidationLevelUnknown ValidationLevel = ""
	ValidationLevelDv      ValidationLevel = "dv"
	ValidationLevelOv      ValidationLevel = "ov"
	ValidationLevelEv      ValidationLevel = "ev"
)

func (e ValidationLevel) ToPointer() *ValidationLevel {
	return &e
}
func (e *ValidationLevel) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "dv":
		fallthrough
	case "ov":
		fallthrough
	case "ev":
		*e = ValidationLevel(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ValidationLevel: %v", v)
	}
}

type Certificate struct {
	// When the certificate was added to the Censys dataset.
	AddedAt *string `json:"added_at,omitempty"`
	Ct      *Ct     `json:"ct,omitempty"`
	// Whether the certificate has ever been presented by a service during a scan.
	EverSeenInScan *bool `json:"ever_seen_in_scan,omitempty"`
	// The MD-5 digest of the entire raw certificate. An identifier used by some systems.
	FingerprintMd5 *string `json:"fingerprint_md5,omitempty"`
	// The SHA-1 digest of the entire raw certificate. An identifier used by some systems.
	FingerprintSha1 *string `json:"fingerprint_sha1,omitempty"`
	// The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records.
	FingerprintSha256 *string `json:"fingerprint_sha256,omitempty"`
	// When the certificate record was last modified.
	ModifiedAt *string `json:"modified_at,omitempty"`
	// All the names contained in the certificate from various fields.
	Names []string `json:"names,omitempty"`
	// DEPRECATED: Use parent_spki_subject_fingerprint_sha256
	ParentSpkiFingerprintSha256 *string `json:"parent_spki_fingerprint_sha256,omitempty"`
	// The SHA-256 digest of the parent certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject.
	ParentSpkiSubjectFingerprintSha256 *string            `json:"parent_spki_subject_fingerprint_sha256,omitempty"`
	ParseStatus                        *ParseStatus       `json:"parse_status,omitempty"`
	Parsed                             *CertificateParsed `json:"parsed,omitempty"`
	// Whether the X.509 "poison" extension (OID: 1.3.6.1.4.1.11129.2.4.3) is marked critical, which prohibits the pre-certificate from being trusted.
	Precert    *bool                  `json:"precert,omitempty"`
	Revocation *CertificateRevocation `json:"revocation,omitempty"`
	// Whether the certificate has been revoked before its expiry date by the issuer.
	Revoked *bool `json:"revoked,omitempty"`
	// DEPRECATED: Use spki_subject_fingerprint_sha256
	SpkiFingerprintSha256 *string `json:"spki_fingerprint_sha256,omitempty"`
	// The SHA-256 digest of the certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject.
	SpkiSubjectFingerprintSha256 *string `json:"spki_subject_fingerprint_sha256,omitempty"`
	// The SHA-256 digest of the unsigned certificate's contents.
	TbsFingerprintSha256 *string `json:"tbs_fingerprint_sha256,omitempty"`
	// The SHA-256 digest of the unsigned certificate with the CT Poison extension removed, if present. This represents the shared contents of a certificate and its corresponding pre-certificate.
	TbsNoCtFingerprintSha256 *string `json:"tbs_no_ct_fingerprint_sha256,omitempty"`
	// When the certificate record's trust was last checked.
	ValidatedAt *string     `json:"validated_at,omitempty"`
	Validation  *Validation `json:"validation,omitempty"`
	// The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV).
	ValidationLevel *ValidationLevel `json:"validation_level,omitempty"`
	Zlint           *ZLint           `json:"zlint,omitempty"`
}

func (o *Certificate) GetAddedAt() *string {
	if o == nil {
		return nil
	}
	return o.AddedAt
}

func (o *Certificate) GetCt() *Ct {
	if o == nil {
		return nil
	}
	return o.Ct
}

func (o *Certificate) GetEverSeenInScan() *bool {
	if o == nil {
		return nil
	}
	return o.EverSeenInScan
}

func (o *Certificate) GetFingerprintMd5() *string {
	if o == nil {
		return nil
	}
	return o.FingerprintMd5
}

func (o *Certificate) GetFingerprintSha1() *string {
	if o == nil {
		return nil
	}
	return o.FingerprintSha1
}

func (o *Certificate) GetFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.FingerprintSha256
}

func (o *Certificate) GetModifiedAt() *string {
	if o == nil {
		return nil
	}
	return o.ModifiedAt
}

func (o *Certificate) GetNames() []string {
	if o == nil {
		return nil
	}
	return o.Names
}

func (o *Certificate) GetParentSpkiFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.ParentSpkiFingerprintSha256
}

func (o *Certificate) GetParentSpkiSubjectFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.ParentSpkiSubjectFingerprintSha256
}

func (o *Certificate) GetParseStatus() *ParseStatus {
	if o == nil {
		return nil
	}
	return o.ParseStatus
}

func (o *Certificate) GetParsed() *CertificateParsed {
	if o == nil {
		return nil
	}
	return o.Parsed
}

func (o *Certificate) GetPrecert() *bool {
	if o == nil {
		return nil
	}
	return o.Precert
}

func (o *Certificate) GetRevocation() *CertificateRevocation {
	if o == nil {
		return nil
	}
	return o.Revocation
}

func (o *Certificate) GetRevoked() *bool {
	if o == nil {
		return nil
	}
	return o.Revoked
}

func (o *Certificate) GetSpkiFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.SpkiFingerprintSha256
}

func (o *Certificate) GetSpkiSubjectFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.SpkiSubjectFingerprintSha256
}

func (o *Certificate) GetTbsFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.TbsFingerprintSha256
}

func (o *Certificate) GetTbsNoCtFingerprintSha256() *string {
	if o == nil {
		return nil
	}
	return o.TbsNoCtFingerprintSha256
}

func (o *Certificate) GetValidatedAt() *string {
	if o == nil {
		return nil
	}
	return o.ValidatedAt
}

func (o *Certificate) GetValidation() *Validation {
	if o == nil {
		return nil
	}
	return o.Validation
}

func (o *Certificate) GetValidationLevel() *ValidationLevel {
	if o == nil {
		return nil
	}
	return o.ValidationLevel
}

func (o *Certificate) GetZlint() *ZLint {
	if o == nil {
		return nil
	}
	return o.Zlint
}
