// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// RCode - A enumerated field indicating the result of the request. The most common values are defined in RFC 1035.
type RCode string

const (
	RCodeUnknown        RCode = ""
	RCodeSuccess        RCode = "success"
	RCodeFormatError    RCode = "format_error"
	RCodeServerFailure  RCode = "server_failure"
	RCodeNameError      RCode = "name_error"
	RCodeNotImplemented RCode = "not_implemented"
	RCodeRefused        RCode = "refused"
	RCodeYxDomain       RCode = "yx_domain"
	RCodeYxRrset        RCode = "yx_rrset"
	RCodeNxRrset        RCode = "nx_rrset"
	RCodeNotAuth        RCode = "not_auth"
	RCodeNotZone        RCode = "not_zone"
	RCodeBadSig         RCode = "bad_sig"
	RCodeBadKey         RCode = "bad_key"
	RCodeBadTime        RCode = "bad_time"
	RCodeBadMode        RCode = "bad_mode"
	RCodeBadName        RCode = "bad_name"
	RCodeBadAlg         RCode = "bad_alg"
	RCodeBadTrunc       RCode = "bad_trunc"
	RCodeBadCookie      RCode = "bad_cookie"
)

func (e RCode) ToPointer() *RCode {
	return &e
}
func (e *RCode) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "success":
		fallthrough
	case "format_error":
		fallthrough
	case "server_failure":
		fallthrough
	case "name_error":
		fallthrough
	case "not_implemented":
		fallthrough
	case "refused":
		fallthrough
	case "yx_domain":
		fallthrough
	case "yx_rrset":
		fallthrough
	case "nx_rrset":
		fallthrough
	case "not_auth":
		fallthrough
	case "not_zone":
		fallthrough
	case "bad_sig":
		fallthrough
	case "bad_key":
		fallthrough
	case "bad_time":
		fallthrough
	case "bad_mode":
		fallthrough
	case "bad_name":
		fallthrough
	case "bad_alg":
		fallthrough
	case "bad_trunc":
		fallthrough
	case "bad_cookie":
		*e = RCode(v)
		return nil
	default:
		return fmt.Errorf("invalid value for RCode: %v", v)
	}
}

// ServerType - An enumerated value indicating the behavior of the server. An AUTHORITATIVE server fulfills requests for domain names it controls, which are not listed by the server. FORWARDING and RECURSIVE_RESOLVER servers fulfill requests indirectly for domain names they do not control. A RECURSIVE_RESOLVER will query ip.parrotdns.com itself, resulting in its own IP address being present in the dns.answers.response field.
type ServerType string

const (
	ServerTypeUnknown           ServerType = ""
	ServerTypeRecursiveResolver ServerType = "recursive_resolver"
	ServerTypeAuthoritative     ServerType = "authoritative"
	ServerTypeForwarding        ServerType = "forwarding"
	ServerTypeRedirecting       ServerType = "redirecting"
)

func (e ServerType) ToPointer() *ServerType {
	return &e
}
func (e *ServerType) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "recursive_resolver":
		fallthrough
	case "authoritative":
		fallthrough
	case "forwarding":
		fallthrough
	case "redirecting":
		*e = ServerType(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ServerType: %v", v)
	}
}

type DNS struct {
	// A list of resource records (RRs) contained in the ADDITIONAL section of the response.
	Additionals []DNSResourceRecord `json:"additionals,omitempty"`
	// A list of resource records (RRs) contained in the ANSWER section of the response.
	Answers []DNSResourceRecord `json:"answers,omitempty"`
	// A list of resource records (RRs) contained in the AUTHORITIES section of the response.
	Authorities []DNSResourceRecord `json:"authorities,omitempty"`
	Edns        *DNSEDNS            `json:"edns,omitempty"`
	// A list of resource records (RRs) contained in the QUESTION section of the response, which may echo the request that the server is responding to.
	Questions []DNSResourceRecord `json:"questions,omitempty"`
	// A enumerated field indicating the result of the request. The most common values are defined in RFC 1035.
	RCode *RCode `json:"r_code,omitempty"`
	// Whether the server returns an IP address for ip.parrotdns.com that matches the authoritative server, which is controlled by Censys.
	ResolvesCorrectly *bool `json:"resolves_correctly,omitempty"`
	// An enumerated value indicating the behavior of the server. An AUTHORITATIVE server fulfills requests for domain names it controls, which are not listed by the server. FORWARDING and RECURSIVE_RESOLVER servers fulfill requests indirectly for domain names they do not control. A RECURSIVE_RESOLVER will query ip.parrotdns.com itself, resulting in its own IP address being present in the dns.answers.response field.
	ServerType *ServerType `json:"server_type,omitempty"`
	Version    *string     `json:"version,omitempty"`
}

func (o *DNS) GetAdditionals() []DNSResourceRecord {
	if o == nil {
		return nil
	}
	return o.Additionals
}

func (o *DNS) GetAnswers() []DNSResourceRecord {
	if o == nil {
		return nil
	}
	return o.Answers
}

func (o *DNS) GetAuthorities() []DNSResourceRecord {
	if o == nil {
		return nil
	}
	return o.Authorities
}

func (o *DNS) GetEdns() *DNSEDNS {
	if o == nil {
		return nil
	}
	return o.Edns
}

func (o *DNS) GetQuestions() []DNSResourceRecord {
	if o == nil {
		return nil
	}
	return o.Questions
}

func (o *DNS) GetRCode() *RCode {
	if o == nil {
		return nil
	}
	return o.RCode
}

func (o *DNS) GetResolvesCorrectly() *bool {
	if o == nil {
		return nil
	}
	return o.ResolvesCorrectly
}

func (o *DNS) GetServerType() *ServerType {
	if o == nil {
		return nil
	}
	return o.ServerType
}

func (o *DNS) GetVersion() *string {
	if o == nil {
		return nil
	}
	return o.Version
}
