// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// DNSResourceRecordType - An enumerated field indicating what type of data is in the "services.dns.additionals.response" field. For example, "A" signifies that the value in "services.dns.additionals.response" is an IPv4 address for the FQDN in "services.dns.additionals.name".
type DNSResourceRecordType string

const (
	DNSResourceRecordTypeUnknown DNSResourceRecordType = ""
	DNSResourceRecordTypeA       DNSResourceRecordType = "a"
	DNSResourceRecordTypeTxt     DNSResourceRecordType = "txt"
	DNSResourceRecordTypeNs      DNSResourceRecordType = "ns"
)

func (e DNSResourceRecordType) ToPointer() *DNSResourceRecordType {
	return &e
}
func (e *DNSResourceRecordType) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "a":
		fallthrough
	case "txt":
		fallthrough
	case "ns":
		*e = DNSResourceRecordType(v)
		return nil
	default:
		return fmt.Errorf("invalid value for DNSResourceRecordType: %v", v)
	}
}

type DNSResourceRecord struct {
	// The Fully Qualified Domain Name (FQDN) this RR is for.
	Name *string `json:"name,omitempty"`
	// The RDATA field of the RR.
	Response *string `json:"response,omitempty"`
	// An enumerated field indicating what type of data is in the "services.dns.additionals.response" field. For example, "A" signifies that the value in "services.dns.additionals.response" is an IPv4 address for the FQDN in "services.dns.additionals.name".
	Type *DNSResourceRecordType `json:"type,omitempty"`
}

func (o *DNSResourceRecord) GetName() *string {
	if o == nil {
		return nil
	}
	return o.Name
}

func (o *DNSResourceRecord) GetResponse() *string {
	if o == nil {
		return nil
	}
	return o.Response
}

func (o *DNSResourceRecord) GetType() *DNSResourceRecordType {
	if o == nil {
		return nil
	}
	return o.Type
}
