// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Speech API
//
// The OCI Speech Service harnesses the power of spoken language by allowing developers to easily convert file-based data containing human speech into highly accurate text transcriptions.
//

package aispeech

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// TranscriptionNormalization Information to Normalize generated transcript.
type TranscriptionNormalization struct {

	// Whether to add punctuation in the generated transcription. Enabled by default.
	IsPunctuationEnabled *bool `mandatory:"false" json:"isPunctuationEnabled"`

	// List of filters.
	Filters []TranscriptionFilter `mandatory:"false" json:"filters"`
}

func (m TranscriptionNormalization) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m TranscriptionNormalization) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *TranscriptionNormalization) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		IsPunctuationEnabled *bool                 `json:"isPunctuationEnabled"`
		Filters              []transcriptionfilter `json:"filters"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.IsPunctuationEnabled = model.IsPunctuationEnabled

	m.Filters = make([]TranscriptionFilter, len(model.Filters))
	for i, n := range model.Filters {
		nn, e = n.UnmarshalPolymorphicJSON(n.JsonData)
		if e != nil {
			return e
		}
		if nn != nil {
			m.Filters[i] = nn.(TranscriptionFilter)
		} else {
			m.Filters[i] = nil
		}
	}
	return
}
