// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityAudit A vulnerability audit associates the application dependencies of a project with their associated Vulnerabilities.
// Each Vulnerability is associated with a score (Common Vulnerability Scoring System V2 or V3).
// A vulnerable application dependency can be ignored based on the configuration of the vulnerability audit.
// maxObservedCvssV2Score, maxObservedCvssV3Score and vulnerableArtifactsCount do not take into account non-vulnerable application dependency.
type VulnerabilityAudit struct {

	// The Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
	Id *string `mandatory:"true" json:"id"`

	// The Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
	KnowledgeBaseId *string `mandatory:"true" json:"knowledgeBaseId"`

	// The creation date and time of the vulnerability audit (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// The update date and time of the vulnerability audit (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	TimeUpdated *common.SDKTime `mandatory:"true" json:"timeUpdated"`

	// The current lifecycle state of the vulnerability audit.
	LifecycleState VulnerabilityAuditLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
	Vulnerabilities []Vulnerability `mandatory:"true" json:"vulnerabilities"`

	// Count of all vulnerable application dependencies.
	VulnerableArtifactsCountWithIgnored *int `mandatory:"true" json:"vulnerableArtifactsCountWithIgnored"`

	// Count of non-ignored vulnerable application dependencies.
	VulnerableArtifactsCount *int `mandatory:"true" json:"vulnerableArtifactsCount"`

	// The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
	BuildType VulnerabilityAuditBuildTypeEnum `mandatory:"true" json:"buildType"`

	Source VulnerabilityAuditSource `mandatory:"true" json:"source"`

	// The compartment Oracle Cloud identifier (OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The name of the vulnerability audit.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Details on the lifecycle state.
	LifecycleDetails VulnerabilityAuditLifecycleDetailsEnum `mandatory:"false" json:"lifecycleDetails,omitempty"`

	// Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
	MaxObservedCvssV2Score *float32 `mandatory:"false" json:"maxObservedCvssV2Score"`

	// Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
	MaxObservedCvssV3Score *float32 `mandatory:"false" json:"maxObservedCvssV3Score"`

	// Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
	MaxObservedSeverity VulnerabilitySeverityEnum `mandatory:"false" json:"maxObservedSeverity,omitempty"`

	// Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
	MaxObservedCvssV2ScoreWithIgnored *float32 `mandatory:"false" json:"maxObservedCvssV2ScoreWithIgnored"`

	// Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
	MaxObservedCvssV3ScoreWithIgnored *float32 `mandatory:"false" json:"maxObservedCvssV3ScoreWithIgnored"`

	// Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
	MaxObservedSeverityWithIgnored VulnerabilitySeverityEnum `mandatory:"false" json:"maxObservedSeverityWithIgnored,omitempty"`

	Configuration *VulnerabilityAuditConfiguration `mandatory:"false" json:"configuration"`

	UsageData UsageDataDetails `mandatory:"false" json:"usageData"`

	// Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
	IsSuccess *bool `mandatory:"false" json:"isSuccess"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Usage of system tag keys. These predefined keys are scoped to namespaces.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m VulnerabilityAudit) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityAudit) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVulnerabilityAuditLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetVulnerabilityAuditLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilityAuditBuildTypeEnum(string(m.BuildType)); !ok && m.BuildType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for BuildType: %s. Supported values are: %s.", m.BuildType, strings.Join(GetVulnerabilityAuditBuildTypeEnumStringValues(), ",")))
	}

	if _, ok := GetMappingVulnerabilityAuditLifecycleDetailsEnum(string(m.LifecycleDetails)); !ok && m.LifecycleDetails != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleDetails: %s. Supported values are: %s.", m.LifecycleDetails, strings.Join(GetVulnerabilityAuditLifecycleDetailsEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilitySeverityEnum(string(m.MaxObservedSeverity)); !ok && m.MaxObservedSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxObservedSeverity: %s. Supported values are: %s.", m.MaxObservedSeverity, strings.Join(GetVulnerabilitySeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilitySeverityEnum(string(m.MaxObservedSeverityWithIgnored)); !ok && m.MaxObservedSeverityWithIgnored != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxObservedSeverityWithIgnored: %s. Supported values are: %s.", m.MaxObservedSeverityWithIgnored, strings.Join(GetVulnerabilitySeverityEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *VulnerabilityAudit) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		DisplayName                         *string                                `json:"displayName"`
		LifecycleDetails                    VulnerabilityAuditLifecycleDetailsEnum `json:"lifecycleDetails"`
		MaxObservedCvssV2Score              *float32                               `json:"maxObservedCvssV2Score"`
		MaxObservedCvssV3Score              *float32                               `json:"maxObservedCvssV3Score"`
		MaxObservedSeverity                 VulnerabilitySeverityEnum              `json:"maxObservedSeverity"`
		MaxObservedCvssV2ScoreWithIgnored   *float32                               `json:"maxObservedCvssV2ScoreWithIgnored"`
		MaxObservedCvssV3ScoreWithIgnored   *float32                               `json:"maxObservedCvssV3ScoreWithIgnored"`
		MaxObservedSeverityWithIgnored      VulnerabilitySeverityEnum              `json:"maxObservedSeverityWithIgnored"`
		Configuration                       *VulnerabilityAuditConfiguration       `json:"configuration"`
		UsageData                           usagedatadetails                       `json:"usageData"`
		IsSuccess                           *bool                                  `json:"isSuccess"`
		FreeformTags                        map[string]string                      `json:"freeformTags"`
		DefinedTags                         map[string]map[string]interface{}      `json:"definedTags"`
		SystemTags                          map[string]map[string]interface{}      `json:"systemTags"`
		Id                                  *string                                `json:"id"`
		KnowledgeBaseId                     *string                                `json:"knowledgeBaseId"`
		TimeCreated                         *common.SDKTime                        `json:"timeCreated"`
		TimeUpdated                         *common.SDKTime                        `json:"timeUpdated"`
		LifecycleState                      VulnerabilityAuditLifecycleStateEnum   `json:"lifecycleState"`
		Vulnerabilities                     []Vulnerability                        `json:"vulnerabilities"`
		VulnerableArtifactsCountWithIgnored *int                                   `json:"vulnerableArtifactsCountWithIgnored"`
		VulnerableArtifactsCount            *int                                   `json:"vulnerableArtifactsCount"`
		BuildType                           VulnerabilityAuditBuildTypeEnum        `json:"buildType"`
		Source                              vulnerabilityauditsource               `json:"source"`
		CompartmentId                       *string                                `json:"compartmentId"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.DisplayName = model.DisplayName

	m.LifecycleDetails = model.LifecycleDetails

	m.MaxObservedCvssV2Score = model.MaxObservedCvssV2Score

	m.MaxObservedCvssV3Score = model.MaxObservedCvssV3Score

	m.MaxObservedSeverity = model.MaxObservedSeverity

	m.MaxObservedCvssV2ScoreWithIgnored = model.MaxObservedCvssV2ScoreWithIgnored

	m.MaxObservedCvssV3ScoreWithIgnored = model.MaxObservedCvssV3ScoreWithIgnored

	m.MaxObservedSeverityWithIgnored = model.MaxObservedSeverityWithIgnored

	m.Configuration = model.Configuration

	nn, e = model.UsageData.UnmarshalPolymorphicJSON(model.UsageData.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.UsageData = nn.(UsageDataDetails)
	} else {
		m.UsageData = nil
	}

	m.IsSuccess = model.IsSuccess

	m.FreeformTags = model.FreeformTags

	m.DefinedTags = model.DefinedTags

	m.SystemTags = model.SystemTags

	m.Id = model.Id

	m.KnowledgeBaseId = model.KnowledgeBaseId

	m.TimeCreated = model.TimeCreated

	m.TimeUpdated = model.TimeUpdated

	m.LifecycleState = model.LifecycleState

	m.Vulnerabilities = make([]Vulnerability, len(model.Vulnerabilities))
	copy(m.Vulnerabilities, model.Vulnerabilities)
	m.VulnerableArtifactsCountWithIgnored = model.VulnerableArtifactsCountWithIgnored

	m.VulnerableArtifactsCount = model.VulnerableArtifactsCount

	m.BuildType = model.BuildType

	nn, e = model.Source.UnmarshalPolymorphicJSON(model.Source.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.Source = nn.(VulnerabilityAuditSource)
	} else {
		m.Source = nil
	}

	m.CompartmentId = model.CompartmentId

	return
}

// VulnerabilityAuditLifecycleStateEnum Enum with underlying type: string
type VulnerabilityAuditLifecycleStateEnum string

// Set of constants representing the allowable values for VulnerabilityAuditLifecycleStateEnum
const (
	VulnerabilityAuditLifecycleStateActive   VulnerabilityAuditLifecycleStateEnum = "ACTIVE"
	VulnerabilityAuditLifecycleStateCreating VulnerabilityAuditLifecycleStateEnum = "CREATING"
	VulnerabilityAuditLifecycleStateDeleted  VulnerabilityAuditLifecycleStateEnum = "DELETED"
	VulnerabilityAuditLifecycleStateDeleting VulnerabilityAuditLifecycleStateEnum = "DELETING"
	VulnerabilityAuditLifecycleStateFailed   VulnerabilityAuditLifecycleStateEnum = "FAILED"
)

var mappingVulnerabilityAuditLifecycleStateEnum = map[string]VulnerabilityAuditLifecycleStateEnum{
	"ACTIVE":   VulnerabilityAuditLifecycleStateActive,
	"CREATING": VulnerabilityAuditLifecycleStateCreating,
	"DELETED":  VulnerabilityAuditLifecycleStateDeleted,
	"DELETING": VulnerabilityAuditLifecycleStateDeleting,
	"FAILED":   VulnerabilityAuditLifecycleStateFailed,
}

var mappingVulnerabilityAuditLifecycleStateEnumLowerCase = map[string]VulnerabilityAuditLifecycleStateEnum{
	"active":   VulnerabilityAuditLifecycleStateActive,
	"creating": VulnerabilityAuditLifecycleStateCreating,
	"deleted":  VulnerabilityAuditLifecycleStateDeleted,
	"deleting": VulnerabilityAuditLifecycleStateDeleting,
	"failed":   VulnerabilityAuditLifecycleStateFailed,
}

// GetVulnerabilityAuditLifecycleStateEnumValues Enumerates the set of values for VulnerabilityAuditLifecycleStateEnum
func GetVulnerabilityAuditLifecycleStateEnumValues() []VulnerabilityAuditLifecycleStateEnum {
	values := make([]VulnerabilityAuditLifecycleStateEnum, 0)
	for _, v := range mappingVulnerabilityAuditLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityAuditLifecycleStateEnumStringValues Enumerates the set of values in String for VulnerabilityAuditLifecycleStateEnum
func GetVulnerabilityAuditLifecycleStateEnumStringValues() []string {
	return []string{
		"ACTIVE",
		"CREATING",
		"DELETED",
		"DELETING",
		"FAILED",
	}
}

// GetMappingVulnerabilityAuditLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityAuditLifecycleStateEnum(val string) (VulnerabilityAuditLifecycleStateEnum, bool) {
	enum, ok := mappingVulnerabilityAuditLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// VulnerabilityAuditLifecycleDetailsEnum Enum with underlying type: string
type VulnerabilityAuditLifecycleDetailsEnum string

// Set of constants representing the allowable values for VulnerabilityAuditLifecycleDetailsEnum
const (
	VulnerabilityAuditLifecycleDetailsNotFoundOrNotAuthorized       VulnerabilityAuditLifecycleDetailsEnum = "USAGE_DATA_NOT_FOUND_OR_NOT_AUTHORIZED"
	VulnerabilityAuditLifecycleDetailsParseFailed                   VulnerabilityAuditLifecycleDetailsEnum = "USAGE_DATA_PARSE_FAILED"
	VulnerabilityAuditLifecycleDetailsCompressedSizeLimitExceeded   VulnerabilityAuditLifecycleDetailsEnum = "USAGE_DATA_COMPRESSED_SIZE_LIMIT_EXCEEDED"
	VulnerabilityAuditLifecycleDetailsUncompressedSizeLimitExceeded VulnerabilityAuditLifecycleDetailsEnum = "USAGE_DATA_UNCOMPRESSED_SIZE_LIMIT_EXCEEDED"
	VulnerabilityAuditLifecycleDetailsUnknownError                  VulnerabilityAuditLifecycleDetailsEnum = "USAGE_DATA_UNKNOWN_ERROR"
)

var mappingVulnerabilityAuditLifecycleDetailsEnum = map[string]VulnerabilityAuditLifecycleDetailsEnum{
	"USAGE_DATA_NOT_FOUND_OR_NOT_AUTHORIZED":      VulnerabilityAuditLifecycleDetailsNotFoundOrNotAuthorized,
	"USAGE_DATA_PARSE_FAILED":                     VulnerabilityAuditLifecycleDetailsParseFailed,
	"USAGE_DATA_COMPRESSED_SIZE_LIMIT_EXCEEDED":   VulnerabilityAuditLifecycleDetailsCompressedSizeLimitExceeded,
	"USAGE_DATA_UNCOMPRESSED_SIZE_LIMIT_EXCEEDED": VulnerabilityAuditLifecycleDetailsUncompressedSizeLimitExceeded,
	"USAGE_DATA_UNKNOWN_ERROR":                    VulnerabilityAuditLifecycleDetailsUnknownError,
}

var mappingVulnerabilityAuditLifecycleDetailsEnumLowerCase = map[string]VulnerabilityAuditLifecycleDetailsEnum{
	"usage_data_not_found_or_not_authorized":      VulnerabilityAuditLifecycleDetailsNotFoundOrNotAuthorized,
	"usage_data_parse_failed":                     VulnerabilityAuditLifecycleDetailsParseFailed,
	"usage_data_compressed_size_limit_exceeded":   VulnerabilityAuditLifecycleDetailsCompressedSizeLimitExceeded,
	"usage_data_uncompressed_size_limit_exceeded": VulnerabilityAuditLifecycleDetailsUncompressedSizeLimitExceeded,
	"usage_data_unknown_error":                    VulnerabilityAuditLifecycleDetailsUnknownError,
}

// GetVulnerabilityAuditLifecycleDetailsEnumValues Enumerates the set of values for VulnerabilityAuditLifecycleDetailsEnum
func GetVulnerabilityAuditLifecycleDetailsEnumValues() []VulnerabilityAuditLifecycleDetailsEnum {
	values := make([]VulnerabilityAuditLifecycleDetailsEnum, 0)
	for _, v := range mappingVulnerabilityAuditLifecycleDetailsEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityAuditLifecycleDetailsEnumStringValues Enumerates the set of values in String for VulnerabilityAuditLifecycleDetailsEnum
func GetVulnerabilityAuditLifecycleDetailsEnumStringValues() []string {
	return []string{
		"USAGE_DATA_NOT_FOUND_OR_NOT_AUTHORIZED",
		"USAGE_DATA_PARSE_FAILED",
		"USAGE_DATA_COMPRESSED_SIZE_LIMIT_EXCEEDED",
		"USAGE_DATA_UNCOMPRESSED_SIZE_LIMIT_EXCEEDED",
		"USAGE_DATA_UNKNOWN_ERROR",
	}
}

// GetMappingVulnerabilityAuditLifecycleDetailsEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityAuditLifecycleDetailsEnum(val string) (VulnerabilityAuditLifecycleDetailsEnum, bool) {
	enum, ok := mappingVulnerabilityAuditLifecycleDetailsEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// VulnerabilityAuditBuildTypeEnum Enum with underlying type: string
type VulnerabilityAuditBuildTypeEnum string

// Set of constants representing the allowable values for VulnerabilityAuditBuildTypeEnum
const (
	VulnerabilityAuditBuildTypeMaven VulnerabilityAuditBuildTypeEnum = "MAVEN"
	VulnerabilityAuditBuildTypeUnset VulnerabilityAuditBuildTypeEnum = "UNSET"
)

var mappingVulnerabilityAuditBuildTypeEnum = map[string]VulnerabilityAuditBuildTypeEnum{
	"MAVEN": VulnerabilityAuditBuildTypeMaven,
	"UNSET": VulnerabilityAuditBuildTypeUnset,
}

var mappingVulnerabilityAuditBuildTypeEnumLowerCase = map[string]VulnerabilityAuditBuildTypeEnum{
	"maven": VulnerabilityAuditBuildTypeMaven,
	"unset": VulnerabilityAuditBuildTypeUnset,
}

// GetVulnerabilityAuditBuildTypeEnumValues Enumerates the set of values for VulnerabilityAuditBuildTypeEnum
func GetVulnerabilityAuditBuildTypeEnumValues() []VulnerabilityAuditBuildTypeEnum {
	values := make([]VulnerabilityAuditBuildTypeEnum, 0)
	for _, v := range mappingVulnerabilityAuditBuildTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityAuditBuildTypeEnumStringValues Enumerates the set of values in String for VulnerabilityAuditBuildTypeEnum
func GetVulnerabilityAuditBuildTypeEnumStringValues() []string {
	return []string{
		"MAVEN",
		"UNSET",
	}
}

// GetMappingVulnerabilityAuditBuildTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityAuditBuildTypeEnum(val string) (VulnerabilityAuditBuildTypeEnum, bool) {
	enum, ok := mappingVulnerabilityAuditBuildTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
