// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package keymanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHsmClustersRequest wrapper for the ListHsmClusters operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/keymanagement/ListHsmClusters.go.html to see an example of how to use ListHsmClustersRequest.
type ListHsmClustersRequest struct {

	// The OCID of the compartment.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return in a paginated "List" call.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the `opc-next-page` response header
	// from the previous "List" call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// Unique identifier for the request. If provided, the returned request ID
	// will include this value. Otherwise, a random request ID will be
	// generated by the service.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The field to sort by. You can specify only one sort order. The default
	// order for `TIMECREATED` is descending. The default order for `DISPLAYNAME`
	// is ascending.
	SortBy ListHsmClustersSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`).
	SortOrder ListHsmClustersSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHsmClustersRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHsmClustersRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHsmClustersRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHsmClustersRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHsmClustersRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHsmClustersSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHsmClustersSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHsmClustersSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHsmClustersSortOrderEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHsmClustersResponse wrapper for the ListHsmClusters operation
type ListHsmClustersResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HsmClusterCollection instances
	HsmClusterCollection `presentIn:"body"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then there are additional items still to get. Include this value as the `page` parameter for the
	// subsequent GET request. For information about pagination, see
	// List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about
	// a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListHsmClustersResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHsmClustersResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHsmClustersSortByEnum Enum with underlying type: string
type ListHsmClustersSortByEnum string

// Set of constants representing the allowable values for ListHsmClustersSortByEnum
const (
	ListHsmClustersSortByTimecreated ListHsmClustersSortByEnum = "TIMECREATED"
	ListHsmClustersSortByDisplayname ListHsmClustersSortByEnum = "DISPLAYNAME"
)

var mappingListHsmClustersSortByEnum = map[string]ListHsmClustersSortByEnum{
	"TIMECREATED": ListHsmClustersSortByTimecreated,
	"DISPLAYNAME": ListHsmClustersSortByDisplayname,
}

var mappingListHsmClustersSortByEnumLowerCase = map[string]ListHsmClustersSortByEnum{
	"timecreated": ListHsmClustersSortByTimecreated,
	"displayname": ListHsmClustersSortByDisplayname,
}

// GetListHsmClustersSortByEnumValues Enumerates the set of values for ListHsmClustersSortByEnum
func GetListHsmClustersSortByEnumValues() []ListHsmClustersSortByEnum {
	values := make([]ListHsmClustersSortByEnum, 0)
	for _, v := range mappingListHsmClustersSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHsmClustersSortByEnumStringValues Enumerates the set of values in String for ListHsmClustersSortByEnum
func GetListHsmClustersSortByEnumStringValues() []string {
	return []string{
		"TIMECREATED",
		"DISPLAYNAME",
	}
}

// GetMappingListHsmClustersSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHsmClustersSortByEnum(val string) (ListHsmClustersSortByEnum, bool) {
	enum, ok := mappingListHsmClustersSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHsmClustersSortOrderEnum Enum with underlying type: string
type ListHsmClustersSortOrderEnum string

// Set of constants representing the allowable values for ListHsmClustersSortOrderEnum
const (
	ListHsmClustersSortOrderAsc  ListHsmClustersSortOrderEnum = "ASC"
	ListHsmClustersSortOrderDesc ListHsmClustersSortOrderEnum = "DESC"
)

var mappingListHsmClustersSortOrderEnum = map[string]ListHsmClustersSortOrderEnum{
	"ASC":  ListHsmClustersSortOrderAsc,
	"DESC": ListHsmClustersSortOrderDesc,
}

var mappingListHsmClustersSortOrderEnumLowerCase = map[string]ListHsmClustersSortOrderEnum{
	"asc":  ListHsmClustersSortOrderAsc,
	"desc": ListHsmClustersSortOrderDesc,
}

// GetListHsmClustersSortOrderEnumValues Enumerates the set of values for ListHsmClustersSortOrderEnum
func GetListHsmClustersSortOrderEnumValues() []ListHsmClustersSortOrderEnum {
	values := make([]ListHsmClustersSortOrderEnum, 0)
	for _, v := range mappingListHsmClustersSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHsmClustersSortOrderEnumStringValues Enumerates the set of values in String for ListHsmClustersSortOrderEnum
func GetListHsmClustersSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHsmClustersSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHsmClustersSortOrderEnum(val string) (ListHsmClustersSortOrderEnum, bool) {
	enum, ok := mappingListHsmClustersSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
