// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateContainerScanTargetDetails The information for a new container scan target
type CreateContainerScanTargetDetails struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan target's compartment
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	TargetRegistry CreateContainerScanRegistryDetails `mandatory:"true" json:"targetRegistry"`

	// ID of the container scan recipe this target applies.
	ContainerScanRecipeId *string `mandatory:"true" json:"containerScanRecipeId"`

	// User friendly name of container scan target. If not present, will be auto-generated.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Target description.
	Description *string `mandatory:"false" json:"description"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`
}

func (m CreateContainerScanTargetDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateContainerScanTargetDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *CreateContainerScanTargetDetails) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		DisplayName           *string                            `json:"displayName"`
		Description           *string                            `json:"description"`
		FreeformTags          map[string]string                  `json:"freeformTags"`
		DefinedTags           map[string]map[string]interface{}  `json:"definedTags"`
		CompartmentId         *string                            `json:"compartmentId"`
		TargetRegistry        createcontainerscanregistrydetails `json:"targetRegistry"`
		ContainerScanRecipeId *string                            `json:"containerScanRecipeId"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.DisplayName = model.DisplayName

	m.Description = model.Description

	m.FreeformTags = model.FreeformTags

	m.DefinedTags = model.DefinedTags

	m.CompartmentId = model.CompartmentId

	nn, e = model.TargetRegistry.UnmarshalPolymorphicJSON(model.TargetRegistry.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.TargetRegistry = nn.(CreateContainerScanRegistryDetails)
	} else {
		m.TargetRegistry = nil
	}

	m.ContainerScanRecipeId = model.ContainerScanRecipeId

	return
}
