// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/datacatalog/v1/datacatalog.proto

package datacatalog

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Entry resources in Data Catalog can be of different types e.g. a BigQuery
// Table entry is of type `TABLE`. This enum describes all the possible types
// Data Catalog contains.
type EntryType int32

const (
	// Default unknown type.
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// Output only. The type of entry that has a GoogleSQL schema, including
	// logical views.
	EntryType_TABLE EntryType = 2
	// Output only. The type of models, examples include
	// https://cloud.google.com/bigquery-ml/docs/bigqueryml-intro
	EntryType_MODEL EntryType = 5
	// Output only. An entry type which is used for streaming entries. Example:
	// Pub/Sub topic.
	EntryType_DATA_STREAM EntryType = 3
	// An entry type which is a set of files or objects. Example:
	// Cloud Storage fileset.
	EntryType_FILESET EntryType = 4
)

// Enum value maps for EntryType.
var (
	EntryType_name = map[int32]string{
		0: "ENTRY_TYPE_UNSPECIFIED",
		2: "TABLE",
		5: "MODEL",
		3: "DATA_STREAM",
		4: "FILESET",
	}
	EntryType_value = map[string]int32{
		"ENTRY_TYPE_UNSPECIFIED": 0,
		"TABLE":                  2,
		"MODEL":                  5,
		"DATA_STREAM":            3,
		"FILESET":                4,
	}
)

func (x EntryType) Enum() *EntryType {
	p := new(EntryType)
	*p = x
	return p
}

func (x EntryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntryType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[0].Descriptor()
}

func (EntryType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[0]
}

func (x EntryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntryType.Descriptor instead.
func (EntryType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0}
}

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The scope of this search request. A `scope` that has empty
	// `include_org_ids`, `include_project_ids` AND false
	// `include_gcp_public_datasets` is considered invalid. Data Catalog will
	// return an error in such a case.
	Scope *SearchCatalogRequest_Scope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The query string in search query syntax. The query must be
	// non-empty.
	//
	// Query strings can be simple as "x" or more qualified as:
	//
	// * name:x
	// * column:x
	// * description:y
	//
	// Note: Query tokens need to have a minimum of 3 characters for substring
	// matching to work correctly. See [Data Catalog Search
	// Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
	// for more information.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Number of results in the search page. If <=0 then defaults to 10. Max limit
	// for page_size is 1000. Throws an invalid argument for page_size > 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token returned in an earlier
	// [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1.SearchCatalogResponse.next_page_token],
	// which indicates that this is a continuation of a prior
	// [SearchCatalogRequest][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog]
	// call, and that the system should return the next page of data. If empty,
	// the first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the ordering of results, currently supported case-sensitive
	// choices are:
	//
	//   * `relevance`, only supports descending
	//   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
	//     specified
	//
	// If not specified, defaults to `relevance` descending.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchCatalogRequest) Reset() {
	*x = SearchCatalogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogRequest) ProtoMessage() {}

func (x *SearchCatalogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogRequest.ProtoReflect.Descriptor instead.
func (*SearchCatalogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0}
}

func (x *SearchCatalogRequest) GetScope() *SearchCatalogRequest_Scope {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *SearchCatalogRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchCatalogRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchCatalogRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchCatalogRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Search results.
	Results []*SearchCatalogResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The token that can be used to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable locations. Search result does not include data from those
	// locations. Users can get additional information on the error by repeating
	// the search request with a more restrictive parameter -- setting the value
	// for `SearchDataCatalogRequest.scope.include_locations`.
	Unreachable []string `protobuf:"bytes,6,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *SearchCatalogResponse) Reset() {
	*x = SearchCatalogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogResponse) ProtoMessage() {}

func (x *SearchCatalogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogResponse.ProtoReflect.Descriptor instead.
func (*SearchCatalogResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{1}
}

func (x *SearchCatalogResponse) GetResults() []*SearchCatalogResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchCatalogResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchCatalogResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [CreateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup].
type CreateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project this entry group is in. Example:
	//
	// * projects/{project_id}/locations/{location}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry group to create.
	// The id must begin with a letter or underscore, contain only English
	// letters, numbers and underscores, and be at most 64 characters.
	EntryGroupId string `protobuf:"bytes,3,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// The entry group to create. Defaults to an empty entry group.
	EntryGroup *EntryGroup `protobuf:"bytes,2,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
}

func (x *CreateEntryGroupRequest) Reset() {
	*x = CreateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryGroupRequest) ProtoMessage() {}

func (x *CreateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{2}
}

func (x *CreateEntryGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroupId() string {
	if x != nil {
		return x.EntryGroupId
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

// Request message for
// [UpdateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup].
type UpdateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated entry group. "name" field must be set.
	EntryGroup *EntryGroup `protobuf:"bytes,1,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// The fields to update on the entry group. If absent or empty, all modifiable
	// fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntryGroupRequest) Reset() {
	*x = UpdateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryGroupRequest) ProtoMessage() {}

func (x *UpdateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [GetEntryGroup][google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup].
type GetEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If not set or empty, all fields are returned.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *GetEntryGroupRequest) Reset() {
	*x = GetEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryGroupRequest) ProtoMessage() {}

func (x *GetEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{4}
}

func (x *GetEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntryGroupRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Request message for
// [DeleteEntryGroup][google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup].
type DeleteEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If true, deletes all entries in the entry group.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteEntryGroupRequest) Reset() {
	*x = DeleteEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryGroupRequest) ProtoMessage() {}

func (x *DeleteEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryGroupRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the location that contains the entry groups, which
	// can be provided in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return. Default is 10. Max limit
	// is 1000. Throws an invalid argument for `page_size > 1000`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token that specifies which page is requested. If empty, the first
	// page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntryGroupsRequest) Reset() {
	*x = ListEntryGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsRequest) ProtoMessage() {}

func (x *ListEntryGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{6}
}

func (x *ListEntryGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// EntryGroup details.
	EntryGroups []*EntryGroup `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntryGroupsResponse) Reset() {
	*x = ListEntryGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsResponse) ProtoMessage() {}

func (x *ListEntryGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{7}
}

func (x *ListEntryGroupsResponse) GetEntryGroups() []*EntryGroup {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *ListEntryGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry].
type CreateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group this entry is in. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry to create.
	EntryId string `protobuf:"bytes,3,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. The entry to create.
	Entry *Entry `protobuf:"bytes,2,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *CreateEntryRequest) Reset() {
	*x = CreateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryRequest) ProtoMessage() {}

func (x *CreateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{8}
}

func (x *CreateEntryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryRequest) GetEntryId() string {
	if x != nil {
		return x.EntryId
	}
	return ""
}

func (x *CreateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1.DataCatalog.UpdateEntry].
type UpdateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated entry. The "name" field must be set.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// The fields to update on the entry. If absent or empty, all modifiable
	// fields are updated.
	//
	// The following fields are modifiable:
	// * For entries with type `DATA_STREAM`:
	//    * `schema`
	// * For entries with type `FILESET`
	//    * `schema`
	//    * `display_name`
	//    * `description`
	//    * `gcs_fileset_spec`
	//    * `gcs_fileset_spec.file_patterns`
	// * For entries with `user_specified_type`
	//    * `schema`
	//    * `display_name`
	//    * `description`
	//    * user_specified_type
	//    * user_specified_system
	//    * linked_resource
	//    * source_system_timestamps
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntryRequest) Reset() {
	*x = UpdateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryRequest) ProtoMessage() {}

func (x *UpdateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *UpdateEntryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteEntry][google.cloud.datacatalog.v1.DataCatalog.DeleteEntry].
type DeleteEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntryRequest) Reset() {
	*x = DeleteEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryRequest) ProtoMessage() {}

func (x *DeleteEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [GetEntry][google.cloud.datacatalog.v1.DataCatalog.GetEntry].
type GetEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryRequest) Reset() {
	*x = GetEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryRequest) ProtoMessage() {}

func (x *GetEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryRequest.ProtoReflect.Descriptor instead.
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{11}
}

func (x *GetEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Represents either the Google Cloud Platform resource or SQL name
	// for a Google Cloud Platform resource.
	//
	// Types that are assignable to TargetName:
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	TargetName isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
}

func (x *LookupEntryRequest) Reset() {
	*x = LookupEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEntryRequest) ProtoMessage() {}

func (x *LookupEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEntryRequest.ProtoReflect.Descriptor instead.
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{12}
}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (x *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := x.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (x *LookupEntryRequest) GetSqlResource() string {
	if x, ok := x.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	// The full name of the Google Cloud Platform resource the Data Catalog
	// entry represents. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name.
	// Full names are case-sensitive.
	//
	// Examples:
	//
	//  * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
	//  * //pubsub.googleapis.com/projects/projectId/topics/topicId
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	// The SQL name of the entry. SQL names are case-sensitive.
	//
	// Examples:
	//
	//   * `pubsub.project_id.topic_id`
	//   * ``pubsub.project_id.`topic.id.with.dots` ``
	//   * `bigquery.table.project_id.dataset_id.table_id`
	//   * `bigquery.dataset.project_id.dataset_id`
	//   * `datacatalog.entry.project_id.location_id.entry_group_id.entry_id`
	//
	// `*_id`s shoud satisfy the standard SQL rules for identifiers.
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical.
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

// Entry Metadata.
// A Data Catalog Entry resource represents another resource in Google
// Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
// outside of Google Cloud Platform. Clients can use the `linked_resource` field
// in the Entry resource to refer to the original resource ID of the source
// system.
//
// An Entry resource contains resource details, such as its schema. An Entry can
// also be used to attach flexible metadata, such as a
// [Tag][google.cloud.datacatalog.v1.Tag].
type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Data Catalog resource name of the entry in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource this metadata entry refers to.
	//
	// For Google Cloud Platform resources, `linked_resource` is the [full name of
	// the
	// resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
	//
	// Output only when Entry is of type in the EntryType enum. For entries with
	// user_specified_type, this field is optional and defaults to an empty
	// string.
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Required. Entry type.
	//
	// Types that are assignable to EntryType:
	//	*Entry_Type
	//	*Entry_UserSpecifiedType
	EntryType isEntry_EntryType `protobuf_oneof:"entry_type"`
	// The source system of the entry.
	//
	// Types that are assignable to System:
	//	*Entry_IntegratedSystem
	//	*Entry_UserSpecifiedSystem
	System isEntry_System `protobuf_oneof:"system"`
	// Type specification information.
	//
	// Types that are assignable to TypeSpec:
	//	*Entry_GcsFilesetSpec
	//	*Entry_BigqueryTableSpec
	//	*Entry_BigqueryDateShardedSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Display information such as title and description. A short name to identify
	// the entry, for example, "Analytics Data - Jan 2011". Default value is an
	// empty string.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry description, which can consist of several sentences or paragraphs
	// that describe entry contents. Default value is an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Schema of the entry. An entry might not have any schema attached to it.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Timestamps about the underlying resource, not about this Data Catalog
	// entry. Output only when Entry is of type in the EntryType enum. For entries
	// with user_specified_type, this field is optional and defaults to an empty
	// timestamp.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{13}
}

func (x *Entry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entry) GetLinkedResource() string {
	if x != nil {
		return x.LinkedResource
	}
	return ""
}

func (m *Entry) GetEntryType() isEntry_EntryType {
	if m != nil {
		return m.EntryType
	}
	return nil
}

func (x *Entry) GetType() EntryType {
	if x, ok := x.GetEntryType().(*Entry_Type); ok {
		return x.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

func (x *Entry) GetUserSpecifiedType() string {
	if x, ok := x.GetEntryType().(*Entry_UserSpecifiedType); ok {
		return x.UserSpecifiedType
	}
	return ""
}

func (m *Entry) GetSystem() isEntry_System {
	if m != nil {
		return m.System
	}
	return nil
}

func (x *Entry) GetIntegratedSystem() IntegratedSystem {
	if x, ok := x.GetSystem().(*Entry_IntegratedSystem); ok {
		return x.IntegratedSystem
	}
	return IntegratedSystem_INTEGRATED_SYSTEM_UNSPECIFIED
}

func (x *Entry) GetUserSpecifiedSystem() string {
	if x, ok := x.GetSystem().(*Entry_UserSpecifiedSystem); ok {
		return x.UserSpecifiedSystem
	}
	return ""
}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (x *Entry) GetGcsFilesetSpec() *GcsFilesetSpec {
	if x, ok := x.GetTypeSpec().(*Entry_GcsFilesetSpec); ok {
		return x.GcsFilesetSpec
	}
	return nil
}

func (x *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := x.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (x *Entry) GetBigqueryDateShardedSpec() *BigQueryDateShardedSpec {
	if x, ok := x.GetTypeSpec().(*Entry_BigqueryDateShardedSpec); ok {
		return x.BigqueryDateShardedSpec
	}
	return nil
}

func (x *Entry) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Entry) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Entry) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if x != nil {
		return x.SourceSystemTimestamps
	}
	return nil
}

type isEntry_EntryType interface {
	isEntry_EntryType()
}

type Entry_Type struct {
	// The type of the entry.
	// Only used for Entries with types in the EntryType enum.
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1.EntryType,oneof"`
}

type Entry_UserSpecifiedType struct {
	// Entry type if it does not fit any of the input-allowed values listed in
	// `EntryType` enum above. When creating an entry, users should check the
	// enum values first, if nothing matches the entry to be created, then
	// provide a custom value, for example "my_special_type".
	// `user_specified_type` strings must begin with a letter or underscore and
	// can only contain letters, numbers, and underscores; are case insensitive;
	// must be at least 1 character and at most 64 characters long.
	//
	// Currently, only FILESET enum value is allowed. All other entries created
	// through Data Catalog must use `user_specified_type`.
	UserSpecifiedType string `protobuf:"bytes,16,opt,name=user_specified_type,json=userSpecifiedType,proto3,oneof"`
}

func (*Entry_Type) isEntry_EntryType() {}

func (*Entry_UserSpecifiedType) isEntry_EntryType() {}

type isEntry_System interface {
	isEntry_System()
}

type Entry_IntegratedSystem struct {
	// Output only. This field indicates the entry's source system that Data
	// Catalog integrates with, such as BigQuery or Pub/Sub.
	IntegratedSystem IntegratedSystem `protobuf:"varint,17,opt,name=integrated_system,json=integratedSystem,proto3,enum=google.cloud.datacatalog.v1.IntegratedSystem,oneof"`
}

type Entry_UserSpecifiedSystem struct {
	// This field indicates the entry's source system that Data Catalog does not
	// integrate with. `user_specified_system` strings must begin with a letter
	// or underscore and can only contain letters, numbers, and underscores; are
	// case insensitive; must be at least 1 character and at most 64 characters
	// long.
	UserSpecifiedSystem string `protobuf:"bytes,18,opt,name=user_specified_system,json=userSpecifiedSystem,proto3,oneof"`
}

func (*Entry_IntegratedSystem) isEntry_System() {}

func (*Entry_UserSpecifiedSystem) isEntry_System() {}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_GcsFilesetSpec struct {
	// Specification that applies to a Cloud Storage fileset. This is only valid
	// on entries of type FILESET.
	GcsFilesetSpec *GcsFilesetSpec `protobuf:"bytes,6,opt,name=gcs_fileset_spec,json=gcsFilesetSpec,proto3,oneof"`
}

type Entry_BigqueryTableSpec struct {
	// Specification that applies to a BigQuery table. This is only valid on
	// entries of type `TABLE`.
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

type Entry_BigqueryDateShardedSpec struct {
	// Specification for a group of BigQuery tables with name pattern
	// `[prefix]YYYYMMDD`. Context:
	// https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
	BigqueryDateShardedSpec *BigQueryDateShardedSpec `protobuf:"bytes,15,opt,name=bigquery_date_sharded_spec,json=bigqueryDateShardedSpec,proto3,oneof"`
}

func (*Entry_GcsFilesetSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryDateShardedSpec) isEntry_TypeSpec() {}

// EntryGroup Metadata.
// An EntryGroup resource represents a logical grouping of zero or more
// Data Catalog [Entry][google.cloud.datacatalog.v1.Entry] resources.
type EntryGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the entry group in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name to identify the entry group, for example,
	// "analytics data - jan 2011". Default value is an empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry group description, which can consist of several sentences or
	// paragraphs that describe entry group contents. Default value is an empty
	// string.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamps about this EntryGroup. Default value is empty
	// timestamps.
	DataCatalogTimestamps *SystemTimestamps `protobuf:"bytes,4,opt,name=data_catalog_timestamps,json=dataCatalogTimestamps,proto3" json:"data_catalog_timestamps,omitempty"`
}

func (x *EntryGroup) Reset() {
	*x = EntryGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryGroup) ProtoMessage() {}

func (x *EntryGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryGroup.ProtoReflect.Descriptor instead.
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{14}
}

func (x *EntryGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryGroup) GetDataCatalogTimestamps() *SystemTimestamps {
	if x != nil {
		return x.DataCatalogTimestamps
	}
	return nil
}

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate].
type CreateTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and the template location
	// [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
	//
	// Example:
	//
	// * projects/{project_id}/locations/us-central1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the tag template to create.
	TagTemplateId string `protobuf:"bytes,3,opt,name=tag_template_id,json=tagTemplateId,proto3" json:"tag_template_id,omitempty"`
	// Required. The tag template to create.
	TagTemplate *TagTemplate `protobuf:"bytes,2,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
}

func (x *CreateTagTemplateRequest) Reset() {
	*x = CreateTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagTemplateRequest) ProtoMessage() {}

func (x *CreateTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{15}
}

func (x *CreateTagTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagTemplateRequest) GetTagTemplateId() string {
	if x != nil {
		return x.TagTemplateId
	}
	return ""
}

func (x *CreateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if x != nil {
		return x.TagTemplate
	}
	return nil
}

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate].
type GetTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTagTemplateRequest) Reset() {
	*x = GetTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTagTemplateRequest) ProtoMessage() {}

func (x *GetTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{16}
}

func (x *GetTagTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate].
type UpdateTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The template to update. The "name" field must be set.
	TagTemplate *TagTemplate `protobuf:"bytes,1,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	// The field mask specifies the parts of the template to overwrite.
	//
	// Allowed fields:
	//
	//   * `display_name`
	//
	// If absent or empty, all of the allowed fields above will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagTemplateRequest) Reset() {
	*x = UpdateTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagTemplateRequest) ProtoMessage() {}

func (x *UpdateTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if x != nil {
		return x.TagTemplate
	}
	return nil
}

func (x *UpdateTagTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate].
type DeleteTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of any possible tags using this template.
	// `force = false` will be supported in the future.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteTagTemplateRequest) Reset() {
	*x = DeleteTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagTemplateRequest) ProtoMessage() {}

func (x *DeleteTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteTagTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTagTemplateRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [CreateTag][google.cloud.datacatalog.v1.DataCatalog.CreateTag].
type CreateTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource to attach this tag to. Tags can be
	// attached to Entries. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Tag and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tag to create.
	Tag *Tag `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *CreateTagRequest) Reset() {
	*x = CreateTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagRequest) ProtoMessage() {}

func (x *CreateTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagRequest.ProtoReflect.Descriptor instead.
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{19}
}

func (x *CreateTagRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagRequest) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1.DataCatalog.UpdateTag].
type UpdateTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated tag. The "name" field must be set.
	Tag *Tag `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// The fields to update on the Tag. If absent or empty, all modifiable fields
	// are updated. Currently the only modifiable field is the field `fields`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagRequest) Reset() {
	*x = UpdateTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagRequest) ProtoMessage() {}

func (x *UpdateTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateTagRequest) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *UpdateTagRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1.DataCatalog.DeleteTag].
type DeleteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTagRequest) Reset() {
	*x = DeleteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagRequest) ProtoMessage() {}

func (x *DeleteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField].
type CreateTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and the template location
	// [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
	//
	// Example:
	//
	// * projects/{project_id}/locations/us-central1/tagTemplates/{tag_template_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the tag template field to create.
	// Field ids can contain letters (both uppercase and lowercase), numbers
	// (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
	// character long and at most 128 characters long. Field IDs must also be
	// unique within their template.
	TagTemplateFieldId string `protobuf:"bytes,2,opt,name=tag_template_field_id,json=tagTemplateFieldId,proto3" json:"tag_template_field_id,omitempty"`
	// Required. The tag template field to create.
	TagTemplateField *TagTemplateField `protobuf:"bytes,3,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
}

func (x *CreateTagTemplateFieldRequest) Reset() {
	*x = CreateTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagTemplateFieldRequest) ProtoMessage() {}

func (x *CreateTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*CreateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{22}
}

func (x *CreateTagTemplateFieldRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagTemplateFieldRequest) GetTagTemplateFieldId() string {
	if x != nil {
		return x.TagTemplateFieldId
	}
	return ""
}

func (x *CreateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if x != nil {
		return x.TagTemplateField
	}
	return nil
}

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField].
type UpdateTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template field. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The template to update.
	TagTemplateField *TagTemplateField `protobuf:"bytes,2,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	// Optional. The field mask specifies the parts of the template to be updated.
	// Allowed fields:
	//
	//   * `display_name`
	//   * `type.enum_type`
	//   * `is_required`
	//
	// If `update_mask` is not set or empty, all of the allowed fields above will
	// be updated.
	//
	// When updating an enum type, the provided values will be merged with the
	// existing values. Therefore, enum values can only be added, existing enum
	// values cannot be deleted nor renamed. Updating a template field from
	// optional to required is NOT allowed.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagTemplateFieldRequest) Reset() {
	*x = UpdateTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagTemplateFieldRequest) ProtoMessage() {}

func (x *UpdateTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if x != nil {
		return x.TagTemplateField
	}
	return nil
}

func (x *UpdateTagTemplateFieldRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField].
type RenameTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new ID of this tag template field. For example,
	// `my_new_field`.
	NewTagTemplateFieldId string `protobuf:"bytes,2,opt,name=new_tag_template_field_id,json=newTagTemplateFieldId,proto3" json:"new_tag_template_field_id,omitempty"`
}

func (x *RenameTagTemplateFieldRequest) Reset() {
	*x = RenameTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameTagTemplateFieldRequest) ProtoMessage() {}

func (x *RenameTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*RenameTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{24}
}

func (x *RenameTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameTagTemplateFieldRequest) GetNewTagTemplateFieldId() string {
	if x != nil {
		return x.NewTagTemplateFieldId
	}
	return ""
}

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField].
type DeleteTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template field to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of this field from any tags using this field.
	// `force = false` will be supported in the future.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteTagTemplateFieldRequest) Reset() {
	*x = DeleteTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagTemplateFieldRequest) ProtoMessage() {}

func (x *DeleteTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTagTemplateFieldRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Data Catalog resource to list the tags of. The
	// resource could be an [Entry][google.cloud.datacatalog.v1.Entry] or an
	// [EntryGroup][google.cloud.datacatalog.v1.EntryGroup].
	//
	// Examples:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of tags to return. Default is 10. Max limit is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTagsRequest) Reset() {
	*x = ListTagsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsRequest) ProtoMessage() {}

func (x *ListTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsRequest.ProtoReflect.Descriptor instead.
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{26}
}

func (x *ListTagsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTagsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTagsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Tag][google.cloud.datacatalog.v1.Tag] details.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTagsResponse) Reset() {
	*x = ListTagsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsResponse) ProtoMessage() {}

func (x *ListTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsResponse.ProtoReflect.Descriptor instead.
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{27}
}

func (x *ListTagsResponse) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ListTagsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group that contains the entries, which can
	// be provided in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default is 10. Max limit is 1000.
	// Throws an invalid argument for `page_size > 1000`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields to return for each Entry. If not set or empty, all
	// fields are returned.
	// For example, setting read_mask to contain only one path "name" will cause
	// ListEntries to return a list of Entries with only "name" field.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListEntriesRequest) Reset() {
	*x = ListEntriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesRequest) ProtoMessage() {}

func (x *ListEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{28}
}

func (x *ListEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntriesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry details.
	Entries []*Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntriesResponse) Reset() {
	*x = ListEntriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesResponse) ProtoMessage() {}

func (x *ListEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{29}
}

func (x *ListEntriesResponse) GetEntries() []*Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The criteria that select the subspace used for query matching.
type SearchCatalogRequest_Scope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of organization IDs to search within. To find your organization
	// ID, follow instructions in
	// https://cloud.google.com/resource-manager/docs/creating-managing-organization.
	IncludeOrgIds []string `protobuf:"bytes,2,rep,name=include_org_ids,json=includeOrgIds,proto3" json:"include_org_ids,omitempty"`
	// The list of project IDs to search within. To learn more about the
	// distinction between project names/IDs/numbers, go to
	// https://cloud.google.com/docs/overview/#projects.
	IncludeProjectIds []string `protobuf:"bytes,3,rep,name=include_project_ids,json=includeProjectIds,proto3" json:"include_project_ids,omitempty"`
	// If `true`, include Google Cloud Platform (GCP) public datasets in the
	// search results. Info on GCP public datasets is available at
	// https://cloud.google.com/public-datasets/. By default, GCP public
	// datasets are excluded.
	IncludeGcpPublicDatasets bool `protobuf:"varint,7,opt,name=include_gcp_public_datasets,json=includeGcpPublicDatasets,proto3" json:"include_gcp_public_datasets,omitempty"`
	// Optional. The list of locations to search within.
	// 1. If empty, search will be performed in all locations;
	// 2. If any of the locations are NOT in the valid locations list, error
	// will be returned;
	// 3. Otherwise, search only the given locations for matching results.
	// Typical usage is to leave this field empty. When a location is
	// unreachable as returned in the `SearchCatalogResponse.unreachable` field,
	// users can repeat the search request with this parameter set to get
	// additional information on the error.
	//
	// Valid locations:
	//  * asia-east1
	//  * asia-east2
	//  * asia-northeast1
	//  * asia-northeast2
	//  * asia-northeast3
	//  * asia-south1
	//  * asia-southeast1
	//  * australia-southeast1
	//  * eu
	//  * europe-north1
	//  * europe-west1
	//  * europe-west2
	//  * europe-west3
	//  * europe-west4
	//  * europe-west6
	//  * global
	//  * northamerica-northeast1
	//  * southamerica-east1
	//  * us
	//  * us-central1
	//  * us-east1
	//  * us-east4
	//  * us-west1
	//  * us-west2
	RestrictedLocations []string `protobuf:"bytes,16,rep,name=restricted_locations,json=restrictedLocations,proto3" json:"restricted_locations,omitempty"`
}

func (x *SearchCatalogRequest_Scope) Reset() {
	*x = SearchCatalogRequest_Scope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogRequest_Scope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogRequest_Scope) ProtoMessage() {}

func (x *SearchCatalogRequest_Scope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogRequest_Scope.ProtoReflect.Descriptor instead.
func (*SearchCatalogRequest_Scope) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SearchCatalogRequest_Scope) GetIncludeOrgIds() []string {
	if x != nil {
		return x.IncludeOrgIds
	}
	return nil
}

func (x *SearchCatalogRequest_Scope) GetIncludeProjectIds() []string {
	if x != nil {
		return x.IncludeProjectIds
	}
	return nil
}

func (x *SearchCatalogRequest_Scope) GetIncludeGcpPublicDatasets() bool {
	if x != nil {
		return x.IncludeGcpPublicDatasets
	}
	return false
}

func (x *SearchCatalogRequest_Scope) GetRestrictedLocations() []string {
	if x != nil {
		return x.RestrictedLocations
	}
	return nil
}

var File_google_cloud_datacatalog_v1_datacatalog_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xba, 0x03, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x1a, 0xd6, 0x01, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x26,
	0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6f, 0x72, 0x67, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x4f, 0x72, 0x67, 0x49, 0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x67, 0x63, 0x70, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x47, 0x63, 0x70, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x10, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xad, 0x01,
	0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xd5, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x12, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x0b, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xa5, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92, 0x01,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x77, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4a, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1e, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x49,
	0x64, 0x12, 0x3d, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x22, 0x90, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x52, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4f, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x73, 0x0a, 0x12, 0x4c, 0x6f, 0x6f, 0x6b,
	0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29,
	0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x71, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb3, 0x08,
	0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b, 0x65,
	0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x3c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x30,
	0x0a, 0x13, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x75,
	0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x61, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x01, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x12, 0x34, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x01, 0x52, 0x13, 0x75, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x63, 0x73,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x02, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x60, 0x0a, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48,
	0x02, 0x52, 0x11, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x73, 0x0a, 0x1a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x48, 0x02,
	0x52, 0x17, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x67, 0x0a, 0x18, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x52, 0x16, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x73, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x51, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x7d, 0x42, 0x0c,
	0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x22, 0xc0, 0x02, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x25, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x22, 0xe1, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x74,
	0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x67, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x5b, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x79, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x8b,
	0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0x88, 0x01, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x37, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4e, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x20, 0x12, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x36, 0x0a, 0x15, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x67,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x8c, 0x02, 0x0a, 0x1d,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa7, 0x01, 0x0a, 0x1d, 0x52,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x19, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x61, 0x67,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x6e,
	0x65, 0x77, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x70, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34,
	0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x01, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x7b, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x5b, 0x0a, 0x09,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x54,
	0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x46, 0x49, 0x4c, 0x45, 0x53, 0x45, 0x54, 0x10, 0x04, 0x32, 0xad, 0x2f, 0x0a, 0x0b, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0xa3, 0x01, 0x0a, 0x0d, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x0b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0xdb, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x3a, 0x0b, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0xbc, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x4f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x0e, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xeb, 0x01, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0xda, 0x41, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0xda, 0x41, 0x17, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa0, 0x01, 0x0a, 0x10, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbe, 0x01,
	0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc4,
	0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x39, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda, 0x41, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x2c,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0xce, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda, 0x41, 0x05, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0xda, 0x41, 0x11, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa0, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa6, 0x01, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x7e, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x6c, 0x6f, 0x6f, 0x6b,
	0x75, 0x70, 0x12, 0xbc, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xe2, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x3a, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0xaf, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf3, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22,
	0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61,
	0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0xda, 0x41, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0xda, 0x41, 0x18, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa9,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0a,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x8d, 0x02, 0x0a, 0x16, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x3a, 0x12, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x9b, 0x02, 0x0a, 0x16, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x22, 0x95, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x12, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0xda, 0x41, 0x17, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0xda, 0x41, 0x23, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xf1, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x6c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1e, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x12, 0xbc, 0x01, 0x0a,
	0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x09,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x22, 0x9a, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x86, 0x01, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x3a, 0x03, 0x74, 0x61, 0x67, 0x5a, 0x3d, 0x22, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x74, 0x61, 0x67, 0x73, 0x3a, 0x03, 0x74, 0x61, 0x67, 0xda, 0x41, 0x0a, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x67, 0x12, 0x8c, 0x02, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x22, 0xad, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8e, 0x01,
	0x32, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x74, 0x61, 0x67, 0x5a, 0x41, 0x32, 0x3a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x74, 0x61, 0x67, 0xda, 0x41,
	0x03, 0x74, 0x61, 0x67, 0xda, 0x41, 0x0f, 0x74, 0x61, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xde, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x89, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x7c, 0x2a, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf5, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x61, 0x67, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x8b, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x5a, 0x38, 0x12, 0x36,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xf2, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xa6, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x8d, 0x01, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x45, 0x22, 0x40, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0xbc, 0x02, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0xf0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xde, 0x01, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a,
	0x5a, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x4f, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0xe3, 0x02, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xf7, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf0, 0x01, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x4b, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x01, 0x2a, 0x5a, 0x55, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xcb, 0x01, 0x0a, 0x1f, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a,
	0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData = file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes = []interface{}{
	(EntryType)(0),                        // 0: google.cloud.datacatalog.v1.EntryType
	(*SearchCatalogRequest)(nil),          // 1: google.cloud.datacatalog.v1.SearchCatalogRequest
	(*SearchCatalogResponse)(nil),         // 2: google.cloud.datacatalog.v1.SearchCatalogResponse
	(*CreateEntryGroupRequest)(nil),       // 3: google.cloud.datacatalog.v1.CreateEntryGroupRequest
	(*UpdateEntryGroupRequest)(nil),       // 4: google.cloud.datacatalog.v1.UpdateEntryGroupRequest
	(*GetEntryGroupRequest)(nil),          // 5: google.cloud.datacatalog.v1.GetEntryGroupRequest
	(*DeleteEntryGroupRequest)(nil),       // 6: google.cloud.datacatalog.v1.DeleteEntryGroupRequest
	(*ListEntryGroupsRequest)(nil),        // 7: google.cloud.datacatalog.v1.ListEntryGroupsRequest
	(*ListEntryGroupsResponse)(nil),       // 8: google.cloud.datacatalog.v1.ListEntryGroupsResponse
	(*CreateEntryRequest)(nil),            // 9: google.cloud.datacatalog.v1.CreateEntryRequest
	(*UpdateEntryRequest)(nil),            // 10: google.cloud.datacatalog.v1.UpdateEntryRequest
	(*DeleteEntryRequest)(nil),            // 11: google.cloud.datacatalog.v1.DeleteEntryRequest
	(*GetEntryRequest)(nil),               // 12: google.cloud.datacatalog.v1.GetEntryRequest
	(*LookupEntryRequest)(nil),            // 13: google.cloud.datacatalog.v1.LookupEntryRequest
	(*Entry)(nil),                         // 14: google.cloud.datacatalog.v1.Entry
	(*EntryGroup)(nil),                    // 15: google.cloud.datacatalog.v1.EntryGroup
	(*CreateTagTemplateRequest)(nil),      // 16: google.cloud.datacatalog.v1.CreateTagTemplateRequest
	(*GetTagTemplateRequest)(nil),         // 17: google.cloud.datacatalog.v1.GetTagTemplateRequest
	(*UpdateTagTemplateRequest)(nil),      // 18: google.cloud.datacatalog.v1.UpdateTagTemplateRequest
	(*DeleteTagTemplateRequest)(nil),      // 19: google.cloud.datacatalog.v1.DeleteTagTemplateRequest
	(*CreateTagRequest)(nil),              // 20: google.cloud.datacatalog.v1.CreateTagRequest
	(*UpdateTagRequest)(nil),              // 21: google.cloud.datacatalog.v1.UpdateTagRequest
	(*DeleteTagRequest)(nil),              // 22: google.cloud.datacatalog.v1.DeleteTagRequest
	(*CreateTagTemplateFieldRequest)(nil), // 23: google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest
	(*UpdateTagTemplateFieldRequest)(nil), // 24: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest
	(*RenameTagTemplateFieldRequest)(nil), // 25: google.cloud.datacatalog.v1.RenameTagTemplateFieldRequest
	(*DeleteTagTemplateFieldRequest)(nil), // 26: google.cloud.datacatalog.v1.DeleteTagTemplateFieldRequest
	(*ListTagsRequest)(nil),               // 27: google.cloud.datacatalog.v1.ListTagsRequest
	(*ListTagsResponse)(nil),              // 28: google.cloud.datacatalog.v1.ListTagsResponse
	(*ListEntriesRequest)(nil),            // 29: google.cloud.datacatalog.v1.ListEntriesRequest
	(*ListEntriesResponse)(nil),           // 30: google.cloud.datacatalog.v1.ListEntriesResponse
	(*SearchCatalogRequest_Scope)(nil),    // 31: google.cloud.datacatalog.v1.SearchCatalogRequest.Scope
	(*SearchCatalogResult)(nil),           // 32: google.cloud.datacatalog.v1.SearchCatalogResult
	(*fieldmaskpb.FieldMask)(nil),         // 33: google.protobuf.FieldMask
	(IntegratedSystem)(0),                 // 34: google.cloud.datacatalog.v1.IntegratedSystem
	(*GcsFilesetSpec)(nil),                // 35: google.cloud.datacatalog.v1.GcsFilesetSpec
	(*BigQueryTableSpec)(nil),             // 36: google.cloud.datacatalog.v1.BigQueryTableSpec
	(*BigQueryDateShardedSpec)(nil),       // 37: google.cloud.datacatalog.v1.BigQueryDateShardedSpec
	(*Schema)(nil),                        // 38: google.cloud.datacatalog.v1.Schema
	(*SystemTimestamps)(nil),              // 39: google.cloud.datacatalog.v1.SystemTimestamps
	(*TagTemplate)(nil),                   // 40: google.cloud.datacatalog.v1.TagTemplate
	(*Tag)(nil),                           // 41: google.cloud.datacatalog.v1.Tag
	(*TagTemplateField)(nil),              // 42: google.cloud.datacatalog.v1.TagTemplateField
	(*v1.SetIamPolicyRequest)(nil),        // 43: google.iam.v1.SetIamPolicyRequest
	(*v1.GetIamPolicyRequest)(nil),        // 44: google.iam.v1.GetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),  // 45: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                 // 46: google.protobuf.Empty
	(*v1.Policy)(nil),                     // 47: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil), // 48: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs = []int32{
	31, // 0: google.cloud.datacatalog.v1.SearchCatalogRequest.scope:type_name -> google.cloud.datacatalog.v1.SearchCatalogRequest.Scope
	32, // 1: google.cloud.datacatalog.v1.SearchCatalogResponse.results:type_name -> google.cloud.datacatalog.v1.SearchCatalogResult
	15, // 2: google.cloud.datacatalog.v1.CreateEntryGroupRequest.entry_group:type_name -> google.cloud.datacatalog.v1.EntryGroup
	15, // 3: google.cloud.datacatalog.v1.UpdateEntryGroupRequest.entry_group:type_name -> google.cloud.datacatalog.v1.EntryGroup
	33, // 4: google.cloud.datacatalog.v1.UpdateEntryGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	33, // 5: google.cloud.datacatalog.v1.GetEntryGroupRequest.read_mask:type_name -> google.protobuf.FieldMask
	15, // 6: google.cloud.datacatalog.v1.ListEntryGroupsResponse.entry_groups:type_name -> google.cloud.datacatalog.v1.EntryGroup
	14, // 7: google.cloud.datacatalog.v1.CreateEntryRequest.entry:type_name -> google.cloud.datacatalog.v1.Entry
	14, // 8: google.cloud.datacatalog.v1.UpdateEntryRequest.entry:type_name -> google.cloud.datacatalog.v1.Entry
	33, // 9: google.cloud.datacatalog.v1.UpdateEntryRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 10: google.cloud.datacatalog.v1.Entry.type:type_name -> google.cloud.datacatalog.v1.EntryType
	34, // 11: google.cloud.datacatalog.v1.Entry.integrated_system:type_name -> google.cloud.datacatalog.v1.IntegratedSystem
	35, // 12: google.cloud.datacatalog.v1.Entry.gcs_fileset_spec:type_name -> google.cloud.datacatalog.v1.GcsFilesetSpec
	36, // 13: google.cloud.datacatalog.v1.Entry.bigquery_table_spec:type_name -> google.cloud.datacatalog.v1.BigQueryTableSpec
	37, // 14: google.cloud.datacatalog.v1.Entry.bigquery_date_sharded_spec:type_name -> google.cloud.datacatalog.v1.BigQueryDateShardedSpec
	38, // 15: google.cloud.datacatalog.v1.Entry.schema:type_name -> google.cloud.datacatalog.v1.Schema
	39, // 16: google.cloud.datacatalog.v1.Entry.source_system_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	39, // 17: google.cloud.datacatalog.v1.EntryGroup.data_catalog_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	40, // 18: google.cloud.datacatalog.v1.CreateTagTemplateRequest.tag_template:type_name -> google.cloud.datacatalog.v1.TagTemplate
	40, // 19: google.cloud.datacatalog.v1.UpdateTagTemplateRequest.tag_template:type_name -> google.cloud.datacatalog.v1.TagTemplate
	33, // 20: google.cloud.datacatalog.v1.UpdateTagTemplateRequest.update_mask:type_name -> google.protobuf.FieldMask
	41, // 21: google.cloud.datacatalog.v1.CreateTagRequest.tag:type_name -> google.cloud.datacatalog.v1.Tag
	41, // 22: google.cloud.datacatalog.v1.UpdateTagRequest.tag:type_name -> google.cloud.datacatalog.v1.Tag
	33, // 23: google.cloud.datacatalog.v1.UpdateTagRequest.update_mask:type_name -> google.protobuf.FieldMask
	42, // 24: google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest.tag_template_field:type_name -> google.cloud.datacatalog.v1.TagTemplateField
	42, // 25: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest.tag_template_field:type_name -> google.cloud.datacatalog.v1.TagTemplateField
	33, // 26: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest.update_mask:type_name -> google.protobuf.FieldMask
	41, // 27: google.cloud.datacatalog.v1.ListTagsResponse.tags:type_name -> google.cloud.datacatalog.v1.Tag
	33, // 28: google.cloud.datacatalog.v1.ListEntriesRequest.read_mask:type_name -> google.protobuf.FieldMask
	14, // 29: google.cloud.datacatalog.v1.ListEntriesResponse.entries:type_name -> google.cloud.datacatalog.v1.Entry
	1,  // 30: google.cloud.datacatalog.v1.DataCatalog.SearchCatalog:input_type -> google.cloud.datacatalog.v1.SearchCatalogRequest
	3,  // 31: google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup:input_type -> google.cloud.datacatalog.v1.CreateEntryGroupRequest
	5,  // 32: google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup:input_type -> google.cloud.datacatalog.v1.GetEntryGroupRequest
	4,  // 33: google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup:input_type -> google.cloud.datacatalog.v1.UpdateEntryGroupRequest
	6,  // 34: google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup:input_type -> google.cloud.datacatalog.v1.DeleteEntryGroupRequest
	7,  // 35: google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups:input_type -> google.cloud.datacatalog.v1.ListEntryGroupsRequest
	9,  // 36: google.cloud.datacatalog.v1.DataCatalog.CreateEntry:input_type -> google.cloud.datacatalog.v1.CreateEntryRequest
	10, // 37: google.cloud.datacatalog.v1.DataCatalog.UpdateEntry:input_type -> google.cloud.datacatalog.v1.UpdateEntryRequest
	11, // 38: google.cloud.datacatalog.v1.DataCatalog.DeleteEntry:input_type -> google.cloud.datacatalog.v1.DeleteEntryRequest
	12, // 39: google.cloud.datacatalog.v1.DataCatalog.GetEntry:input_type -> google.cloud.datacatalog.v1.GetEntryRequest
	13, // 40: google.cloud.datacatalog.v1.DataCatalog.LookupEntry:input_type -> google.cloud.datacatalog.v1.LookupEntryRequest
	29, // 41: google.cloud.datacatalog.v1.DataCatalog.ListEntries:input_type -> google.cloud.datacatalog.v1.ListEntriesRequest
	16, // 42: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate:input_type -> google.cloud.datacatalog.v1.CreateTagTemplateRequest
	17, // 43: google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate:input_type -> google.cloud.datacatalog.v1.GetTagTemplateRequest
	18, // 44: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate:input_type -> google.cloud.datacatalog.v1.UpdateTagTemplateRequest
	19, // 45: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate:input_type -> google.cloud.datacatalog.v1.DeleteTagTemplateRequest
	23, // 46: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField:input_type -> google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest
	24, // 47: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField:input_type -> google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest
	25, // 48: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField:input_type -> google.cloud.datacatalog.v1.RenameTagTemplateFieldRequest
	26, // 49: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField:input_type -> google.cloud.datacatalog.v1.DeleteTagTemplateFieldRequest
	20, // 50: google.cloud.datacatalog.v1.DataCatalog.CreateTag:input_type -> google.cloud.datacatalog.v1.CreateTagRequest
	21, // 51: google.cloud.datacatalog.v1.DataCatalog.UpdateTag:input_type -> google.cloud.datacatalog.v1.UpdateTagRequest
	22, // 52: google.cloud.datacatalog.v1.DataCatalog.DeleteTag:input_type -> google.cloud.datacatalog.v1.DeleteTagRequest
	27, // 53: google.cloud.datacatalog.v1.DataCatalog.ListTags:input_type -> google.cloud.datacatalog.v1.ListTagsRequest
	43, // 54: google.cloud.datacatalog.v1.DataCatalog.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	44, // 55: google.cloud.datacatalog.v1.DataCatalog.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	45, // 56: google.cloud.datacatalog.v1.DataCatalog.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	2,  // 57: google.cloud.datacatalog.v1.DataCatalog.SearchCatalog:output_type -> google.cloud.datacatalog.v1.SearchCatalogResponse
	15, // 58: google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	15, // 59: google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	15, // 60: google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	46, // 61: google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup:output_type -> google.protobuf.Empty
	8,  // 62: google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups:output_type -> google.cloud.datacatalog.v1.ListEntryGroupsResponse
	14, // 63: google.cloud.datacatalog.v1.DataCatalog.CreateEntry:output_type -> google.cloud.datacatalog.v1.Entry
	14, // 64: google.cloud.datacatalog.v1.DataCatalog.UpdateEntry:output_type -> google.cloud.datacatalog.v1.Entry
	46, // 65: google.cloud.datacatalog.v1.DataCatalog.DeleteEntry:output_type -> google.protobuf.Empty
	14, // 66: google.cloud.datacatalog.v1.DataCatalog.GetEntry:output_type -> google.cloud.datacatalog.v1.Entry
	14, // 67: google.cloud.datacatalog.v1.DataCatalog.LookupEntry:output_type -> google.cloud.datacatalog.v1.Entry
	30, // 68: google.cloud.datacatalog.v1.DataCatalog.ListEntries:output_type -> google.cloud.datacatalog.v1.ListEntriesResponse
	40, // 69: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	40, // 70: google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	40, // 71: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	46, // 72: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate:output_type -> google.protobuf.Empty
	42, // 73: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	42, // 74: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	42, // 75: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	46, // 76: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField:output_type -> google.protobuf.Empty
	41, // 77: google.cloud.datacatalog.v1.DataCatalog.CreateTag:output_type -> google.cloud.datacatalog.v1.Tag
	41, // 78: google.cloud.datacatalog.v1.DataCatalog.UpdateTag:output_type -> google.cloud.datacatalog.v1.Tag
	46, // 79: google.cloud.datacatalog.v1.DataCatalog.DeleteTag:output_type -> google.protobuf.Empty
	28, // 80: google.cloud.datacatalog.v1.DataCatalog.ListTags:output_type -> google.cloud.datacatalog.v1.ListTagsResponse
	47, // 81: google.cloud.datacatalog.v1.DataCatalog.SetIamPolicy:output_type -> google.iam.v1.Policy
	47, // 82: google.cloud.datacatalog.v1.DataCatalog.GetIamPolicy:output_type -> google.iam.v1.Policy
	48, // 83: google.cloud.datacatalog.v1.DataCatalog.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	57, // [57:84] is the sub-list for method output_type
	30, // [30:57] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_datacatalog_proto_init() }
func file_google_cloud_datacatalog_v1_datacatalog_proto_init() {
	if File_google_cloud_datacatalog_v1_datacatalog_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_common_proto_init()
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_init()
	file_google_cloud_datacatalog_v1_schema_proto_init()
	file_google_cloud_datacatalog_v1_search_proto_init()
	file_google_cloud_datacatalog_v1_table_spec_proto_init()
	file_google_cloud_datacatalog_v1_tags_proto_init()
	file_google_cloud_datacatalog_v1_timestamps_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogRequest_Scope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*Entry_Type)(nil),
		(*Entry_UserSpecifiedType)(nil),
		(*Entry_IntegratedSystem)(nil),
		(*Entry_UserSpecifiedSystem)(nil),
		(*Entry_GcsFilesetSpec)(nil),
		(*Entry_BigqueryTableSpec)(nil),
		(*Entry_BigqueryDateShardedSpec)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_datacatalog_proto = out.File
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
	// for more information.
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Creates an EntryGroup.
	//
	// An entry group contains logically related entries together with Cloud
	// Identity and Access Management policies that specify the users who can
	// create, edit, and view entries within the entry group.
	//
	// Data Catalog automatically creates an entry group for BigQuery entries
	// ("@bigquery") and Pub/Sub topics ("@pubsub"). Users create their own entry
	// group to contain Cloud Storage fileset entries or custom type entries,
	// and the IAM policies associated with those entries. Entry groups, like
	// entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Gets an EntryGroup.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists entry groups.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Lists entries.
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1.Entry].
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
	// for more information.
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Creates an EntryGroup.
	//
	// An entry group contains logically related entries together with Cloud
	// Identity and Access Management policies that specify the users who can
	// create, edit, and view entries within the entry group.
	//
	// Data Catalog automatically creates an entry group for BigQuery entries
	// ("@bigquery") and Pub/Sub topics ("@pubsub"). Users create their own entry
	// group to contain Cloud Storage fileset entries or custom type entries,
	// and the IAM policies associated with those entries. Entry groups, like
	// entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Gets an EntryGroup.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error)
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error)
	// Lists entry groups.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error)
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Lists entries.
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource
	// Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
	// for more information).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
	// more information).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1.Entry].
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedDataCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (*UnimplementedDataCatalogServer) SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (*UnimplementedDataCatalogServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (*UnimplementedDataCatalogServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (*UnimplementedDataCatalogServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _DataCatalog_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _DataCatalog_ListEntryGroups_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _DataCatalog_ListEntries_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/datacatalog.proto",
}
