// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

// Enum value maps for Feature.
var (
	Feature_name = map[int32]string{
		0: "FEATURE_UNSPECIFIED",
		1: "LABEL_DETECTION",
		2: "SHOT_CHANGE_DETECTION",
		3: "EXPLICIT_CONTENT_DETECTION",
		6: "SPEECH_TRANSCRIPTION",
	}
	Feature_value = map[string]int32{
		"FEATURE_UNSPECIFIED":        0,
		"LABEL_DETECTION":            1,
		"SHOT_CHANGE_DETECTION":      2,
		"EXPLICIT_CONTENT_DETECTION": 3,
		"SPEECH_TRANSCRIPTION":       6,
	}
)

func (x Feature) Enum() *Feature {
	p := new(Feature)
	*p = x
	return p
}

func (x Feature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Feature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[0].Descriptor()
}

func (Feature) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[0]
}

func (x Feature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Feature.Descriptor instead.
func (Feature) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

// Enum value maps for LabelDetectionMode.
var (
	LabelDetectionMode_name = map[int32]string{
		0: "LABEL_DETECTION_MODE_UNSPECIFIED",
		1: "SHOT_MODE",
		2: "FRAME_MODE",
		3: "SHOT_AND_FRAME_MODE",
	}
	LabelDetectionMode_value = map[string]int32{
		"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
		"SHOT_MODE":                        1,
		"FRAME_MODE":                       2,
		"SHOT_AND_FRAME_MODE":              3,
	}
)

func (x LabelDetectionMode) Enum() *LabelDetectionMode {
	p := new(LabelDetectionMode)
	*p = x
	return p
}

func (x LabelDetectionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelDetectionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[1].Descriptor()
}

func (LabelDetectionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[1]
}

func (x LabelDetectionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LabelDetectionMode.Descriptor instead.
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

// Enum value maps for Likelihood.
var (
	Likelihood_name = map[int32]string{
		0: "LIKELIHOOD_UNSPECIFIED",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	Likelihood_value = map[string]int32{
		"LIKELIHOOD_UNSPECIFIED": 0,
		"VERY_UNLIKELY":          1,
		"UNLIKELY":               2,
		"POSSIBLE":               3,
		"LIKELY":                 4,
		"VERY_LIKELY":            5,
	}
)

func (x Likelihood) Enum() *Likelihood {
	p := new(Likelihood)
	*p = x
	return p
}

func (x Likelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Likelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[2].Descriptor()
}

func (Likelihood) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes[2]
}

func (x Likelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Likelihood.Descriptor instead.
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *AnnotateVideoRequest) Reset() {
	*x = AnnotateVideoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoRequest) ProtoMessage() {}

func (x *AnnotateVideoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoRequest.ProtoReflect.Descriptor instead.
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{0}
}

func (x *AnnotateVideoRequest) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *AnnotateVideoRequest) GetInputContent() []byte {
	if x != nil {
		return x.InputContent
	}
	return nil
}

func (x *AnnotateVideoRequest) GetFeatures() []Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if x != nil {
		return x.VideoContext
	}
	return nil
}

func (x *AnnotateVideoRequest) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *AnnotateVideoRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
}

func (x *VideoContext) Reset() {
	*x = VideoContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoContext) ProtoMessage() {}

func (x *VideoContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoContext.ProtoReflect.Descriptor instead.
func (*VideoContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{1}
}

func (x *VideoContext) GetSegments() []*VideoSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if x != nil {
		return x.LabelDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if x != nil {
		return x.ShotChangeDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if x != nil {
		return x.ExplicitContentDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if x != nil {
		return x.SpeechTranscriptionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *LabelDetectionConfig) Reset() {
	*x = LabelDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelDetectionConfig) ProtoMessage() {}

func (x *LabelDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelDetectionConfig.ProtoReflect.Descriptor instead.
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{2}
}

func (x *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if x != nil {
		return x.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (x *LabelDetectionConfig) GetStationaryCamera() bool {
	if x != nil {
		return x.StationaryCamera
	}
	return false
}

func (x *LabelDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ShotChangeDetectionConfig) Reset() {
	*x = ShotChangeDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShotChangeDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShotChangeDetectionConfig) ProtoMessage() {}

func (x *ShotChangeDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShotChangeDetectionConfig.ProtoReflect.Descriptor instead.
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{3}
}

func (x *ShotChangeDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ExplicitContentDetectionConfig) Reset() {
	*x = ExplicitContentDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentDetectionConfig) ProtoMessage() {}

func (x *ExplicitContentDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentDetectionConfig.ProtoReflect.Descriptor instead.
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{4}
}

func (x *ExplicitContentDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *VideoSegment) Reset() {
	*x = VideoSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoSegment) ProtoMessage() {}

func (x *VideoSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoSegment.ProtoReflect.Descriptor instead.
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{5}
}

func (x *VideoSegment) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *VideoSegment) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *LabelSegment) Reset() {
	*x = LabelSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelSegment) ProtoMessage() {}

func (x *LabelSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelSegment.ProtoReflect.Descriptor instead.
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{6}
}

func (x *LabelSegment) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *LabelSegment) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *LabelFrame) Reset() {
	*x = LabelFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelFrame) ProtoMessage() {}

func (x *LabelFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelFrame.ProtoReflect.Descriptor instead.
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{7}
}

func (x *LabelFrame) GetTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *LabelFrame) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{8}
}

func (x *Entity) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *Entity) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Entity) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *LabelAnnotation) Reset() {
	*x = LabelAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelAnnotation) ProtoMessage() {}

func (x *LabelAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelAnnotation.ProtoReflect.Descriptor instead.
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{9}
}

func (x *LabelAnnotation) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *LabelAnnotation) GetCategoryEntities() []*Entity {
	if x != nil {
		return x.CategoryEntities
	}
	return nil
}

func (x *LabelAnnotation) GetSegments() []*LabelSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *LabelAnnotation) GetFrames() []*LabelFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p1beta1.Likelihood" json:"pornography_likelihood,omitempty"`
}

func (x *ExplicitContentFrame) Reset() {
	*x = ExplicitContentFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentFrame) ProtoMessage() {}

func (x *ExplicitContentFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentFrame.ProtoReflect.Descriptor instead.
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{10}
}

func (x *ExplicitContentFrame) GetTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if x != nil {
		return x.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All video frames where explicit content was detected.
	Frames []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *ExplicitContentAnnotation) Reset() {
	*x = ExplicitContentAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentAnnotation) ProtoMessage() {}

func (x *ExplicitContentAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentAnnotation.ProtoReflect.Descriptor instead.
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{11}
}

func (x *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// Output only. If set, indicates an error. Note that for a single
	// `AnnotateVideoRequest` some videos may succeed and some may fail.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *VideoAnnotationResults) Reset() {
	*x = VideoAnnotationResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoAnnotationResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoAnnotationResults) ProtoMessage() {}

func (x *VideoAnnotationResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoAnnotationResults.ProtoReflect.Descriptor instead.
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{12}
}

func (x *VideoAnnotationResults) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.SegmentLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.ShotLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.FrameLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if x != nil {
		return x.ShotAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if x != nil {
		return x.ExplicitAnnotation
	}
	return nil
}

func (x *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if x != nil {
		return x.SpeechTranscriptions
	}
	return nil
}

func (x *VideoAnnotationResults) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
}

func (x *AnnotateVideoResponse) Reset() {
	*x = AnnotateVideoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoResponse) ProtoMessage() {}

func (x *AnnotateVideoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoResponse.ProtoReflect.Descriptor instead.
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{13}
}

func (x *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if x != nil {
		return x.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Output only. Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Time when the request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time of the most recent update.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *VideoAnnotationProgress) Reset() {
	*x = VideoAnnotationProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoAnnotationProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoAnnotationProgress) ProtoMessage() {}

func (x *VideoAnnotationProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoAnnotationProgress.ProtoReflect.Descriptor instead.
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{14}
}

func (x *VideoAnnotationProgress) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *VideoAnnotationProgress) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *VideoAnnotationProgress) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *VideoAnnotationProgress) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
}

func (x *AnnotateVideoProgress) Reset() {
	*x = AnnotateVideoProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoProgress) ProtoMessage() {}

func (x *AnnotateVideoProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoProgress.ProtoReflect.Descriptor instead.
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{15}
}

func (x *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if x != nil {
		return x.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// Optional. If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// Optional. A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Optional. If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// Optional. For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
}

func (x *SpeechTranscriptionConfig) Reset() {
	*x = SpeechTranscriptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechTranscriptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechTranscriptionConfig) ProtoMessage() {}

func (x *SpeechTranscriptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechTranscriptionConfig.ProtoReflect.Descriptor instead.
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{16}
}

func (x *SpeechTranscriptionConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if x != nil {
		return x.MaxAlternatives
	}
	return 0
}

func (x *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if x != nil {
		return x.FilterProfanity
	}
	return false
}

func (x *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if x != nil {
		return x.SpeechContexts
	}
	return nil
}

func (x *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if x != nil {
		return x.EnableAutomaticPunctuation
	}
	return false
}

func (x *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if x != nil {
		return x.AudioTracks
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
}

func (x *SpeechContext) Reset() {
	*x = SpeechContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechContext) ProtoMessage() {}

func (x *SpeechContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechContext.ProtoReflect.Descriptor instead.
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{17}
}

func (x *SpeechContext) GetPhrases() []string {
	if x != nil {
		return x.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
}

func (x *SpeechTranscription) Reset() {
	*x = SpeechTranscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechTranscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechTranscription) ProtoMessage() {}

func (x *SpeechTranscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechTranscription.ProtoReflect.Descriptor instead.
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{18}
}

func (x *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *SpeechRecognitionAlternative) Reset() {
	*x = SpeechRecognitionAlternative{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechRecognitionAlternative) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionAlternative) ProtoMessage() {}

func (x *SpeechRecognitionAlternative) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionAlternative.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{19}
}

func (x *SpeechRecognitionAlternative) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *SpeechRecognitionAlternative) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if x != nil {
		return x.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *durationpb.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
}

func (x *WordInfo) Reset() {
	*x = WordInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordInfo) ProtoMessage() {}

func (x *WordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordInfo.ProtoReflect.Descriptor instead.
func (*WordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP(), []int{20}
}

func (x *WordInfo) GetStartTime() *durationpb.Duration {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *WordInfo) GetEndTime() *durationpb.Duration {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *WordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

var File_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto protoreflect.FileDescriptor

var file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd3, 0x02, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x52, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x55, 0x72, 0x69, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xfb, 0x04, 0x0a, 0x0c, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x52, 0x0a, 0x08, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x74, 0x0a, 0x16, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x14, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x84, 0x01, 0x0a, 0x1c, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x19, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x93, 0x01, 0x0a,
	0x21, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x83, 0x01, 0x0a, 0x1b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc9, 0x01, 0x0a, 0x14, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x6e, 0x0a, 0x14, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x12, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x61, 0x6d, 0x65, 0x72, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x61, 0x12, 0x14,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x22, 0x31, 0x0a, 0x19, 0x53, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x36, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0x98, 0x01, 0x0a, 0x0c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x80, 0x01, 0x0a, 0x0c, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x07, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x68, 0x0a,
	0x0a, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0b, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x6c, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xdc, 0x02, 0x0a, 0x0f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e,
	0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x5d, 0x0a, 0x11, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x10, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x52, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69,
	0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x22, 0xbf, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74,
	0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x6b, 0x0a, 0x16, 0x70, 0x6f, 0x72,
	0x6e, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e,
	0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52,
	0x15, 0x70, 0x6f, 0x72, 0x6e, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x4c, 0x69, 0x6b, 0x65,
	0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x22, 0x73, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x87, 0x06, 0x0a, 0x16,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x75, 0x0a, 0x19, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f, 0x0a, 0x16, 0x73, 0x68,
	0x6f, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x68, 0x6f, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x71, 0x0a, 0x17, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61,
	0x0a, 0x10, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0f, 0x73, 0x68, 0x6f, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x74, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x88, 0x01, 0x0a, 0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6f, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x11, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x22, 0xd9, 0x01, 0x0a, 0x17, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x8b, 0x01, 0x0a,
	0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x72, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xfb, 0x02, 0x0a, 0x19, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69,
	0x74, 0x79, 0x12, 0x65, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x1c, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x70, 0x75,
	0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x26, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x22, 0x2e, 0x0a, 0x0d, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6a, 0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c,
	0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x22, 0xad, 0x01, 0x0a,
	0x1c, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x23, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x22, 0x8e, 0x01, 0x0a,
	0x08, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x2a, 0x8c, 0x01,
	0x0a, 0x07, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x45, 0x41,
	0x54, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x48, 0x4f, 0x54, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x2a, 0x72, 0x0a, 0x12,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x48, 0x4f, 0x54,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52, 0x41, 0x4d, 0x45,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x48, 0x4f, 0x54, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x03,
	0x2a, 0x74, 0x0a, 0x0a, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x1a,
	0x0a, 0x16, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x49, 0x48, 0x4f, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45,
	0x52, 0x59, 0x5f, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50,
	0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49, 0x4b,
	0x45, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x49,
	0x4b, 0x45, 0x4c, 0x59, 0x10, 0x05, 0x32, 0xce, 0x02, 0x0a, 0x18, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x22, 0x1a, 0x2f, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x3a,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0xca, 0x41, 0x2e, 0x0a, 0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xae, 0x02, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x1d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65,
	0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0xaa, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69,
	0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x56, 0x31, 0x50, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x5c, 0x56, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescOnce sync.Once
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescData = file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDesc
)

func file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescGZIP() []byte {
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescOnce.Do(func() {
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescData)
	})
	return file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDescData
}

var file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_goTypes = []interface{}{
	(Feature)(0),                           // 0: google.cloud.videointelligence.v1p1beta1.Feature
	(LabelDetectionMode)(0),                // 1: google.cloud.videointelligence.v1p1beta1.LabelDetectionMode
	(Likelihood)(0),                        // 2: google.cloud.videointelligence.v1p1beta1.Likelihood
	(*AnnotateVideoRequest)(nil),           // 3: google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
	(*VideoContext)(nil),                   // 4: google.cloud.videointelligence.v1p1beta1.VideoContext
	(*LabelDetectionConfig)(nil),           // 5: google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig
	(*ShotChangeDetectionConfig)(nil),      // 6: google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig
	(*ExplicitContentDetectionConfig)(nil), // 7: google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig
	(*VideoSegment)(nil),                   // 8: google.cloud.videointelligence.v1p1beta1.VideoSegment
	(*LabelSegment)(nil),                   // 9: google.cloud.videointelligence.v1p1beta1.LabelSegment
	(*LabelFrame)(nil),                     // 10: google.cloud.videointelligence.v1p1beta1.LabelFrame
	(*Entity)(nil),                         // 11: google.cloud.videointelligence.v1p1beta1.Entity
	(*LabelAnnotation)(nil),                // 12: google.cloud.videointelligence.v1p1beta1.LabelAnnotation
	(*ExplicitContentFrame)(nil),           // 13: google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame
	(*ExplicitContentAnnotation)(nil),      // 14: google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation
	(*VideoAnnotationResults)(nil),         // 15: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults
	(*AnnotateVideoResponse)(nil),          // 16: google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse
	(*VideoAnnotationProgress)(nil),        // 17: google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress
	(*AnnotateVideoProgress)(nil),          // 18: google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress
	(*SpeechTranscriptionConfig)(nil),      // 19: google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig
	(*SpeechContext)(nil),                  // 20: google.cloud.videointelligence.v1p1beta1.SpeechContext
	(*SpeechTranscription)(nil),            // 21: google.cloud.videointelligence.v1p1beta1.SpeechTranscription
	(*SpeechRecognitionAlternative)(nil),   // 22: google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative
	(*WordInfo)(nil),                       // 23: google.cloud.videointelligence.v1p1beta1.WordInfo
	(*durationpb.Duration)(nil),            // 24: google.protobuf.Duration
	(*status.Status)(nil),                  // 25: google.rpc.Status
	(*timestamppb.Timestamp)(nil),          // 26: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),          // 27: google.longrunning.Operation
}
var file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_depIdxs = []int32{
	0,  // 0: google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.features:type_name -> google.cloud.videointelligence.v1p1beta1.Feature
	4,  // 1: google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.video_context:type_name -> google.cloud.videointelligence.v1p1beta1.VideoContext
	8,  // 2: google.cloud.videointelligence.v1p1beta1.VideoContext.segments:type_name -> google.cloud.videointelligence.v1p1beta1.VideoSegment
	5,  // 3: google.cloud.videointelligence.v1p1beta1.VideoContext.label_detection_config:type_name -> google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig
	6,  // 4: google.cloud.videointelligence.v1p1beta1.VideoContext.shot_change_detection_config:type_name -> google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig
	7,  // 5: google.cloud.videointelligence.v1p1beta1.VideoContext.explicit_content_detection_config:type_name -> google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig
	19, // 6: google.cloud.videointelligence.v1p1beta1.VideoContext.speech_transcription_config:type_name -> google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig
	1,  // 7: google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig.label_detection_mode:type_name -> google.cloud.videointelligence.v1p1beta1.LabelDetectionMode
	24, // 8: google.cloud.videointelligence.v1p1beta1.VideoSegment.start_time_offset:type_name -> google.protobuf.Duration
	24, // 9: google.cloud.videointelligence.v1p1beta1.VideoSegment.end_time_offset:type_name -> google.protobuf.Duration
	8,  // 10: google.cloud.videointelligence.v1p1beta1.LabelSegment.segment:type_name -> google.cloud.videointelligence.v1p1beta1.VideoSegment
	24, // 11: google.cloud.videointelligence.v1p1beta1.LabelFrame.time_offset:type_name -> google.protobuf.Duration
	11, // 12: google.cloud.videointelligence.v1p1beta1.LabelAnnotation.entity:type_name -> google.cloud.videointelligence.v1p1beta1.Entity
	11, // 13: google.cloud.videointelligence.v1p1beta1.LabelAnnotation.category_entities:type_name -> google.cloud.videointelligence.v1p1beta1.Entity
	9,  // 14: google.cloud.videointelligence.v1p1beta1.LabelAnnotation.segments:type_name -> google.cloud.videointelligence.v1p1beta1.LabelSegment
	10, // 15: google.cloud.videointelligence.v1p1beta1.LabelAnnotation.frames:type_name -> google.cloud.videointelligence.v1p1beta1.LabelFrame
	24, // 16: google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame.time_offset:type_name -> google.protobuf.Duration
	2,  // 17: google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame.pornography_likelihood:type_name -> google.cloud.videointelligence.v1p1beta1.Likelihood
	13, // 18: google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation.frames:type_name -> google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame
	12, // 19: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.segment_label_annotations:type_name -> google.cloud.videointelligence.v1p1beta1.LabelAnnotation
	12, // 20: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.shot_label_annotations:type_name -> google.cloud.videointelligence.v1p1beta1.LabelAnnotation
	12, // 21: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.frame_label_annotations:type_name -> google.cloud.videointelligence.v1p1beta1.LabelAnnotation
	8,  // 22: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.shot_annotations:type_name -> google.cloud.videointelligence.v1p1beta1.VideoSegment
	14, // 23: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.explicit_annotation:type_name -> google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation
	21, // 24: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.speech_transcriptions:type_name -> google.cloud.videointelligence.v1p1beta1.SpeechTranscription
	25, // 25: google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults.error:type_name -> google.rpc.Status
	15, // 26: google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse.annotation_results:type_name -> google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults
	26, // 27: google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress.start_time:type_name -> google.protobuf.Timestamp
	26, // 28: google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress.update_time:type_name -> google.protobuf.Timestamp
	17, // 29: google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress.annotation_progress:type_name -> google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress
	20, // 30: google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig.speech_contexts:type_name -> google.cloud.videointelligence.v1p1beta1.SpeechContext
	22, // 31: google.cloud.videointelligence.v1p1beta1.SpeechTranscription.alternatives:type_name -> google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative
	23, // 32: google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative.words:type_name -> google.cloud.videointelligence.v1p1beta1.WordInfo
	24, // 33: google.cloud.videointelligence.v1p1beta1.WordInfo.start_time:type_name -> google.protobuf.Duration
	24, // 34: google.cloud.videointelligence.v1p1beta1.WordInfo.end_time:type_name -> google.protobuf.Duration
	3,  // 35: google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService.AnnotateVideo:input_type -> google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
	27, // 36: google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService.AnnotateVideo:output_type -> google.longrunning.Operation
	36, // [36:37] is the sub-list for method output_type
	35, // [35:36] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_init() }
func file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_init() {
	if File_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShotChangeDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoAnnotationResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoAnnotationProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechTranscriptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechTranscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechRecognitionAlternative); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WordInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_goTypes,
		DependencyIndexes: file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_depIdxs,
		EnumInfos:         file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_enumTypes,
		MessageInfos:      file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_msgTypes,
	}.Build()
	File_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto = out.File
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_rawDesc = nil
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_goTypes = nil
	file_google_cloud_videointelligence_v1p1beta1_video_intelligence_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p1beta1/video_intelligence.proto",
}
