/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.translate.Formats;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.catalog.CatalogResolver;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Version;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Driver {
    private static final Localizer localizer = new Localizer(Driver.class);
    private String inputType;
    private String outputType;
    private final ErrorHandlerImpl eh;
    private static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;

    public Driver() {
        this(new ErrorHandlerImpl());
    }

    public Driver(ErrorHandlerImpl errorHandlerImpl) {
        this.eh = errorHandlerImpl;
    }

    public static void main(String[] stringArray) {
        System.exit(new Driver().run(stringArray));
    }

    public int run(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        try {
            SchemaCollection schemaCollection;
            Object object;
            CatalogResolver catalogResolver;
            OutputFormat outputFormat;
            InputFormat inputFormat;
            OptionParser optionParser = new OptionParser("C:I:O:i:o:", stringArray);
            try {
                while (optionParser.moveToNextOption()) {
                    switch (optionParser.getOptionChar()) {
                        case 'C': {
                            arrayList3.add(UriOrFile.toUri(optionParser.getOptionArg()));
                            break;
                        }
                        case 'I': {
                            this.inputType = optionParser.getOptionArg();
                            break;
                        }
                        case 'O': {
                            this.outputType = optionParser.getOptionArg();
                            break;
                        }
                        case 'i': {
                            arrayList.add(optionParser.getOptionArg());
                            break;
                        }
                        case 'o': {
                            arrayList2.add(optionParser.getOptionArg());
                        }
                    }
                }
            }
            catch (OptionParser.InvalidOptionException invalidOptionException) {
                this.error(localizer.message("invalid_option", optionParser.getOptionCharString()));
                return 2;
            }
            catch (OptionParser.MissingArgumentException missingArgumentException) {
                this.error(localizer.message("option_missing_argument", optionParser.getOptionCharString()));
                return 2;
            }
            stringArray = optionParser.getRemainingArgs();
            if (stringArray.length < 2) {
                this.error(localizer.message("too_few_arguments"));
                this.eh.print(localizer.message("usage", Version.getVersion(Driver.class)));
                return 2;
            }
            if (this.inputType == null) {
                this.inputType = Driver.extension(stringArray[0]);
                if (this.inputType.length() > 0) {
                    this.inputType = this.inputType.substring(1);
                }
            }
            if ((inputFormat = Formats.createInputFormat(this.inputType)) == null) {
                this.error(localizer.message("unrecognized_input_type", this.inputType));
                return 2;
            }
            String string = Driver.extension(stringArray[stringArray.length - 1]);
            if (this.outputType == null) {
                this.outputType = string;
                if (this.outputType.length() > 0) {
                    this.outputType = this.outputType.substring(1);
                }
            }
            if ((outputFormat = Formats.createOutputFormat(this.outputType)) == null) {
                this.error(localizer.message("unrecognized_output_type", this.outputType));
                return 2;
            }
            if (arrayList3.isEmpty()) {
                catalogResolver = null;
            } else {
                try {
                    catalogResolver = new CatalogResolver(arrayList3);
                }
                catch (LinkageError linkageError) {
                    this.eh.print(localizer.message("resolver_not_found"));
                    return 2;
                }
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            this.outputType = this.outputType.toLowerCase();
            if (stringArray.length > 2) {
                if (!(inputFormat instanceof MultiInputFormat)) {
                    this.error(localizer.message("too_many_arguments"));
                    return 2;
                }
                object = new String[stringArray.length - 1];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = UriOrFile.toUri(stringArray[i]);
                }
                schemaCollection = ((MultiInputFormat)inputFormat).load((String[])object, stringArray2, this.outputType, (ErrorHandler)this.eh, (Resolver)catalogResolver);
            } else {
                schemaCollection = inputFormat.load(UriOrFile.toUri(stringArray[0]), stringArray2, this.outputType, this.eh, catalogResolver);
            }
            if (string.length() == 0) {
                string = this.outputType;
            }
            object = new LocalOutputDirectory(schemaCollection.getMainUri(), new File(stringArray[stringArray.length - 1]), string, DEFAULT_OUTPUT_ENCODING, 72, 2);
            outputFormat.output(schemaCollection, (OutputDirectory)object, arrayList2.toArray(new String[arrayList2.size()]), this.inputType.toLowerCase(), this.eh);
            return 0;
        }
        catch (OutputFailedException outputFailedException) {
        }
        catch (InputFailedException inputFailedException) {
        }
        catch (InvalidParamsException invalidParamsException) {
        }
        catch (IOException iOException) {
            this.eh.printException(iOException);
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return 1;
    }

    private void error(String string) {
        this.eh.printException(new SAXException(string));
    }

    private static String extension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(n);
    }
}

