//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// A mapping of plane flight modes for custom_mode field of heartbeat.
type PLANE_MODE uint64

const (
	// MANUAL
	PLANE_MODE_MANUAL PLANE_MODE = 0
	// CIRCLE
	PLANE_MODE_CIRCLE PLANE_MODE = 1
	// STABILIZE
	PLANE_MODE_STABILIZE PLANE_MODE = 2
	// TRAINING
	PLANE_MODE_TRAINING PLANE_MODE = 3
	// ACRO
	PLANE_MODE_ACRO PLANE_MODE = 4
	// FBWA
	PLANE_MODE_FLY_BY_WIRE_A PLANE_MODE = 5
	// FBWB
	PLANE_MODE_FLY_BY_WIRE_B PLANE_MODE = 6
	// CRUISE
	PLANE_MODE_CRUISE PLANE_MODE = 7
	// AUTOTUNE
	PLANE_MODE_AUTOTUNE PLANE_MODE = 8
	// AUTO
	PLANE_MODE_AUTO PLANE_MODE = 10
	// RTL
	PLANE_MODE_RTL PLANE_MODE = 11
	// LOITER
	PLANE_MODE_LOITER PLANE_MODE = 12
	// TAKEOFF
	PLANE_MODE_TAKEOFF PLANE_MODE = 13
	// AVOID ADSB
	PLANE_MODE_AVOID_ADSB PLANE_MODE = 14
	// GUIDED
	PLANE_MODE_GUIDED PLANE_MODE = 15
	// INITIALISING
	PLANE_MODE_INITIALIZING PLANE_MODE = 16
	// QSTABILIZE
	PLANE_MODE_QSTABILIZE PLANE_MODE = 17
	// QHOVER
	PLANE_MODE_QHOVER PLANE_MODE = 18
	// QLOITER
	PLANE_MODE_QLOITER PLANE_MODE = 19
	// QLAND
	PLANE_MODE_QLAND PLANE_MODE = 20
	// QRTL
	PLANE_MODE_QRTL PLANE_MODE = 21
	// QAUTOTUNE
	PLANE_MODE_QAUTOTUNE PLANE_MODE = 22
	// QACRO
	PLANE_MODE_QACRO PLANE_MODE = 23
	// THERMAL
	PLANE_MODE_THERMAL PLANE_MODE = 24
	// LOITER2QLAND
	PLANE_MODE_LOITER_ALT_QLAND PLANE_MODE = 25
	// AUTOLAND
	PLANE_MODE_AUTOLAND PLANE_MODE = 26
)

var value_to_label_PLANE_MODE = map[PLANE_MODE]string{
	PLANE_MODE_MANUAL:           "PLANE_MODE_MANUAL",
	PLANE_MODE_CIRCLE:           "PLANE_MODE_CIRCLE",
	PLANE_MODE_STABILIZE:        "PLANE_MODE_STABILIZE",
	PLANE_MODE_TRAINING:         "PLANE_MODE_TRAINING",
	PLANE_MODE_ACRO:             "PLANE_MODE_ACRO",
	PLANE_MODE_FLY_BY_WIRE_A:    "PLANE_MODE_FLY_BY_WIRE_A",
	PLANE_MODE_FLY_BY_WIRE_B:    "PLANE_MODE_FLY_BY_WIRE_B",
	PLANE_MODE_CRUISE:           "PLANE_MODE_CRUISE",
	PLANE_MODE_AUTOTUNE:         "PLANE_MODE_AUTOTUNE",
	PLANE_MODE_AUTO:             "PLANE_MODE_AUTO",
	PLANE_MODE_RTL:              "PLANE_MODE_RTL",
	PLANE_MODE_LOITER:           "PLANE_MODE_LOITER",
	PLANE_MODE_TAKEOFF:          "PLANE_MODE_TAKEOFF",
	PLANE_MODE_AVOID_ADSB:       "PLANE_MODE_AVOID_ADSB",
	PLANE_MODE_GUIDED:           "PLANE_MODE_GUIDED",
	PLANE_MODE_INITIALIZING:     "PLANE_MODE_INITIALIZING",
	PLANE_MODE_QSTABILIZE:       "PLANE_MODE_QSTABILIZE",
	PLANE_MODE_QHOVER:           "PLANE_MODE_QHOVER",
	PLANE_MODE_QLOITER:          "PLANE_MODE_QLOITER",
	PLANE_MODE_QLAND:            "PLANE_MODE_QLAND",
	PLANE_MODE_QRTL:             "PLANE_MODE_QRTL",
	PLANE_MODE_QAUTOTUNE:        "PLANE_MODE_QAUTOTUNE",
	PLANE_MODE_QACRO:            "PLANE_MODE_QACRO",
	PLANE_MODE_THERMAL:          "PLANE_MODE_THERMAL",
	PLANE_MODE_LOITER_ALT_QLAND: "PLANE_MODE_LOITER_ALT_QLAND",
	PLANE_MODE_AUTOLAND:         "PLANE_MODE_AUTOLAND",
}

var label_to_value_PLANE_MODE = map[string]PLANE_MODE{
	"PLANE_MODE_MANUAL":           PLANE_MODE_MANUAL,
	"PLANE_MODE_CIRCLE":           PLANE_MODE_CIRCLE,
	"PLANE_MODE_STABILIZE":        PLANE_MODE_STABILIZE,
	"PLANE_MODE_TRAINING":         PLANE_MODE_TRAINING,
	"PLANE_MODE_ACRO":             PLANE_MODE_ACRO,
	"PLANE_MODE_FLY_BY_WIRE_A":    PLANE_MODE_FLY_BY_WIRE_A,
	"PLANE_MODE_FLY_BY_WIRE_B":    PLANE_MODE_FLY_BY_WIRE_B,
	"PLANE_MODE_CRUISE":           PLANE_MODE_CRUISE,
	"PLANE_MODE_AUTOTUNE":         PLANE_MODE_AUTOTUNE,
	"PLANE_MODE_AUTO":             PLANE_MODE_AUTO,
	"PLANE_MODE_RTL":              PLANE_MODE_RTL,
	"PLANE_MODE_LOITER":           PLANE_MODE_LOITER,
	"PLANE_MODE_TAKEOFF":          PLANE_MODE_TAKEOFF,
	"PLANE_MODE_AVOID_ADSB":       PLANE_MODE_AVOID_ADSB,
	"PLANE_MODE_GUIDED":           PLANE_MODE_GUIDED,
	"PLANE_MODE_INITIALIZING":     PLANE_MODE_INITIALIZING,
	"PLANE_MODE_QSTABILIZE":       PLANE_MODE_QSTABILIZE,
	"PLANE_MODE_QHOVER":           PLANE_MODE_QHOVER,
	"PLANE_MODE_QLOITER":          PLANE_MODE_QLOITER,
	"PLANE_MODE_QLAND":            PLANE_MODE_QLAND,
	"PLANE_MODE_QRTL":             PLANE_MODE_QRTL,
	"PLANE_MODE_QAUTOTUNE":        PLANE_MODE_QAUTOTUNE,
	"PLANE_MODE_QACRO":            PLANE_MODE_QACRO,
	"PLANE_MODE_THERMAL":          PLANE_MODE_THERMAL,
	"PLANE_MODE_LOITER_ALT_QLAND": PLANE_MODE_LOITER_ALT_QLAND,
	"PLANE_MODE_AUTOLAND":         PLANE_MODE_AUTOLAND,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e PLANE_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_PLANE_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *PLANE_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_PLANE_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = PLANE_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e PLANE_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
