/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.contentfiltering;

import com.ubnt.data.Site;
import com.ubnt.model.api.contentfiltering.ContentFilteringDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.contentfiltering.ContentFilteringDocument;
import com.ubnt.service.contentfiltering.E;
import com.ubnt.service.contentfiltering.new;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@V2RestController
@Tag(name="Content Filtering")
public class ContentFilteringController {
    private final E o00000;

    @GetMapping(value={"/api/site/{siteName}/content-filtering"})
    @Operation(summary="Get all Content Filtering rules")
    public List<ContentFilteringDto> getContentFilteringRules(@PathVariable(value="siteName") Site site) {
        return this.o00000.if(site.getId()).stream().map(ContentFilteringDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/content-filtering/bulk"})
    @Operation(summary="Update all Simple App Blocking rules")
    public List<ContentFilteringDto> updateContentFilteringRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid List<ContentFilteringDto> list) {
        List<ContentFilteringDocument> list2 = list.stream().map(contentFilteringDto -> contentFilteringDto.toDocument(site.getId())).toList();
        return this.o00000.thissuper(site.getId(), list2).stream().map(ContentFilteringDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/content-filtering/create"})
    @Operation(summary="Create Content Filtering Rule")
    public ContentFilteringDto createContentFilteringRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid ContentFilteringDto contentFilteringDto) {
        return ContentFilteringDto.ofDocument(this.o00000.\u00d500000(site.getId(), contentFilteringDto));
    }

    @PutMapping(value={"/api/site/{siteName}/content-filtering/{id}"})
    @Operation(summary="Update Content Filtering Rule")
    public ContentFilteringDto updateContentFilteringRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid ContentFilteringDto contentFilteringDto) {
        return ContentFilteringDto.ofDocument(this.o00000.\u00d8O0000(site.getId(), string, contentFilteringDto));
    }

    @DeleteMapping(value={"/api/site/{siteName}/content-filtering/{id}"})
    @Operation(summary="Delete Content Filtering Rule")
    public void deleteContentFilteringRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.forsuper(string);
    }

    @GetMapping(value={"/api/site/{siteName}/content-filtering/categories"})
    @Operation(summary="Get all Content Filtering categories")
    public List<new> getContentFilteringCategories(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00f5o0000();
    }

    @ConstructorProperties(value={"service"})
    @Generated
    public ContentFilteringController(E e2) {
        this.o00000 = e2;
    }
}

