/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.systemlog.trigger;

import com.ubnt.ace.D;
import com.ubnt.data.Site;
import com.ubnt.model.api.host.HostFingerprintDto;
import com.ubnt.model.api.systemlog.trigger.TriggerLogDto;
import com.ubnt.model.api.systemlog.trigger.TriggerLogListDto;
import com.ubnt.model.api.systemlog.trigger.TriggerLogListParameterDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.systemlog.trigger.F;
import com.ubnt.service.systemlog.trigger.TriggerLogDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Trigger Log")
public class TriggerLogController {
    private final F super;

    public TriggerLogController(F f2) {
        this.super = f2;
    }

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/system-log/triggers"})
    @Operation(summary="List all Triggers")
    public TriggerLogListDto listTriggerLogs(@PathVariable(value="siteName") Site site, @RequestBody @Valid TriggerLogListParameterDto triggerLogListParameterDto) {
        return this.super(site, triggerLogListParameterDto);
    }

    @GetMapping(value={"/api/site/{siteName}/system-log/triggers/display-options/hosts"})
    @Operation(summary="List all host fingerprints")
    public List<HostFingerprintDto> listAllSourceHostFingerprints(@PathVariable(value="siteName") Site site) {
        return D.public(this.super.new(site.getId()), HostFingerprintDto::of);
    }

    private TriggerLogListDto super(Site site, TriggerLogListParameterDto triggerLogListParameterDto) {
        Page<TriggerLogDocument> page = this.super.\u00d300000(triggerLogListParameterDto.toSearchParameters(site.getId()));
        return TriggerLogListDto.builder().totalPageCount(page.getTotalPages()).totalElementCount(page.getTotalElements()).pageNumber(page.getNumber()).data(D.public(page.getContent(), TriggerLogDto::fromDocument)).build();
    }
}

