/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.Metadata;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.Plugin;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.Snapshot;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.Versioning;
import org.jetbrains.kotlin.org.codehaus.plexus.util.ReaderFactory;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.MXParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MetadataXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public MetadataXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public MetadataXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Metadata read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public Metadata read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    private Metadata parseMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Metadata metadata = new Metadata();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("modelVersion".equals(name)) {
                metadata.setModelVersion(this.interpolatedTrimmed(value, "modelVersion"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                metadata.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                metadata.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                metadata.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versioning", null, parsed)) {
                metadata.setVersioning(this.parseVersioning(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                metadata.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return metadata;
    }

    private Plugin parsePlugin(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Plugin plugin = new Plugin();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                plugin.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "prefix", null, parsed)) {
                plugin.setPrefix(this.interpolatedTrimmed(parser.nextText(), "prefix"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                plugin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return plugin;
    }

    private Snapshot parseSnapshot(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Snapshot snapshot = new Snapshot();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "timestamp", null, parsed)) {
                snapshot.setTimestamp(this.interpolatedTrimmed(parser.nextText(), "timestamp"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "buildNumber", null, parsed)) {
                snapshot.setBuildNumber(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "buildNumber"), "buildNumber", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "localCopy", null, parsed)) {
                snapshot.setLocalCopy(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "localCopy"), "localCopy", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return snapshot;
    }

    private SnapshotVersion parseSnapshotVersion(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        SnapshotVersion snapshotVersion = new SnapshotVersion();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                snapshotVersion.setClassifier(this.interpolatedTrimmed(parser.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extension", null, parsed)) {
                snapshotVersion.setExtension(this.interpolatedTrimmed(parser.nextText(), "extension"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                snapshotVersion.setVersion(this.interpolatedTrimmed(parser.nextText(), "value"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updated", null, parsed)) {
                snapshotVersion.setUpdated(this.interpolatedTrimmed(parser.nextText(), "updated"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return snapshotVersion;
    }

    private Versioning parseVersioning(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Versioning versioning = new Versioning();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "latest", null, parsed)) {
                versioning.setLatest(this.interpolatedTrimmed(parser.nextText(), "latest"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "release", null, parsed)) {
                versioning.setRelease(this.interpolatedTrimmed(parser.nextText(), "release"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshot", null, parsed)) {
                versioning.setSnapshot(this.parseSnapshot(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versions", null, parsed)) {
                ArrayList<String> versions = new ArrayList<String>();
                versioning.setVersions(versions);
                while (parser.nextTag() == 2) {
                    if ("version".equals(parser.getName())) {
                        versions.add(this.interpolatedTrimmed(parser.nextText(), "versions"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastUpdated", null, parsed)) {
                versioning.setLastUpdated(this.interpolatedTrimmed(parser.nextText(), "lastUpdated"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshotVersions", null, parsed)) {
                ArrayList<SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();
                versioning.setSnapshotVersions(snapshotVersions);
                while (parser.nextTag() == 2) {
                    if ("snapshotVersion".equals(parser.getName())) {
                        snapshotVersions.add(this.parseSnapshotVersion(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return versioning;
    }

    private Metadata read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Metadata metadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"metadata".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'metadata' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'metadata'", parser, null);
                }
                metadata = this.parseMetadata(parser, strict);
                metadata.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return metadata;
        }
        throw new XmlPullParserException("Expected root element 'metadata' but found no element at all: invalid XML document", parser, null);
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

