// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/dataflow/v1beta3/jobs.proto

package dataflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	JobsV1Beta3_CreateJob_FullMethodName          = "/google.dataflow.v1beta3.JobsV1Beta3/CreateJob"
	JobsV1Beta3_GetJob_FullMethodName             = "/google.dataflow.v1beta3.JobsV1Beta3/GetJob"
	JobsV1Beta3_UpdateJob_FullMethodName          = "/google.dataflow.v1beta3.JobsV1Beta3/UpdateJob"
	JobsV1Beta3_ListJobs_FullMethodName           = "/google.dataflow.v1beta3.JobsV1Beta3/ListJobs"
	JobsV1Beta3_AggregatedListJobs_FullMethodName = "/google.dataflow.v1beta3.JobsV1Beta3/AggregatedListJobs"
	JobsV1Beta3_CheckActiveJobs_FullMethodName    = "/google.dataflow.v1beta3.JobsV1Beta3/CheckActiveJobs"
	JobsV1Beta3_SnapshotJob_FullMethodName        = "/google.dataflow.v1beta3.JobsV1Beta3/SnapshotJob"
)

// JobsV1Beta3Client is the client API for JobsV1Beta3 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JobsV1Beta3Client interface {
	// Creates a Cloud Dataflow job.
	//
	// To create a job, we recommend using `projects.locations.jobs.create` with a
	// [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.create` is not recommended, as your job will always start
	// in `us-central1`.
	//
	// Do not enter confidential information when you supply string values using
	// the API.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Gets the state of the specified Cloud Dataflow job.
	//
	// To get the state of a job, we recommend using `projects.locations.jobs.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.get` is not recommended, as you can only get the state of
	// jobs that are running in `us-central1`.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates the state of an existing Cloud Dataflow job.
	//
	// To update the state of an existing job, we recommend using
	// `projects.locations.jobs.update` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.update` is not recommended, as you can only update the state
	// of jobs that are running in `us-central1`.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// List the jobs of a project.
	//
	// To list the jobs of a project in a region, we recommend using
	// `projects.locations.jobs.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
	// list the all jobs across all regions, use `projects.jobs.aggregated`. Using
	// `projects.jobs.list` is not recommended, because you can only get the list
	// of jobs that are running in `us-central1`.
	//
	// `projects.locations.jobs.list` and `projects.jobs.list` support filtering
	// the list of jobs by name. Filtering by name isn't supported by
	// `projects.jobs.aggregated`.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// List the jobs of a project across all regions.
	//
	// **Note:** This method doesn't support filtering the list of
	// jobs by name.
	AggregatedListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Check for existence of active jobs in the given project across all regions.
	CheckActiveJobs(ctx context.Context, in *CheckActiveJobsRequest, opts ...grpc.CallOption) (*CheckActiveJobsResponse, error)
	// Snapshot the state of a streaming job.
	SnapshotJob(ctx context.Context, in *SnapshotJobRequest, opts ...grpc.CallOption) (*Snapshot, error)
}

type jobsV1Beta3Client struct {
	cc grpc.ClientConnInterface
}

func NewJobsV1Beta3Client(cc grpc.ClientConnInterface) JobsV1Beta3Client {
	return &jobsV1Beta3Client{cc}
}

func (c *jobsV1Beta3Client) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobsV1Beta3_CreateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobsV1Beta3_GetJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobsV1Beta3_UpdateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, JobsV1Beta3_ListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) AggregatedListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, JobsV1Beta3_AggregatedListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) CheckActiveJobs(ctx context.Context, in *CheckActiveJobsRequest, opts ...grpc.CallOption) (*CheckActiveJobsResponse, error) {
	out := new(CheckActiveJobsResponse)
	err := c.cc.Invoke(ctx, JobsV1Beta3_CheckActiveJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobsV1Beta3Client) SnapshotJob(ctx context.Context, in *SnapshotJobRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, JobsV1Beta3_SnapshotJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobsV1Beta3Server is the server API for JobsV1Beta3 service.
// All implementations should embed UnimplementedJobsV1Beta3Server
// for forward compatibility
type JobsV1Beta3Server interface {
	// Creates a Cloud Dataflow job.
	//
	// To create a job, we recommend using `projects.locations.jobs.create` with a
	// [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.create` is not recommended, as your job will always start
	// in `us-central1`.
	//
	// Do not enter confidential information when you supply string values using
	// the API.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Gets the state of the specified Cloud Dataflow job.
	//
	// To get the state of a job, we recommend using `projects.locations.jobs.get`
	// with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.get` is not recommended, as you can only get the state of
	// jobs that are running in `us-central1`.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates the state of an existing Cloud Dataflow job.
	//
	// To update the state of an existing job, we recommend using
	// `projects.locations.jobs.update` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.update` is not recommended, as you can only update the state
	// of jobs that are running in `us-central1`.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// List the jobs of a project.
	//
	// To list the jobs of a project in a region, we recommend using
	// `projects.locations.jobs.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
	// list the all jobs across all regions, use `projects.jobs.aggregated`. Using
	// `projects.jobs.list` is not recommended, because you can only get the list
	// of jobs that are running in `us-central1`.
	//
	// `projects.locations.jobs.list` and `projects.jobs.list` support filtering
	// the list of jobs by name. Filtering by name isn't supported by
	// `projects.jobs.aggregated`.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// List the jobs of a project across all regions.
	//
	// **Note:** This method doesn't support filtering the list of
	// jobs by name.
	AggregatedListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Check for existence of active jobs in the given project across all regions.
	CheckActiveJobs(context.Context, *CheckActiveJobsRequest) (*CheckActiveJobsResponse, error)
	// Snapshot the state of a streaming job.
	SnapshotJob(context.Context, *SnapshotJobRequest) (*Snapshot, error)
}

// UnimplementedJobsV1Beta3Server should be embedded to have forward compatible implementations.
type UnimplementedJobsV1Beta3Server struct {
}

func (UnimplementedJobsV1Beta3Server) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (UnimplementedJobsV1Beta3Server) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedJobsV1Beta3Server) UpdateJob(context.Context, *UpdateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (UnimplementedJobsV1Beta3Server) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedJobsV1Beta3Server) AggregatedListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedListJobs not implemented")
}
func (UnimplementedJobsV1Beta3Server) CheckActiveJobs(context.Context, *CheckActiveJobsRequest) (*CheckActiveJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckActiveJobs not implemented")
}
func (UnimplementedJobsV1Beta3Server) SnapshotJob(context.Context, *SnapshotJobRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SnapshotJob not implemented")
}

// UnsafeJobsV1Beta3Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JobsV1Beta3Server will
// result in compilation errors.
type UnsafeJobsV1Beta3Server interface {
	mustEmbedUnimplementedJobsV1Beta3Server()
}

func RegisterJobsV1Beta3Server(s grpc.ServiceRegistrar, srv JobsV1Beta3Server) {
	s.RegisterService(&JobsV1Beta3_ServiceDesc, srv)
}

func _JobsV1Beta3_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_CreateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_GetJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_UpdateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_ListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_AggregatedListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).AggregatedListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_AggregatedListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).AggregatedListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_CheckActiveJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckActiveJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).CheckActiveJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_CheckActiveJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).CheckActiveJobs(ctx, req.(*CheckActiveJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobsV1Beta3_SnapshotJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobsV1Beta3Server).SnapshotJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobsV1Beta3_SnapshotJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobsV1Beta3Server).SnapshotJob(ctx, req.(*SnapshotJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// JobsV1Beta3_ServiceDesc is the grpc.ServiceDesc for JobsV1Beta3 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var JobsV1Beta3_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.JobsV1Beta3",
	HandlerType: (*JobsV1Beta3Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobsV1Beta3_CreateJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobsV1Beta3_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobsV1Beta3_UpdateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobsV1Beta3_ListJobs_Handler,
		},
		{
			MethodName: "AggregatedListJobs",
			Handler:    _JobsV1Beta3_AggregatedListJobs_Handler,
		},
		{
			MethodName: "CheckActiveJobs",
			Handler:    _JobsV1Beta3_CheckActiveJobs_Handler,
		},
		{
			MethodName: "SnapshotJob",
			Handler:    _JobsV1Beta3_SnapshotJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/jobs.proto",
}
