// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2/generative_question_service.proto

package retailpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_FullMethodName = "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionsFeatureConfig"
	GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_FullMethodName    = "/google.cloud.retail.v2.GenerativeQuestionService/GetGenerativeQuestionsFeatureConfig"
	GenerativeQuestionService_ListGenerativeQuestionConfigs_FullMethodName          = "/google.cloud.retail.v2.GenerativeQuestionService/ListGenerativeQuestionConfigs"
	GenerativeQuestionService_UpdateGenerativeQuestionConfig_FullMethodName         = "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionConfig"
	GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_FullMethodName   = "/google.cloud.retail.v2.GenerativeQuestionService/BatchUpdateGenerativeQuestionConfigs"
)

// GenerativeQuestionServiceClient is the client API for GenerativeQuestionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GenerativeQuestionServiceClient interface {
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	UpdateGenerativeQuestionsFeatureConfig(ctx context.Context, in *UpdateGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error)
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	GetGenerativeQuestionsFeatureConfig(ctx context.Context, in *GetGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error)
	// Returns all questions for a given catalog.
	ListGenerativeQuestionConfigs(ctx context.Context, in *ListGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*ListGenerativeQuestionConfigsResponse, error)
	// Allows management of individual questions.
	UpdateGenerativeQuestionConfig(ctx context.Context, in *UpdateGenerativeQuestionConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionConfig, error)
	// Allows management of multiple questions.
	BatchUpdateGenerativeQuestionConfigs(ctx context.Context, in *BatchUpdateGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*BatchUpdateGenerativeQuestionConfigsResponse, error)
}

type generativeQuestionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGenerativeQuestionServiceClient(cc grpc.ClientConnInterface) GenerativeQuestionServiceClient {
	return &generativeQuestionServiceClient{cc}
}

func (c *generativeQuestionServiceClient) UpdateGenerativeQuestionsFeatureConfig(ctx context.Context, in *UpdateGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error) {
	out := new(GenerativeQuestionsFeatureConfig)
	err := c.cc.Invoke(ctx, GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) GetGenerativeQuestionsFeatureConfig(ctx context.Context, in *GetGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error) {
	out := new(GenerativeQuestionsFeatureConfig)
	err := c.cc.Invoke(ctx, GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) ListGenerativeQuestionConfigs(ctx context.Context, in *ListGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*ListGenerativeQuestionConfigsResponse, error) {
	out := new(ListGenerativeQuestionConfigsResponse)
	err := c.cc.Invoke(ctx, GenerativeQuestionService_ListGenerativeQuestionConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) UpdateGenerativeQuestionConfig(ctx context.Context, in *UpdateGenerativeQuestionConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionConfig, error) {
	out := new(GenerativeQuestionConfig)
	err := c.cc.Invoke(ctx, GenerativeQuestionService_UpdateGenerativeQuestionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) BatchUpdateGenerativeQuestionConfigs(ctx context.Context, in *BatchUpdateGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*BatchUpdateGenerativeQuestionConfigsResponse, error) {
	out := new(BatchUpdateGenerativeQuestionConfigsResponse)
	err := c.cc.Invoke(ctx, GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GenerativeQuestionServiceServer is the server API for GenerativeQuestionService service.
// All implementations should embed UnimplementedGenerativeQuestionServiceServer
// for forward compatibility
type GenerativeQuestionServiceServer interface {
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	UpdateGenerativeQuestionsFeatureConfig(context.Context, *UpdateGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error)
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	GetGenerativeQuestionsFeatureConfig(context.Context, *GetGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error)
	// Returns all questions for a given catalog.
	ListGenerativeQuestionConfigs(context.Context, *ListGenerativeQuestionConfigsRequest) (*ListGenerativeQuestionConfigsResponse, error)
	// Allows management of individual questions.
	UpdateGenerativeQuestionConfig(context.Context, *UpdateGenerativeQuestionConfigRequest) (*GenerativeQuestionConfig, error)
	// Allows management of multiple questions.
	BatchUpdateGenerativeQuestionConfigs(context.Context, *BatchUpdateGenerativeQuestionConfigsRequest) (*BatchUpdateGenerativeQuestionConfigsResponse, error)
}

// UnimplementedGenerativeQuestionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedGenerativeQuestionServiceServer struct {
}

func (UnimplementedGenerativeQuestionServiceServer) UpdateGenerativeQuestionsFeatureConfig(context.Context, *UpdateGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerativeQuestionsFeatureConfig not implemented")
}
func (UnimplementedGenerativeQuestionServiceServer) GetGenerativeQuestionsFeatureConfig(context.Context, *GetGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGenerativeQuestionsFeatureConfig not implemented")
}
func (UnimplementedGenerativeQuestionServiceServer) ListGenerativeQuestionConfigs(context.Context, *ListGenerativeQuestionConfigsRequest) (*ListGenerativeQuestionConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGenerativeQuestionConfigs not implemented")
}
func (UnimplementedGenerativeQuestionServiceServer) UpdateGenerativeQuestionConfig(context.Context, *UpdateGenerativeQuestionConfigRequest) (*GenerativeQuestionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerativeQuestionConfig not implemented")
}
func (UnimplementedGenerativeQuestionServiceServer) BatchUpdateGenerativeQuestionConfigs(context.Context, *BatchUpdateGenerativeQuestionConfigsRequest) (*BatchUpdateGenerativeQuestionConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateGenerativeQuestionConfigs not implemented")
}

// UnsafeGenerativeQuestionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GenerativeQuestionServiceServer will
// result in compilation errors.
type UnsafeGenerativeQuestionServiceServer interface {
	mustEmbedUnimplementedGenerativeQuestionServiceServer()
}

func RegisterGenerativeQuestionServiceServer(s grpc.ServiceRegistrar, srv GenerativeQuestionServiceServer) {
	s.RegisterService(&GenerativeQuestionService_ServiceDesc, srv)
}

func _GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGenerativeQuestionsFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionsFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionsFeatureConfig(ctx, req.(*UpdateGenerativeQuestionsFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGenerativeQuestionsFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).GetGenerativeQuestionsFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).GetGenerativeQuestionsFeatureConfig(ctx, req.(*GetGenerativeQuestionsFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_ListGenerativeQuestionConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGenerativeQuestionConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).ListGenerativeQuestionConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeQuestionService_ListGenerativeQuestionConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).ListGenerativeQuestionConfigs(ctx, req.(*ListGenerativeQuestionConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_UpdateGenerativeQuestionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGenerativeQuestionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeQuestionService_UpdateGenerativeQuestionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionConfig(ctx, req.(*UpdateGenerativeQuestionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateGenerativeQuestionConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).BatchUpdateGenerativeQuestionConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).BatchUpdateGenerativeQuestionConfigs(ctx, req.(*BatchUpdateGenerativeQuestionConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GenerativeQuestionService_ServiceDesc is the grpc.ServiceDesc for GenerativeQuestionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GenerativeQuestionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2.GenerativeQuestionService",
	HandlerType: (*GenerativeQuestionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateGenerativeQuestionsFeatureConfig",
			Handler:    _GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_Handler,
		},
		{
			MethodName: "GetGenerativeQuestionsFeatureConfig",
			Handler:    _GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_Handler,
		},
		{
			MethodName: "ListGenerativeQuestionConfigs",
			Handler:    _GenerativeQuestionService_ListGenerativeQuestionConfigs_Handler,
		},
		{
			MethodName: "UpdateGenerativeQuestionConfig",
			Handler:    _GenerativeQuestionService_UpdateGenerativeQuestionConfig_Handler,
		},
		{
			MethodName: "BatchUpdateGenerativeQuestionConfigs",
			Handler:    _GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2/generative_question_service.proto",
}
