// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2beta/model_service.proto

package retailpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelService_CreateModel_FullMethodName = "/google.cloud.retail.v2beta.ModelService/CreateModel"
	ModelService_GetModel_FullMethodName    = "/google.cloud.retail.v2beta.ModelService/GetModel"
	ModelService_PauseModel_FullMethodName  = "/google.cloud.retail.v2beta.ModelService/PauseModel"
	ModelService_ResumeModel_FullMethodName = "/google.cloud.retail.v2beta.ModelService/ResumeModel"
	ModelService_DeleteModel_FullMethodName = "/google.cloud.retail.v2beta.ModelService/DeleteModel"
	ModelService_ListModels_FullMethodName  = "/google.cloud.retail.v2beta.ModelService/ListModels"
	ModelService_UpdateModel_FullMethodName = "/google.cloud.retail.v2beta.ModelService/UpdateModel"
	ModelService_TuneModel_FullMethodName   = "/google.cloud.retail.v2beta.ModelService/TuneModel"
)

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Creates a new model.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Pauses the training of an existing model.
	PauseModel(ctx context.Context, in *PauseModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Resumes the training of an existing model.
	ResumeModel(ctx context.Context, in *ResumeModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes an existing model.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all the models linked to this event store.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Update of model metadata. Only fields that
	// currently can be updated are: `filtering_option` and
	// `periodic_tuning_state`.
	// If other values are provided, this API method ignores them.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Tunes an existing model.
	TuneModel(ctx context.Context, in *TuneModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type modelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_CreateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_GetModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) PauseModel(ctx context.Context, in *PauseModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_PauseModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ResumeModel(ctx context.Context, in *ResumeModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_ResumeModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ModelService_DeleteModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_UpdateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) TuneModel(ctx context.Context, in *TuneModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_TuneModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
// All implementations should embed UnimplementedModelServiceServer
// for forward compatibility
type ModelServiceServer interface {
	// Creates a new model.
	CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Pauses the training of an existing model.
	PauseModel(context.Context, *PauseModelRequest) (*Model, error)
	// Resumes the training of an existing model.
	ResumeModel(context.Context, *ResumeModelRequest) (*Model, error)
	// Deletes an existing model.
	DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error)
	// Lists all the models linked to this event store.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Update of model metadata. Only fields that
	// currently can be updated are: `filtering_option` and
	// `periodic_tuning_state`.
	// If other values are provided, this API method ignores them.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Tunes an existing model.
	TuneModel(context.Context, *TuneModelRequest) (*longrunningpb.Operation, error)
}

// UnimplementedModelServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelServiceServer struct {
}

func (UnimplementedModelServiceServer) CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (UnimplementedModelServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (UnimplementedModelServiceServer) PauseModel(context.Context, *PauseModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseModel not implemented")
}
func (UnimplementedModelServiceServer) ResumeModel(context.Context, *ResumeModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeModel not implemented")
}
func (UnimplementedModelServiceServer) DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (UnimplementedModelServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (UnimplementedModelServiceServer) UpdateModel(context.Context, *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (UnimplementedModelServiceServer) TuneModel(context.Context, *TuneModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TuneModel not implemented")
}

// UnsafeModelServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelServiceServer will
// result in compilation errors.
type UnsafeModelServiceServer interface {
	mustEmbedUnimplementedModelServiceServer()
}

func RegisterModelServiceServer(s grpc.ServiceRegistrar, srv ModelServiceServer) {
	s.RegisterService(&ModelService_ServiceDesc, srv)
}

func _ModelService_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_CreateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_PauseModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).PauseModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_PauseModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).PauseModel(ctx, req.(*PauseModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ResumeModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ResumeModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ResumeModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ResumeModel(ctx, req.(*ResumeModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_DeleteModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_UpdateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_TuneModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TuneModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).TuneModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_TuneModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).TuneModel(ctx, req.(*TuneModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelService_ServiceDesc is the grpc.ServiceDesc for ModelService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateModel",
			Handler:    _ModelService_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "PauseModel",
			Handler:    _ModelService_PauseModel_Handler,
		},
		{
			MethodName: "ResumeModel",
			Handler:    _ModelService_ResumeModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _ModelService_UpdateModel_Handler,
		},
		{
			MethodName: "TuneModel",
			Handler:    _ModelService_TuneModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/model_service.proto",
}
