// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package artifactiface provides an interface to enable mocking the AWS Artifact service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package artifactiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/artifact"
)

// ArtifactAPI provides an interface to enable mocking the
// artifact.Artifact service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Artifact.
//	func myFunc(svc artifactiface.ArtifactAPI) bool {
//	    // Make svc.GetAccountSettings request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := artifact.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockArtifactClient struct {
//	    artifactiface.ArtifactAPI
//	}
//	func (m *mockArtifactClient) GetAccountSettings(input *artifact.GetAccountSettingsInput) (*artifact.GetAccountSettingsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockArtifactClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ArtifactAPI interface {
	GetAccountSettings(*artifact.GetAccountSettingsInput) (*artifact.GetAccountSettingsOutput, error)
	GetAccountSettingsWithContext(aws.Context, *artifact.GetAccountSettingsInput, ...request.Option) (*artifact.GetAccountSettingsOutput, error)
	GetAccountSettingsRequest(*artifact.GetAccountSettingsInput) (*request.Request, *artifact.GetAccountSettingsOutput)

	GetReport(*artifact.GetReportInput) (*artifact.GetReportOutput, error)
	GetReportWithContext(aws.Context, *artifact.GetReportInput, ...request.Option) (*artifact.GetReportOutput, error)
	GetReportRequest(*artifact.GetReportInput) (*request.Request, *artifact.GetReportOutput)

	GetReportMetadata(*artifact.GetReportMetadataInput) (*artifact.GetReportMetadataOutput, error)
	GetReportMetadataWithContext(aws.Context, *artifact.GetReportMetadataInput, ...request.Option) (*artifact.GetReportMetadataOutput, error)
	GetReportMetadataRequest(*artifact.GetReportMetadataInput) (*request.Request, *artifact.GetReportMetadataOutput)

	GetTermForReport(*artifact.GetTermForReportInput) (*artifact.GetTermForReportOutput, error)
	GetTermForReportWithContext(aws.Context, *artifact.GetTermForReportInput, ...request.Option) (*artifact.GetTermForReportOutput, error)
	GetTermForReportRequest(*artifact.GetTermForReportInput) (*request.Request, *artifact.GetTermForReportOutput)

	ListReports(*artifact.ListReportsInput) (*artifact.ListReportsOutput, error)
	ListReportsWithContext(aws.Context, *artifact.ListReportsInput, ...request.Option) (*artifact.ListReportsOutput, error)
	ListReportsRequest(*artifact.ListReportsInput) (*request.Request, *artifact.ListReportsOutput)

	ListReportsPages(*artifact.ListReportsInput, func(*artifact.ListReportsOutput, bool) bool) error
	ListReportsPagesWithContext(aws.Context, *artifact.ListReportsInput, func(*artifact.ListReportsOutput, bool) bool, ...request.Option) error

	PutAccountSettings(*artifact.PutAccountSettingsInput) (*artifact.PutAccountSettingsOutput, error)
	PutAccountSettingsWithContext(aws.Context, *artifact.PutAccountSettingsInput, ...request.Option) (*artifact.PutAccountSettingsOutput, error)
	PutAccountSettingsRequest(*artifact.PutAccountSettingsInput) (*request.Request, *artifact.PutAccountSettingsOutput)
}

var _ ArtifactAPI = (*artifact.Artifact)(nil)
