// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package costoptimizationhubiface provides an interface to enable mocking the Cost Optimization Hub service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package costoptimizationhubiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/costoptimizationhub"
)

// CostOptimizationHubAPI provides an interface to enable mocking the
// costoptimizationhub.CostOptimizationHub service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Cost Optimization Hub.
//	func myFunc(svc costoptimizationhubiface.CostOptimizationHubAPI) bool {
//	    // Make svc.GetPreferences request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := costoptimizationhub.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockCostOptimizationHubClient struct {
//	    costoptimizationhubiface.CostOptimizationHubAPI
//	}
//	func (m *mockCostOptimizationHubClient) GetPreferences(input *costoptimizationhub.GetPreferencesInput) (*costoptimizationhub.GetPreferencesOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockCostOptimizationHubClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CostOptimizationHubAPI interface {
	GetPreferences(*costoptimizationhub.GetPreferencesInput) (*costoptimizationhub.GetPreferencesOutput, error)
	GetPreferencesWithContext(aws.Context, *costoptimizationhub.GetPreferencesInput, ...request.Option) (*costoptimizationhub.GetPreferencesOutput, error)
	GetPreferencesRequest(*costoptimizationhub.GetPreferencesInput) (*request.Request, *costoptimizationhub.GetPreferencesOutput)

	GetRecommendation(*costoptimizationhub.GetRecommendationInput) (*costoptimizationhub.GetRecommendationOutput, error)
	GetRecommendationWithContext(aws.Context, *costoptimizationhub.GetRecommendationInput, ...request.Option) (*costoptimizationhub.GetRecommendationOutput, error)
	GetRecommendationRequest(*costoptimizationhub.GetRecommendationInput) (*request.Request, *costoptimizationhub.GetRecommendationOutput)

	ListEnrollmentStatuses(*costoptimizationhub.ListEnrollmentStatusesInput) (*costoptimizationhub.ListEnrollmentStatusesOutput, error)
	ListEnrollmentStatusesWithContext(aws.Context, *costoptimizationhub.ListEnrollmentStatusesInput, ...request.Option) (*costoptimizationhub.ListEnrollmentStatusesOutput, error)
	ListEnrollmentStatusesRequest(*costoptimizationhub.ListEnrollmentStatusesInput) (*request.Request, *costoptimizationhub.ListEnrollmentStatusesOutput)

	ListEnrollmentStatusesPages(*costoptimizationhub.ListEnrollmentStatusesInput, func(*costoptimizationhub.ListEnrollmentStatusesOutput, bool) bool) error
	ListEnrollmentStatusesPagesWithContext(aws.Context, *costoptimizationhub.ListEnrollmentStatusesInput, func(*costoptimizationhub.ListEnrollmentStatusesOutput, bool) bool, ...request.Option) error

	ListRecommendationSummaries(*costoptimizationhub.ListRecommendationSummariesInput) (*costoptimizationhub.ListRecommendationSummariesOutput, error)
	ListRecommendationSummariesWithContext(aws.Context, *costoptimizationhub.ListRecommendationSummariesInput, ...request.Option) (*costoptimizationhub.ListRecommendationSummariesOutput, error)
	ListRecommendationSummariesRequest(*costoptimizationhub.ListRecommendationSummariesInput) (*request.Request, *costoptimizationhub.ListRecommendationSummariesOutput)

	ListRecommendationSummariesPages(*costoptimizationhub.ListRecommendationSummariesInput, func(*costoptimizationhub.ListRecommendationSummariesOutput, bool) bool) error
	ListRecommendationSummariesPagesWithContext(aws.Context, *costoptimizationhub.ListRecommendationSummariesInput, func(*costoptimizationhub.ListRecommendationSummariesOutput, bool) bool, ...request.Option) error

	ListRecommendations(*costoptimizationhub.ListRecommendationsInput) (*costoptimizationhub.ListRecommendationsOutput, error)
	ListRecommendationsWithContext(aws.Context, *costoptimizationhub.ListRecommendationsInput, ...request.Option) (*costoptimizationhub.ListRecommendationsOutput, error)
	ListRecommendationsRequest(*costoptimizationhub.ListRecommendationsInput) (*request.Request, *costoptimizationhub.ListRecommendationsOutput)

	ListRecommendationsPages(*costoptimizationhub.ListRecommendationsInput, func(*costoptimizationhub.ListRecommendationsOutput, bool) bool) error
	ListRecommendationsPagesWithContext(aws.Context, *costoptimizationhub.ListRecommendationsInput, func(*costoptimizationhub.ListRecommendationsOutput, bool) bool, ...request.Option) error

	UpdateEnrollmentStatus(*costoptimizationhub.UpdateEnrollmentStatusInput) (*costoptimizationhub.UpdateEnrollmentStatusOutput, error)
	UpdateEnrollmentStatusWithContext(aws.Context, *costoptimizationhub.UpdateEnrollmentStatusInput, ...request.Option) (*costoptimizationhub.UpdateEnrollmentStatusOutput, error)
	UpdateEnrollmentStatusRequest(*costoptimizationhub.UpdateEnrollmentStatusInput) (*request.Request, *costoptimizationhub.UpdateEnrollmentStatusOutput)

	UpdatePreferences(*costoptimizationhub.UpdatePreferencesInput) (*costoptimizationhub.UpdatePreferencesOutput, error)
	UpdatePreferencesWithContext(aws.Context, *costoptimizationhub.UpdatePreferencesInput, ...request.Option) (*costoptimizationhub.UpdatePreferencesOutput, error)
	UpdatePreferencesRequest(*costoptimizationhub.UpdatePreferencesInput) (*request.Request, *costoptimizationhub.UpdatePreferencesOutput)
}

var _ CostOptimizationHubAPI = (*costoptimizationhub.CostOptimizationHub)(nil)
