// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package route53profilesiface provides an interface to enable mocking the Route 53 Profiles service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package route53profilesiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/route53profiles"
)

// Route53ProfilesAPI provides an interface to enable mocking the
// route53profiles.Route53Profiles service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Route 53 Profiles.
//	func myFunc(svc route53profilesiface.Route53ProfilesAPI) bool {
//	    // Make svc.AssociateProfile request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := route53profiles.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockRoute53ProfilesClient struct {
//	    route53profilesiface.Route53ProfilesAPI
//	}
//	func (m *mockRoute53ProfilesClient) AssociateProfile(input *route53profiles.AssociateProfileInput) (*route53profiles.AssociateProfileOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockRoute53ProfilesClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type Route53ProfilesAPI interface {
	AssociateProfile(*route53profiles.AssociateProfileInput) (*route53profiles.AssociateProfileOutput, error)
	AssociateProfileWithContext(aws.Context, *route53profiles.AssociateProfileInput, ...request.Option) (*route53profiles.AssociateProfileOutput, error)
	AssociateProfileRequest(*route53profiles.AssociateProfileInput) (*request.Request, *route53profiles.AssociateProfileOutput)

	AssociateResourceToProfile(*route53profiles.AssociateResourceToProfileInput) (*route53profiles.AssociateResourceToProfileOutput, error)
	AssociateResourceToProfileWithContext(aws.Context, *route53profiles.AssociateResourceToProfileInput, ...request.Option) (*route53profiles.AssociateResourceToProfileOutput, error)
	AssociateResourceToProfileRequest(*route53profiles.AssociateResourceToProfileInput) (*request.Request, *route53profiles.AssociateResourceToProfileOutput)

	CreateProfile(*route53profiles.CreateProfileInput) (*route53profiles.CreateProfileOutput, error)
	CreateProfileWithContext(aws.Context, *route53profiles.CreateProfileInput, ...request.Option) (*route53profiles.CreateProfileOutput, error)
	CreateProfileRequest(*route53profiles.CreateProfileInput) (*request.Request, *route53profiles.CreateProfileOutput)

	DeleteProfile(*route53profiles.DeleteProfileInput) (*route53profiles.DeleteProfileOutput, error)
	DeleteProfileWithContext(aws.Context, *route53profiles.DeleteProfileInput, ...request.Option) (*route53profiles.DeleteProfileOutput, error)
	DeleteProfileRequest(*route53profiles.DeleteProfileInput) (*request.Request, *route53profiles.DeleteProfileOutput)

	DisassociateProfile(*route53profiles.DisassociateProfileInput) (*route53profiles.DisassociateProfileOutput, error)
	DisassociateProfileWithContext(aws.Context, *route53profiles.DisassociateProfileInput, ...request.Option) (*route53profiles.DisassociateProfileOutput, error)
	DisassociateProfileRequest(*route53profiles.DisassociateProfileInput) (*request.Request, *route53profiles.DisassociateProfileOutput)

	DisassociateResourceFromProfile(*route53profiles.DisassociateResourceFromProfileInput) (*route53profiles.DisassociateResourceFromProfileOutput, error)
	DisassociateResourceFromProfileWithContext(aws.Context, *route53profiles.DisassociateResourceFromProfileInput, ...request.Option) (*route53profiles.DisassociateResourceFromProfileOutput, error)
	DisassociateResourceFromProfileRequest(*route53profiles.DisassociateResourceFromProfileInput) (*request.Request, *route53profiles.DisassociateResourceFromProfileOutput)

	GetProfile(*route53profiles.GetProfileInput) (*route53profiles.GetProfileOutput, error)
	GetProfileWithContext(aws.Context, *route53profiles.GetProfileInput, ...request.Option) (*route53profiles.GetProfileOutput, error)
	GetProfileRequest(*route53profiles.GetProfileInput) (*request.Request, *route53profiles.GetProfileOutput)

	GetProfileAssociation(*route53profiles.GetProfileAssociationInput) (*route53profiles.GetProfileAssociationOutput, error)
	GetProfileAssociationWithContext(aws.Context, *route53profiles.GetProfileAssociationInput, ...request.Option) (*route53profiles.GetProfileAssociationOutput, error)
	GetProfileAssociationRequest(*route53profiles.GetProfileAssociationInput) (*request.Request, *route53profiles.GetProfileAssociationOutput)

	GetProfileResourceAssociation(*route53profiles.GetProfileResourceAssociationInput) (*route53profiles.GetProfileResourceAssociationOutput, error)
	GetProfileResourceAssociationWithContext(aws.Context, *route53profiles.GetProfileResourceAssociationInput, ...request.Option) (*route53profiles.GetProfileResourceAssociationOutput, error)
	GetProfileResourceAssociationRequest(*route53profiles.GetProfileResourceAssociationInput) (*request.Request, *route53profiles.GetProfileResourceAssociationOutput)

	ListProfileAssociations(*route53profiles.ListProfileAssociationsInput) (*route53profiles.ListProfileAssociationsOutput, error)
	ListProfileAssociationsWithContext(aws.Context, *route53profiles.ListProfileAssociationsInput, ...request.Option) (*route53profiles.ListProfileAssociationsOutput, error)
	ListProfileAssociationsRequest(*route53profiles.ListProfileAssociationsInput) (*request.Request, *route53profiles.ListProfileAssociationsOutput)

	ListProfileAssociationsPages(*route53profiles.ListProfileAssociationsInput, func(*route53profiles.ListProfileAssociationsOutput, bool) bool) error
	ListProfileAssociationsPagesWithContext(aws.Context, *route53profiles.ListProfileAssociationsInput, func(*route53profiles.ListProfileAssociationsOutput, bool) bool, ...request.Option) error

	ListProfileResourceAssociations(*route53profiles.ListProfileResourceAssociationsInput) (*route53profiles.ListProfileResourceAssociationsOutput, error)
	ListProfileResourceAssociationsWithContext(aws.Context, *route53profiles.ListProfileResourceAssociationsInput, ...request.Option) (*route53profiles.ListProfileResourceAssociationsOutput, error)
	ListProfileResourceAssociationsRequest(*route53profiles.ListProfileResourceAssociationsInput) (*request.Request, *route53profiles.ListProfileResourceAssociationsOutput)

	ListProfileResourceAssociationsPages(*route53profiles.ListProfileResourceAssociationsInput, func(*route53profiles.ListProfileResourceAssociationsOutput, bool) bool) error
	ListProfileResourceAssociationsPagesWithContext(aws.Context, *route53profiles.ListProfileResourceAssociationsInput, func(*route53profiles.ListProfileResourceAssociationsOutput, bool) bool, ...request.Option) error

	ListProfiles(*route53profiles.ListProfilesInput) (*route53profiles.ListProfilesOutput, error)
	ListProfilesWithContext(aws.Context, *route53profiles.ListProfilesInput, ...request.Option) (*route53profiles.ListProfilesOutput, error)
	ListProfilesRequest(*route53profiles.ListProfilesInput) (*request.Request, *route53profiles.ListProfilesOutput)

	ListProfilesPages(*route53profiles.ListProfilesInput, func(*route53profiles.ListProfilesOutput, bool) bool) error
	ListProfilesPagesWithContext(aws.Context, *route53profiles.ListProfilesInput, func(*route53profiles.ListProfilesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*route53profiles.ListTagsForResourceInput) (*route53profiles.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *route53profiles.ListTagsForResourceInput, ...request.Option) (*route53profiles.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*route53profiles.ListTagsForResourceInput) (*request.Request, *route53profiles.ListTagsForResourceOutput)

	TagResource(*route53profiles.TagResourceInput) (*route53profiles.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *route53profiles.TagResourceInput, ...request.Option) (*route53profiles.TagResourceOutput, error)
	TagResourceRequest(*route53profiles.TagResourceInput) (*request.Request, *route53profiles.TagResourceOutput)

	UntagResource(*route53profiles.UntagResourceInput) (*route53profiles.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *route53profiles.UntagResourceInput, ...request.Option) (*route53profiles.UntagResourceOutput, error)
	UntagResourceRequest(*route53profiles.UntagResourceInput) (*request.Request, *route53profiles.UntagResourceOutput)

	UpdateProfileResourceAssociation(*route53profiles.UpdateProfileResourceAssociationInput) (*route53profiles.UpdateProfileResourceAssociationOutput, error)
	UpdateProfileResourceAssociationWithContext(aws.Context, *route53profiles.UpdateProfileResourceAssociationInput, ...request.Option) (*route53profiles.UpdateProfileResourceAssociationOutput, error)
	UpdateProfileResourceAssociationRequest(*route53profiles.UpdateProfileResourceAssociationInput) (*request.Request, *route53profiles.UpdateProfileResourceAssociationOutput)
}

var _ Route53ProfilesAPI = (*route53profiles.Route53Profiles)(nil)
