// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssoadminiface provides an interface to enable mocking the AWS Single Sign-On Admin service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssoadminiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssoadmin"
)

// SSOAdminAPI provides an interface to enable mocking the
// ssoadmin.SSOAdmin service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Single Sign-On Admin.
//	func myFunc(svc ssoadminiface.SSOAdminAPI) bool {
//	    // Make svc.AttachCustomerManagedPolicyReferenceToPermissionSet request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ssoadmin.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSSOAdminClient struct {
//	    ssoadminiface.SSOAdminAPI
//	}
//	func (m *mockSSOAdminClient) AttachCustomerManagedPolicyReferenceToPermissionSet(input *ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetInput) (*ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSSOAdminClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSOAdminAPI interface {
	AttachCustomerManagedPolicyReferenceToPermissionSet(*ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetInput) (*ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetOutput, error)
	AttachCustomerManagedPolicyReferenceToPermissionSetWithContext(aws.Context, *ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetInput, ...request.Option) (*ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetOutput, error)
	AttachCustomerManagedPolicyReferenceToPermissionSetRequest(*ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetInput) (*request.Request, *ssoadmin.AttachCustomerManagedPolicyReferenceToPermissionSetOutput)

	AttachManagedPolicyToPermissionSet(*ssoadmin.AttachManagedPolicyToPermissionSetInput) (*ssoadmin.AttachManagedPolicyToPermissionSetOutput, error)
	AttachManagedPolicyToPermissionSetWithContext(aws.Context, *ssoadmin.AttachManagedPolicyToPermissionSetInput, ...request.Option) (*ssoadmin.AttachManagedPolicyToPermissionSetOutput, error)
	AttachManagedPolicyToPermissionSetRequest(*ssoadmin.AttachManagedPolicyToPermissionSetInput) (*request.Request, *ssoadmin.AttachManagedPolicyToPermissionSetOutput)

	CreateAccountAssignment(*ssoadmin.CreateAccountAssignmentInput) (*ssoadmin.CreateAccountAssignmentOutput, error)
	CreateAccountAssignmentWithContext(aws.Context, *ssoadmin.CreateAccountAssignmentInput, ...request.Option) (*ssoadmin.CreateAccountAssignmentOutput, error)
	CreateAccountAssignmentRequest(*ssoadmin.CreateAccountAssignmentInput) (*request.Request, *ssoadmin.CreateAccountAssignmentOutput)

	CreateApplication(*ssoadmin.CreateApplicationInput) (*ssoadmin.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *ssoadmin.CreateApplicationInput, ...request.Option) (*ssoadmin.CreateApplicationOutput, error)
	CreateApplicationRequest(*ssoadmin.CreateApplicationInput) (*request.Request, *ssoadmin.CreateApplicationOutput)

	CreateApplicationAssignment(*ssoadmin.CreateApplicationAssignmentInput) (*ssoadmin.CreateApplicationAssignmentOutput, error)
	CreateApplicationAssignmentWithContext(aws.Context, *ssoadmin.CreateApplicationAssignmentInput, ...request.Option) (*ssoadmin.CreateApplicationAssignmentOutput, error)
	CreateApplicationAssignmentRequest(*ssoadmin.CreateApplicationAssignmentInput) (*request.Request, *ssoadmin.CreateApplicationAssignmentOutput)

	CreateInstance(*ssoadmin.CreateInstanceInput) (*ssoadmin.CreateInstanceOutput, error)
	CreateInstanceWithContext(aws.Context, *ssoadmin.CreateInstanceInput, ...request.Option) (*ssoadmin.CreateInstanceOutput, error)
	CreateInstanceRequest(*ssoadmin.CreateInstanceInput) (*request.Request, *ssoadmin.CreateInstanceOutput)

	CreateInstanceAccessControlAttributeConfiguration(*ssoadmin.CreateInstanceAccessControlAttributeConfigurationInput) (*ssoadmin.CreateInstanceAccessControlAttributeConfigurationOutput, error)
	CreateInstanceAccessControlAttributeConfigurationWithContext(aws.Context, *ssoadmin.CreateInstanceAccessControlAttributeConfigurationInput, ...request.Option) (*ssoadmin.CreateInstanceAccessControlAttributeConfigurationOutput, error)
	CreateInstanceAccessControlAttributeConfigurationRequest(*ssoadmin.CreateInstanceAccessControlAttributeConfigurationInput) (*request.Request, *ssoadmin.CreateInstanceAccessControlAttributeConfigurationOutput)

	CreatePermissionSet(*ssoadmin.CreatePermissionSetInput) (*ssoadmin.CreatePermissionSetOutput, error)
	CreatePermissionSetWithContext(aws.Context, *ssoadmin.CreatePermissionSetInput, ...request.Option) (*ssoadmin.CreatePermissionSetOutput, error)
	CreatePermissionSetRequest(*ssoadmin.CreatePermissionSetInput) (*request.Request, *ssoadmin.CreatePermissionSetOutput)

	CreateTrustedTokenIssuer(*ssoadmin.CreateTrustedTokenIssuerInput) (*ssoadmin.CreateTrustedTokenIssuerOutput, error)
	CreateTrustedTokenIssuerWithContext(aws.Context, *ssoadmin.CreateTrustedTokenIssuerInput, ...request.Option) (*ssoadmin.CreateTrustedTokenIssuerOutput, error)
	CreateTrustedTokenIssuerRequest(*ssoadmin.CreateTrustedTokenIssuerInput) (*request.Request, *ssoadmin.CreateTrustedTokenIssuerOutput)

	DeleteAccountAssignment(*ssoadmin.DeleteAccountAssignmentInput) (*ssoadmin.DeleteAccountAssignmentOutput, error)
	DeleteAccountAssignmentWithContext(aws.Context, *ssoadmin.DeleteAccountAssignmentInput, ...request.Option) (*ssoadmin.DeleteAccountAssignmentOutput, error)
	DeleteAccountAssignmentRequest(*ssoadmin.DeleteAccountAssignmentInput) (*request.Request, *ssoadmin.DeleteAccountAssignmentOutput)

	DeleteApplication(*ssoadmin.DeleteApplicationInput) (*ssoadmin.DeleteApplicationOutput, error)
	DeleteApplicationWithContext(aws.Context, *ssoadmin.DeleteApplicationInput, ...request.Option) (*ssoadmin.DeleteApplicationOutput, error)
	DeleteApplicationRequest(*ssoadmin.DeleteApplicationInput) (*request.Request, *ssoadmin.DeleteApplicationOutput)

	DeleteApplicationAccessScope(*ssoadmin.DeleteApplicationAccessScopeInput) (*ssoadmin.DeleteApplicationAccessScopeOutput, error)
	DeleteApplicationAccessScopeWithContext(aws.Context, *ssoadmin.DeleteApplicationAccessScopeInput, ...request.Option) (*ssoadmin.DeleteApplicationAccessScopeOutput, error)
	DeleteApplicationAccessScopeRequest(*ssoadmin.DeleteApplicationAccessScopeInput) (*request.Request, *ssoadmin.DeleteApplicationAccessScopeOutput)

	DeleteApplicationAssignment(*ssoadmin.DeleteApplicationAssignmentInput) (*ssoadmin.DeleteApplicationAssignmentOutput, error)
	DeleteApplicationAssignmentWithContext(aws.Context, *ssoadmin.DeleteApplicationAssignmentInput, ...request.Option) (*ssoadmin.DeleteApplicationAssignmentOutput, error)
	DeleteApplicationAssignmentRequest(*ssoadmin.DeleteApplicationAssignmentInput) (*request.Request, *ssoadmin.DeleteApplicationAssignmentOutput)

	DeleteApplicationAuthenticationMethod(*ssoadmin.DeleteApplicationAuthenticationMethodInput) (*ssoadmin.DeleteApplicationAuthenticationMethodOutput, error)
	DeleteApplicationAuthenticationMethodWithContext(aws.Context, *ssoadmin.DeleteApplicationAuthenticationMethodInput, ...request.Option) (*ssoadmin.DeleteApplicationAuthenticationMethodOutput, error)
	DeleteApplicationAuthenticationMethodRequest(*ssoadmin.DeleteApplicationAuthenticationMethodInput) (*request.Request, *ssoadmin.DeleteApplicationAuthenticationMethodOutput)

	DeleteApplicationGrant(*ssoadmin.DeleteApplicationGrantInput) (*ssoadmin.DeleteApplicationGrantOutput, error)
	DeleteApplicationGrantWithContext(aws.Context, *ssoadmin.DeleteApplicationGrantInput, ...request.Option) (*ssoadmin.DeleteApplicationGrantOutput, error)
	DeleteApplicationGrantRequest(*ssoadmin.DeleteApplicationGrantInput) (*request.Request, *ssoadmin.DeleteApplicationGrantOutput)

	DeleteInlinePolicyFromPermissionSet(*ssoadmin.DeleteInlinePolicyFromPermissionSetInput) (*ssoadmin.DeleteInlinePolicyFromPermissionSetOutput, error)
	DeleteInlinePolicyFromPermissionSetWithContext(aws.Context, *ssoadmin.DeleteInlinePolicyFromPermissionSetInput, ...request.Option) (*ssoadmin.DeleteInlinePolicyFromPermissionSetOutput, error)
	DeleteInlinePolicyFromPermissionSetRequest(*ssoadmin.DeleteInlinePolicyFromPermissionSetInput) (*request.Request, *ssoadmin.DeleteInlinePolicyFromPermissionSetOutput)

	DeleteInstance(*ssoadmin.DeleteInstanceInput) (*ssoadmin.DeleteInstanceOutput, error)
	DeleteInstanceWithContext(aws.Context, *ssoadmin.DeleteInstanceInput, ...request.Option) (*ssoadmin.DeleteInstanceOutput, error)
	DeleteInstanceRequest(*ssoadmin.DeleteInstanceInput) (*request.Request, *ssoadmin.DeleteInstanceOutput)

	DeleteInstanceAccessControlAttributeConfiguration(*ssoadmin.DeleteInstanceAccessControlAttributeConfigurationInput) (*ssoadmin.DeleteInstanceAccessControlAttributeConfigurationOutput, error)
	DeleteInstanceAccessControlAttributeConfigurationWithContext(aws.Context, *ssoadmin.DeleteInstanceAccessControlAttributeConfigurationInput, ...request.Option) (*ssoadmin.DeleteInstanceAccessControlAttributeConfigurationOutput, error)
	DeleteInstanceAccessControlAttributeConfigurationRequest(*ssoadmin.DeleteInstanceAccessControlAttributeConfigurationInput) (*request.Request, *ssoadmin.DeleteInstanceAccessControlAttributeConfigurationOutput)

	DeletePermissionSet(*ssoadmin.DeletePermissionSetInput) (*ssoadmin.DeletePermissionSetOutput, error)
	DeletePermissionSetWithContext(aws.Context, *ssoadmin.DeletePermissionSetInput, ...request.Option) (*ssoadmin.DeletePermissionSetOutput, error)
	DeletePermissionSetRequest(*ssoadmin.DeletePermissionSetInput) (*request.Request, *ssoadmin.DeletePermissionSetOutput)

	DeletePermissionsBoundaryFromPermissionSet(*ssoadmin.DeletePermissionsBoundaryFromPermissionSetInput) (*ssoadmin.DeletePermissionsBoundaryFromPermissionSetOutput, error)
	DeletePermissionsBoundaryFromPermissionSetWithContext(aws.Context, *ssoadmin.DeletePermissionsBoundaryFromPermissionSetInput, ...request.Option) (*ssoadmin.DeletePermissionsBoundaryFromPermissionSetOutput, error)
	DeletePermissionsBoundaryFromPermissionSetRequest(*ssoadmin.DeletePermissionsBoundaryFromPermissionSetInput) (*request.Request, *ssoadmin.DeletePermissionsBoundaryFromPermissionSetOutput)

	DeleteTrustedTokenIssuer(*ssoadmin.DeleteTrustedTokenIssuerInput) (*ssoadmin.DeleteTrustedTokenIssuerOutput, error)
	DeleteTrustedTokenIssuerWithContext(aws.Context, *ssoadmin.DeleteTrustedTokenIssuerInput, ...request.Option) (*ssoadmin.DeleteTrustedTokenIssuerOutput, error)
	DeleteTrustedTokenIssuerRequest(*ssoadmin.DeleteTrustedTokenIssuerInput) (*request.Request, *ssoadmin.DeleteTrustedTokenIssuerOutput)

	DescribeAccountAssignmentCreationStatus(*ssoadmin.DescribeAccountAssignmentCreationStatusInput) (*ssoadmin.DescribeAccountAssignmentCreationStatusOutput, error)
	DescribeAccountAssignmentCreationStatusWithContext(aws.Context, *ssoadmin.DescribeAccountAssignmentCreationStatusInput, ...request.Option) (*ssoadmin.DescribeAccountAssignmentCreationStatusOutput, error)
	DescribeAccountAssignmentCreationStatusRequest(*ssoadmin.DescribeAccountAssignmentCreationStatusInput) (*request.Request, *ssoadmin.DescribeAccountAssignmentCreationStatusOutput)

	DescribeAccountAssignmentDeletionStatus(*ssoadmin.DescribeAccountAssignmentDeletionStatusInput) (*ssoadmin.DescribeAccountAssignmentDeletionStatusOutput, error)
	DescribeAccountAssignmentDeletionStatusWithContext(aws.Context, *ssoadmin.DescribeAccountAssignmentDeletionStatusInput, ...request.Option) (*ssoadmin.DescribeAccountAssignmentDeletionStatusOutput, error)
	DescribeAccountAssignmentDeletionStatusRequest(*ssoadmin.DescribeAccountAssignmentDeletionStatusInput) (*request.Request, *ssoadmin.DescribeAccountAssignmentDeletionStatusOutput)

	DescribeApplication(*ssoadmin.DescribeApplicationInput) (*ssoadmin.DescribeApplicationOutput, error)
	DescribeApplicationWithContext(aws.Context, *ssoadmin.DescribeApplicationInput, ...request.Option) (*ssoadmin.DescribeApplicationOutput, error)
	DescribeApplicationRequest(*ssoadmin.DescribeApplicationInput) (*request.Request, *ssoadmin.DescribeApplicationOutput)

	DescribeApplicationAssignment(*ssoadmin.DescribeApplicationAssignmentInput) (*ssoadmin.DescribeApplicationAssignmentOutput, error)
	DescribeApplicationAssignmentWithContext(aws.Context, *ssoadmin.DescribeApplicationAssignmentInput, ...request.Option) (*ssoadmin.DescribeApplicationAssignmentOutput, error)
	DescribeApplicationAssignmentRequest(*ssoadmin.DescribeApplicationAssignmentInput) (*request.Request, *ssoadmin.DescribeApplicationAssignmentOutput)

	DescribeApplicationProvider(*ssoadmin.DescribeApplicationProviderInput) (*ssoadmin.DescribeApplicationProviderOutput, error)
	DescribeApplicationProviderWithContext(aws.Context, *ssoadmin.DescribeApplicationProviderInput, ...request.Option) (*ssoadmin.DescribeApplicationProviderOutput, error)
	DescribeApplicationProviderRequest(*ssoadmin.DescribeApplicationProviderInput) (*request.Request, *ssoadmin.DescribeApplicationProviderOutput)

	DescribeInstance(*ssoadmin.DescribeInstanceInput) (*ssoadmin.DescribeInstanceOutput, error)
	DescribeInstanceWithContext(aws.Context, *ssoadmin.DescribeInstanceInput, ...request.Option) (*ssoadmin.DescribeInstanceOutput, error)
	DescribeInstanceRequest(*ssoadmin.DescribeInstanceInput) (*request.Request, *ssoadmin.DescribeInstanceOutput)

	DescribeInstanceAccessControlAttributeConfiguration(*ssoadmin.DescribeInstanceAccessControlAttributeConfigurationInput) (*ssoadmin.DescribeInstanceAccessControlAttributeConfigurationOutput, error)
	DescribeInstanceAccessControlAttributeConfigurationWithContext(aws.Context, *ssoadmin.DescribeInstanceAccessControlAttributeConfigurationInput, ...request.Option) (*ssoadmin.DescribeInstanceAccessControlAttributeConfigurationOutput, error)
	DescribeInstanceAccessControlAttributeConfigurationRequest(*ssoadmin.DescribeInstanceAccessControlAttributeConfigurationInput) (*request.Request, *ssoadmin.DescribeInstanceAccessControlAttributeConfigurationOutput)

	DescribePermissionSet(*ssoadmin.DescribePermissionSetInput) (*ssoadmin.DescribePermissionSetOutput, error)
	DescribePermissionSetWithContext(aws.Context, *ssoadmin.DescribePermissionSetInput, ...request.Option) (*ssoadmin.DescribePermissionSetOutput, error)
	DescribePermissionSetRequest(*ssoadmin.DescribePermissionSetInput) (*request.Request, *ssoadmin.DescribePermissionSetOutput)

	DescribePermissionSetProvisioningStatus(*ssoadmin.DescribePermissionSetProvisioningStatusInput) (*ssoadmin.DescribePermissionSetProvisioningStatusOutput, error)
	DescribePermissionSetProvisioningStatusWithContext(aws.Context, *ssoadmin.DescribePermissionSetProvisioningStatusInput, ...request.Option) (*ssoadmin.DescribePermissionSetProvisioningStatusOutput, error)
	DescribePermissionSetProvisioningStatusRequest(*ssoadmin.DescribePermissionSetProvisioningStatusInput) (*request.Request, *ssoadmin.DescribePermissionSetProvisioningStatusOutput)

	DescribeTrustedTokenIssuer(*ssoadmin.DescribeTrustedTokenIssuerInput) (*ssoadmin.DescribeTrustedTokenIssuerOutput, error)
	DescribeTrustedTokenIssuerWithContext(aws.Context, *ssoadmin.DescribeTrustedTokenIssuerInput, ...request.Option) (*ssoadmin.DescribeTrustedTokenIssuerOutput, error)
	DescribeTrustedTokenIssuerRequest(*ssoadmin.DescribeTrustedTokenIssuerInput) (*request.Request, *ssoadmin.DescribeTrustedTokenIssuerOutput)

	DetachCustomerManagedPolicyReferenceFromPermissionSet(*ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetInput) (*ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetOutput, error)
	DetachCustomerManagedPolicyReferenceFromPermissionSetWithContext(aws.Context, *ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetInput, ...request.Option) (*ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetOutput, error)
	DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(*ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetInput) (*request.Request, *ssoadmin.DetachCustomerManagedPolicyReferenceFromPermissionSetOutput)

	DetachManagedPolicyFromPermissionSet(*ssoadmin.DetachManagedPolicyFromPermissionSetInput) (*ssoadmin.DetachManagedPolicyFromPermissionSetOutput, error)
	DetachManagedPolicyFromPermissionSetWithContext(aws.Context, *ssoadmin.DetachManagedPolicyFromPermissionSetInput, ...request.Option) (*ssoadmin.DetachManagedPolicyFromPermissionSetOutput, error)
	DetachManagedPolicyFromPermissionSetRequest(*ssoadmin.DetachManagedPolicyFromPermissionSetInput) (*request.Request, *ssoadmin.DetachManagedPolicyFromPermissionSetOutput)

	GetApplicationAccessScope(*ssoadmin.GetApplicationAccessScopeInput) (*ssoadmin.GetApplicationAccessScopeOutput, error)
	GetApplicationAccessScopeWithContext(aws.Context, *ssoadmin.GetApplicationAccessScopeInput, ...request.Option) (*ssoadmin.GetApplicationAccessScopeOutput, error)
	GetApplicationAccessScopeRequest(*ssoadmin.GetApplicationAccessScopeInput) (*request.Request, *ssoadmin.GetApplicationAccessScopeOutput)

	GetApplicationAssignmentConfiguration(*ssoadmin.GetApplicationAssignmentConfigurationInput) (*ssoadmin.GetApplicationAssignmentConfigurationOutput, error)
	GetApplicationAssignmentConfigurationWithContext(aws.Context, *ssoadmin.GetApplicationAssignmentConfigurationInput, ...request.Option) (*ssoadmin.GetApplicationAssignmentConfigurationOutput, error)
	GetApplicationAssignmentConfigurationRequest(*ssoadmin.GetApplicationAssignmentConfigurationInput) (*request.Request, *ssoadmin.GetApplicationAssignmentConfigurationOutput)

	GetApplicationAuthenticationMethod(*ssoadmin.GetApplicationAuthenticationMethodInput) (*ssoadmin.GetApplicationAuthenticationMethodOutput, error)
	GetApplicationAuthenticationMethodWithContext(aws.Context, *ssoadmin.GetApplicationAuthenticationMethodInput, ...request.Option) (*ssoadmin.GetApplicationAuthenticationMethodOutput, error)
	GetApplicationAuthenticationMethodRequest(*ssoadmin.GetApplicationAuthenticationMethodInput) (*request.Request, *ssoadmin.GetApplicationAuthenticationMethodOutput)

	GetApplicationGrant(*ssoadmin.GetApplicationGrantInput) (*ssoadmin.GetApplicationGrantOutput, error)
	GetApplicationGrantWithContext(aws.Context, *ssoadmin.GetApplicationGrantInput, ...request.Option) (*ssoadmin.GetApplicationGrantOutput, error)
	GetApplicationGrantRequest(*ssoadmin.GetApplicationGrantInput) (*request.Request, *ssoadmin.GetApplicationGrantOutput)

	GetInlinePolicyForPermissionSet(*ssoadmin.GetInlinePolicyForPermissionSetInput) (*ssoadmin.GetInlinePolicyForPermissionSetOutput, error)
	GetInlinePolicyForPermissionSetWithContext(aws.Context, *ssoadmin.GetInlinePolicyForPermissionSetInput, ...request.Option) (*ssoadmin.GetInlinePolicyForPermissionSetOutput, error)
	GetInlinePolicyForPermissionSetRequest(*ssoadmin.GetInlinePolicyForPermissionSetInput) (*request.Request, *ssoadmin.GetInlinePolicyForPermissionSetOutput)

	GetPermissionsBoundaryForPermissionSet(*ssoadmin.GetPermissionsBoundaryForPermissionSetInput) (*ssoadmin.GetPermissionsBoundaryForPermissionSetOutput, error)
	GetPermissionsBoundaryForPermissionSetWithContext(aws.Context, *ssoadmin.GetPermissionsBoundaryForPermissionSetInput, ...request.Option) (*ssoadmin.GetPermissionsBoundaryForPermissionSetOutput, error)
	GetPermissionsBoundaryForPermissionSetRequest(*ssoadmin.GetPermissionsBoundaryForPermissionSetInput) (*request.Request, *ssoadmin.GetPermissionsBoundaryForPermissionSetOutput)

	ListAccountAssignmentCreationStatus(*ssoadmin.ListAccountAssignmentCreationStatusInput) (*ssoadmin.ListAccountAssignmentCreationStatusOutput, error)
	ListAccountAssignmentCreationStatusWithContext(aws.Context, *ssoadmin.ListAccountAssignmentCreationStatusInput, ...request.Option) (*ssoadmin.ListAccountAssignmentCreationStatusOutput, error)
	ListAccountAssignmentCreationStatusRequest(*ssoadmin.ListAccountAssignmentCreationStatusInput) (*request.Request, *ssoadmin.ListAccountAssignmentCreationStatusOutput)

	ListAccountAssignmentCreationStatusPages(*ssoadmin.ListAccountAssignmentCreationStatusInput, func(*ssoadmin.ListAccountAssignmentCreationStatusOutput, bool) bool) error
	ListAccountAssignmentCreationStatusPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentCreationStatusInput, func(*ssoadmin.ListAccountAssignmentCreationStatusOutput, bool) bool, ...request.Option) error

	ListAccountAssignmentDeletionStatus(*ssoadmin.ListAccountAssignmentDeletionStatusInput) (*ssoadmin.ListAccountAssignmentDeletionStatusOutput, error)
	ListAccountAssignmentDeletionStatusWithContext(aws.Context, *ssoadmin.ListAccountAssignmentDeletionStatusInput, ...request.Option) (*ssoadmin.ListAccountAssignmentDeletionStatusOutput, error)
	ListAccountAssignmentDeletionStatusRequest(*ssoadmin.ListAccountAssignmentDeletionStatusInput) (*request.Request, *ssoadmin.ListAccountAssignmentDeletionStatusOutput)

	ListAccountAssignmentDeletionStatusPages(*ssoadmin.ListAccountAssignmentDeletionStatusInput, func(*ssoadmin.ListAccountAssignmentDeletionStatusOutput, bool) bool) error
	ListAccountAssignmentDeletionStatusPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentDeletionStatusInput, func(*ssoadmin.ListAccountAssignmentDeletionStatusOutput, bool) bool, ...request.Option) error

	ListAccountAssignments(*ssoadmin.ListAccountAssignmentsInput) (*ssoadmin.ListAccountAssignmentsOutput, error)
	ListAccountAssignmentsWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsInput, ...request.Option) (*ssoadmin.ListAccountAssignmentsOutput, error)
	ListAccountAssignmentsRequest(*ssoadmin.ListAccountAssignmentsInput) (*request.Request, *ssoadmin.ListAccountAssignmentsOutput)

	ListAccountAssignmentsPages(*ssoadmin.ListAccountAssignmentsInput, func(*ssoadmin.ListAccountAssignmentsOutput, bool) bool) error
	ListAccountAssignmentsPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsInput, func(*ssoadmin.ListAccountAssignmentsOutput, bool) bool, ...request.Option) error

	ListAccountAssignmentsForPrincipal(*ssoadmin.ListAccountAssignmentsForPrincipalInput) (*ssoadmin.ListAccountAssignmentsForPrincipalOutput, error)
	ListAccountAssignmentsForPrincipalWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsForPrincipalInput, ...request.Option) (*ssoadmin.ListAccountAssignmentsForPrincipalOutput, error)
	ListAccountAssignmentsForPrincipalRequest(*ssoadmin.ListAccountAssignmentsForPrincipalInput) (*request.Request, *ssoadmin.ListAccountAssignmentsForPrincipalOutput)

	ListAccountAssignmentsForPrincipalPages(*ssoadmin.ListAccountAssignmentsForPrincipalInput, func(*ssoadmin.ListAccountAssignmentsForPrincipalOutput, bool) bool) error
	ListAccountAssignmentsForPrincipalPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsForPrincipalInput, func(*ssoadmin.ListAccountAssignmentsForPrincipalOutput, bool) bool, ...request.Option) error

	ListAccountsForProvisionedPermissionSet(*ssoadmin.ListAccountsForProvisionedPermissionSetInput) (*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, error)
	ListAccountsForProvisionedPermissionSetWithContext(aws.Context, *ssoadmin.ListAccountsForProvisionedPermissionSetInput, ...request.Option) (*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, error)
	ListAccountsForProvisionedPermissionSetRequest(*ssoadmin.ListAccountsForProvisionedPermissionSetInput) (*request.Request, *ssoadmin.ListAccountsForProvisionedPermissionSetOutput)

	ListAccountsForProvisionedPermissionSetPages(*ssoadmin.ListAccountsForProvisionedPermissionSetInput, func(*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, bool) bool) error
	ListAccountsForProvisionedPermissionSetPagesWithContext(aws.Context, *ssoadmin.ListAccountsForProvisionedPermissionSetInput, func(*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, bool) bool, ...request.Option) error

	ListApplicationAccessScopes(*ssoadmin.ListApplicationAccessScopesInput) (*ssoadmin.ListApplicationAccessScopesOutput, error)
	ListApplicationAccessScopesWithContext(aws.Context, *ssoadmin.ListApplicationAccessScopesInput, ...request.Option) (*ssoadmin.ListApplicationAccessScopesOutput, error)
	ListApplicationAccessScopesRequest(*ssoadmin.ListApplicationAccessScopesInput) (*request.Request, *ssoadmin.ListApplicationAccessScopesOutput)

	ListApplicationAccessScopesPages(*ssoadmin.ListApplicationAccessScopesInput, func(*ssoadmin.ListApplicationAccessScopesOutput, bool) bool) error
	ListApplicationAccessScopesPagesWithContext(aws.Context, *ssoadmin.ListApplicationAccessScopesInput, func(*ssoadmin.ListApplicationAccessScopesOutput, bool) bool, ...request.Option) error

	ListApplicationAssignments(*ssoadmin.ListApplicationAssignmentsInput) (*ssoadmin.ListApplicationAssignmentsOutput, error)
	ListApplicationAssignmentsWithContext(aws.Context, *ssoadmin.ListApplicationAssignmentsInput, ...request.Option) (*ssoadmin.ListApplicationAssignmentsOutput, error)
	ListApplicationAssignmentsRequest(*ssoadmin.ListApplicationAssignmentsInput) (*request.Request, *ssoadmin.ListApplicationAssignmentsOutput)

	ListApplicationAssignmentsPages(*ssoadmin.ListApplicationAssignmentsInput, func(*ssoadmin.ListApplicationAssignmentsOutput, bool) bool) error
	ListApplicationAssignmentsPagesWithContext(aws.Context, *ssoadmin.ListApplicationAssignmentsInput, func(*ssoadmin.ListApplicationAssignmentsOutput, bool) bool, ...request.Option) error

	ListApplicationAssignmentsForPrincipal(*ssoadmin.ListApplicationAssignmentsForPrincipalInput) (*ssoadmin.ListApplicationAssignmentsForPrincipalOutput, error)
	ListApplicationAssignmentsForPrincipalWithContext(aws.Context, *ssoadmin.ListApplicationAssignmentsForPrincipalInput, ...request.Option) (*ssoadmin.ListApplicationAssignmentsForPrincipalOutput, error)
	ListApplicationAssignmentsForPrincipalRequest(*ssoadmin.ListApplicationAssignmentsForPrincipalInput) (*request.Request, *ssoadmin.ListApplicationAssignmentsForPrincipalOutput)

	ListApplicationAssignmentsForPrincipalPages(*ssoadmin.ListApplicationAssignmentsForPrincipalInput, func(*ssoadmin.ListApplicationAssignmentsForPrincipalOutput, bool) bool) error
	ListApplicationAssignmentsForPrincipalPagesWithContext(aws.Context, *ssoadmin.ListApplicationAssignmentsForPrincipalInput, func(*ssoadmin.ListApplicationAssignmentsForPrincipalOutput, bool) bool, ...request.Option) error

	ListApplicationAuthenticationMethods(*ssoadmin.ListApplicationAuthenticationMethodsInput) (*ssoadmin.ListApplicationAuthenticationMethodsOutput, error)
	ListApplicationAuthenticationMethodsWithContext(aws.Context, *ssoadmin.ListApplicationAuthenticationMethodsInput, ...request.Option) (*ssoadmin.ListApplicationAuthenticationMethodsOutput, error)
	ListApplicationAuthenticationMethodsRequest(*ssoadmin.ListApplicationAuthenticationMethodsInput) (*request.Request, *ssoadmin.ListApplicationAuthenticationMethodsOutput)

	ListApplicationAuthenticationMethodsPages(*ssoadmin.ListApplicationAuthenticationMethodsInput, func(*ssoadmin.ListApplicationAuthenticationMethodsOutput, bool) bool) error
	ListApplicationAuthenticationMethodsPagesWithContext(aws.Context, *ssoadmin.ListApplicationAuthenticationMethodsInput, func(*ssoadmin.ListApplicationAuthenticationMethodsOutput, bool) bool, ...request.Option) error

	ListApplicationGrants(*ssoadmin.ListApplicationGrantsInput) (*ssoadmin.ListApplicationGrantsOutput, error)
	ListApplicationGrantsWithContext(aws.Context, *ssoadmin.ListApplicationGrantsInput, ...request.Option) (*ssoadmin.ListApplicationGrantsOutput, error)
	ListApplicationGrantsRequest(*ssoadmin.ListApplicationGrantsInput) (*request.Request, *ssoadmin.ListApplicationGrantsOutput)

	ListApplicationGrantsPages(*ssoadmin.ListApplicationGrantsInput, func(*ssoadmin.ListApplicationGrantsOutput, bool) bool) error
	ListApplicationGrantsPagesWithContext(aws.Context, *ssoadmin.ListApplicationGrantsInput, func(*ssoadmin.ListApplicationGrantsOutput, bool) bool, ...request.Option) error

	ListApplicationProviders(*ssoadmin.ListApplicationProvidersInput) (*ssoadmin.ListApplicationProvidersOutput, error)
	ListApplicationProvidersWithContext(aws.Context, *ssoadmin.ListApplicationProvidersInput, ...request.Option) (*ssoadmin.ListApplicationProvidersOutput, error)
	ListApplicationProvidersRequest(*ssoadmin.ListApplicationProvidersInput) (*request.Request, *ssoadmin.ListApplicationProvidersOutput)

	ListApplicationProvidersPages(*ssoadmin.ListApplicationProvidersInput, func(*ssoadmin.ListApplicationProvidersOutput, bool) bool) error
	ListApplicationProvidersPagesWithContext(aws.Context, *ssoadmin.ListApplicationProvidersInput, func(*ssoadmin.ListApplicationProvidersOutput, bool) bool, ...request.Option) error

	ListApplications(*ssoadmin.ListApplicationsInput) (*ssoadmin.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *ssoadmin.ListApplicationsInput, ...request.Option) (*ssoadmin.ListApplicationsOutput, error)
	ListApplicationsRequest(*ssoadmin.ListApplicationsInput) (*request.Request, *ssoadmin.ListApplicationsOutput)

	ListApplicationsPages(*ssoadmin.ListApplicationsInput, func(*ssoadmin.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *ssoadmin.ListApplicationsInput, func(*ssoadmin.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListCustomerManagedPolicyReferencesInPermissionSet(*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetInput) (*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput, error)
	ListCustomerManagedPolicyReferencesInPermissionSetWithContext(aws.Context, *ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetInput, ...request.Option) (*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput, error)
	ListCustomerManagedPolicyReferencesInPermissionSetRequest(*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetInput) (*request.Request, *ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput)

	ListCustomerManagedPolicyReferencesInPermissionSetPages(*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetInput, func(*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput, bool) bool) error
	ListCustomerManagedPolicyReferencesInPermissionSetPagesWithContext(aws.Context, *ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetInput, func(*ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput, bool) bool, ...request.Option) error

	ListInstances(*ssoadmin.ListInstancesInput) (*ssoadmin.ListInstancesOutput, error)
	ListInstancesWithContext(aws.Context, *ssoadmin.ListInstancesInput, ...request.Option) (*ssoadmin.ListInstancesOutput, error)
	ListInstancesRequest(*ssoadmin.ListInstancesInput) (*request.Request, *ssoadmin.ListInstancesOutput)

	ListInstancesPages(*ssoadmin.ListInstancesInput, func(*ssoadmin.ListInstancesOutput, bool) bool) error
	ListInstancesPagesWithContext(aws.Context, *ssoadmin.ListInstancesInput, func(*ssoadmin.ListInstancesOutput, bool) bool, ...request.Option) error

	ListManagedPoliciesInPermissionSet(*ssoadmin.ListManagedPoliciesInPermissionSetInput) (*ssoadmin.ListManagedPoliciesInPermissionSetOutput, error)
	ListManagedPoliciesInPermissionSetWithContext(aws.Context, *ssoadmin.ListManagedPoliciesInPermissionSetInput, ...request.Option) (*ssoadmin.ListManagedPoliciesInPermissionSetOutput, error)
	ListManagedPoliciesInPermissionSetRequest(*ssoadmin.ListManagedPoliciesInPermissionSetInput) (*request.Request, *ssoadmin.ListManagedPoliciesInPermissionSetOutput)

	ListManagedPoliciesInPermissionSetPages(*ssoadmin.ListManagedPoliciesInPermissionSetInput, func(*ssoadmin.ListManagedPoliciesInPermissionSetOutput, bool) bool) error
	ListManagedPoliciesInPermissionSetPagesWithContext(aws.Context, *ssoadmin.ListManagedPoliciesInPermissionSetInput, func(*ssoadmin.ListManagedPoliciesInPermissionSetOutput, bool) bool, ...request.Option) error

	ListPermissionSetProvisioningStatus(*ssoadmin.ListPermissionSetProvisioningStatusInput) (*ssoadmin.ListPermissionSetProvisioningStatusOutput, error)
	ListPermissionSetProvisioningStatusWithContext(aws.Context, *ssoadmin.ListPermissionSetProvisioningStatusInput, ...request.Option) (*ssoadmin.ListPermissionSetProvisioningStatusOutput, error)
	ListPermissionSetProvisioningStatusRequest(*ssoadmin.ListPermissionSetProvisioningStatusInput) (*request.Request, *ssoadmin.ListPermissionSetProvisioningStatusOutput)

	ListPermissionSetProvisioningStatusPages(*ssoadmin.ListPermissionSetProvisioningStatusInput, func(*ssoadmin.ListPermissionSetProvisioningStatusOutput, bool) bool) error
	ListPermissionSetProvisioningStatusPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetProvisioningStatusInput, func(*ssoadmin.ListPermissionSetProvisioningStatusOutput, bool) bool, ...request.Option) error

	ListPermissionSets(*ssoadmin.ListPermissionSetsInput) (*ssoadmin.ListPermissionSetsOutput, error)
	ListPermissionSetsWithContext(aws.Context, *ssoadmin.ListPermissionSetsInput, ...request.Option) (*ssoadmin.ListPermissionSetsOutput, error)
	ListPermissionSetsRequest(*ssoadmin.ListPermissionSetsInput) (*request.Request, *ssoadmin.ListPermissionSetsOutput)

	ListPermissionSetsPages(*ssoadmin.ListPermissionSetsInput, func(*ssoadmin.ListPermissionSetsOutput, bool) bool) error
	ListPermissionSetsPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetsInput, func(*ssoadmin.ListPermissionSetsOutput, bool) bool, ...request.Option) error

	ListPermissionSetsProvisionedToAccount(*ssoadmin.ListPermissionSetsProvisionedToAccountInput) (*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, error)
	ListPermissionSetsProvisionedToAccountWithContext(aws.Context, *ssoadmin.ListPermissionSetsProvisionedToAccountInput, ...request.Option) (*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, error)
	ListPermissionSetsProvisionedToAccountRequest(*ssoadmin.ListPermissionSetsProvisionedToAccountInput) (*request.Request, *ssoadmin.ListPermissionSetsProvisionedToAccountOutput)

	ListPermissionSetsProvisionedToAccountPages(*ssoadmin.ListPermissionSetsProvisionedToAccountInput, func(*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, bool) bool) error
	ListPermissionSetsProvisionedToAccountPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetsProvisionedToAccountInput, func(*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*ssoadmin.ListTagsForResourceInput) (*ssoadmin.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ssoadmin.ListTagsForResourceInput, ...request.Option) (*ssoadmin.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ssoadmin.ListTagsForResourceInput) (*request.Request, *ssoadmin.ListTagsForResourceOutput)

	ListTagsForResourcePages(*ssoadmin.ListTagsForResourceInput, func(*ssoadmin.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *ssoadmin.ListTagsForResourceInput, func(*ssoadmin.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	ListTrustedTokenIssuers(*ssoadmin.ListTrustedTokenIssuersInput) (*ssoadmin.ListTrustedTokenIssuersOutput, error)
	ListTrustedTokenIssuersWithContext(aws.Context, *ssoadmin.ListTrustedTokenIssuersInput, ...request.Option) (*ssoadmin.ListTrustedTokenIssuersOutput, error)
	ListTrustedTokenIssuersRequest(*ssoadmin.ListTrustedTokenIssuersInput) (*request.Request, *ssoadmin.ListTrustedTokenIssuersOutput)

	ListTrustedTokenIssuersPages(*ssoadmin.ListTrustedTokenIssuersInput, func(*ssoadmin.ListTrustedTokenIssuersOutput, bool) bool) error
	ListTrustedTokenIssuersPagesWithContext(aws.Context, *ssoadmin.ListTrustedTokenIssuersInput, func(*ssoadmin.ListTrustedTokenIssuersOutput, bool) bool, ...request.Option) error

	ProvisionPermissionSet(*ssoadmin.ProvisionPermissionSetInput) (*ssoadmin.ProvisionPermissionSetOutput, error)
	ProvisionPermissionSetWithContext(aws.Context, *ssoadmin.ProvisionPermissionSetInput, ...request.Option) (*ssoadmin.ProvisionPermissionSetOutput, error)
	ProvisionPermissionSetRequest(*ssoadmin.ProvisionPermissionSetInput) (*request.Request, *ssoadmin.ProvisionPermissionSetOutput)

	PutApplicationAccessScope(*ssoadmin.PutApplicationAccessScopeInput) (*ssoadmin.PutApplicationAccessScopeOutput, error)
	PutApplicationAccessScopeWithContext(aws.Context, *ssoadmin.PutApplicationAccessScopeInput, ...request.Option) (*ssoadmin.PutApplicationAccessScopeOutput, error)
	PutApplicationAccessScopeRequest(*ssoadmin.PutApplicationAccessScopeInput) (*request.Request, *ssoadmin.PutApplicationAccessScopeOutput)

	PutApplicationAssignmentConfiguration(*ssoadmin.PutApplicationAssignmentConfigurationInput) (*ssoadmin.PutApplicationAssignmentConfigurationOutput, error)
	PutApplicationAssignmentConfigurationWithContext(aws.Context, *ssoadmin.PutApplicationAssignmentConfigurationInput, ...request.Option) (*ssoadmin.PutApplicationAssignmentConfigurationOutput, error)
	PutApplicationAssignmentConfigurationRequest(*ssoadmin.PutApplicationAssignmentConfigurationInput) (*request.Request, *ssoadmin.PutApplicationAssignmentConfigurationOutput)

	PutApplicationAuthenticationMethod(*ssoadmin.PutApplicationAuthenticationMethodInput) (*ssoadmin.PutApplicationAuthenticationMethodOutput, error)
	PutApplicationAuthenticationMethodWithContext(aws.Context, *ssoadmin.PutApplicationAuthenticationMethodInput, ...request.Option) (*ssoadmin.PutApplicationAuthenticationMethodOutput, error)
	PutApplicationAuthenticationMethodRequest(*ssoadmin.PutApplicationAuthenticationMethodInput) (*request.Request, *ssoadmin.PutApplicationAuthenticationMethodOutput)

	PutApplicationGrant(*ssoadmin.PutApplicationGrantInput) (*ssoadmin.PutApplicationGrantOutput, error)
	PutApplicationGrantWithContext(aws.Context, *ssoadmin.PutApplicationGrantInput, ...request.Option) (*ssoadmin.PutApplicationGrantOutput, error)
	PutApplicationGrantRequest(*ssoadmin.PutApplicationGrantInput) (*request.Request, *ssoadmin.PutApplicationGrantOutput)

	PutInlinePolicyToPermissionSet(*ssoadmin.PutInlinePolicyToPermissionSetInput) (*ssoadmin.PutInlinePolicyToPermissionSetOutput, error)
	PutInlinePolicyToPermissionSetWithContext(aws.Context, *ssoadmin.PutInlinePolicyToPermissionSetInput, ...request.Option) (*ssoadmin.PutInlinePolicyToPermissionSetOutput, error)
	PutInlinePolicyToPermissionSetRequest(*ssoadmin.PutInlinePolicyToPermissionSetInput) (*request.Request, *ssoadmin.PutInlinePolicyToPermissionSetOutput)

	PutPermissionsBoundaryToPermissionSet(*ssoadmin.PutPermissionsBoundaryToPermissionSetInput) (*ssoadmin.PutPermissionsBoundaryToPermissionSetOutput, error)
	PutPermissionsBoundaryToPermissionSetWithContext(aws.Context, *ssoadmin.PutPermissionsBoundaryToPermissionSetInput, ...request.Option) (*ssoadmin.PutPermissionsBoundaryToPermissionSetOutput, error)
	PutPermissionsBoundaryToPermissionSetRequest(*ssoadmin.PutPermissionsBoundaryToPermissionSetInput) (*request.Request, *ssoadmin.PutPermissionsBoundaryToPermissionSetOutput)

	TagResource(*ssoadmin.TagResourceInput) (*ssoadmin.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *ssoadmin.TagResourceInput, ...request.Option) (*ssoadmin.TagResourceOutput, error)
	TagResourceRequest(*ssoadmin.TagResourceInput) (*request.Request, *ssoadmin.TagResourceOutput)

	UntagResource(*ssoadmin.UntagResourceInput) (*ssoadmin.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *ssoadmin.UntagResourceInput, ...request.Option) (*ssoadmin.UntagResourceOutput, error)
	UntagResourceRequest(*ssoadmin.UntagResourceInput) (*request.Request, *ssoadmin.UntagResourceOutput)

	UpdateApplication(*ssoadmin.UpdateApplicationInput) (*ssoadmin.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *ssoadmin.UpdateApplicationInput, ...request.Option) (*ssoadmin.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*ssoadmin.UpdateApplicationInput) (*request.Request, *ssoadmin.UpdateApplicationOutput)

	UpdateInstance(*ssoadmin.UpdateInstanceInput) (*ssoadmin.UpdateInstanceOutput, error)
	UpdateInstanceWithContext(aws.Context, *ssoadmin.UpdateInstanceInput, ...request.Option) (*ssoadmin.UpdateInstanceOutput, error)
	UpdateInstanceRequest(*ssoadmin.UpdateInstanceInput) (*request.Request, *ssoadmin.UpdateInstanceOutput)

	UpdateInstanceAccessControlAttributeConfiguration(*ssoadmin.UpdateInstanceAccessControlAttributeConfigurationInput) (*ssoadmin.UpdateInstanceAccessControlAttributeConfigurationOutput, error)
	UpdateInstanceAccessControlAttributeConfigurationWithContext(aws.Context, *ssoadmin.UpdateInstanceAccessControlAttributeConfigurationInput, ...request.Option) (*ssoadmin.UpdateInstanceAccessControlAttributeConfigurationOutput, error)
	UpdateInstanceAccessControlAttributeConfigurationRequest(*ssoadmin.UpdateInstanceAccessControlAttributeConfigurationInput) (*request.Request, *ssoadmin.UpdateInstanceAccessControlAttributeConfigurationOutput)

	UpdatePermissionSet(*ssoadmin.UpdatePermissionSetInput) (*ssoadmin.UpdatePermissionSetOutput, error)
	UpdatePermissionSetWithContext(aws.Context, *ssoadmin.UpdatePermissionSetInput, ...request.Option) (*ssoadmin.UpdatePermissionSetOutput, error)
	UpdatePermissionSetRequest(*ssoadmin.UpdatePermissionSetInput) (*request.Request, *ssoadmin.UpdatePermissionSetOutput)

	UpdateTrustedTokenIssuer(*ssoadmin.UpdateTrustedTokenIssuerInput) (*ssoadmin.UpdateTrustedTokenIssuerOutput, error)
	UpdateTrustedTokenIssuerWithContext(aws.Context, *ssoadmin.UpdateTrustedTokenIssuerInput, ...request.Option) (*ssoadmin.UpdateTrustedTokenIssuerOutput, error)
	UpdateTrustedTokenIssuerRequest(*ssoadmin.UpdateTrustedTokenIssuerInput) (*request.Request, *ssoadmin.UpdateTrustedTokenIssuerOutput)
}

var _ SSOAdminAPI = (*ssoadmin.SSOAdmin)(nil)
